/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.healthcare.v1.model;

/**
 * Specifies FHIR paths to match, and how to handle de-identification of matching fields.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Healthcare API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FieldMetadata extends com.google.api.client.json.GenericJson {

  /**
   * Deidentify action for one field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String action;

  /**
   * List of paths to FHIR fields to be redacted. Each path is a period-separated list where each
   * component is either a field name or FHIR type name, for example: Patient, HumanName. For
   * "choice" types (those defined in the FHIR spec with the form: field[x]) we use two separate
   * components. For example, "deceasedAge.unit" is matched by "Deceased.Age.unit". Supported types
   * are: AdministrativeGenderCode, Base64Binary, Boolean, Code, Date, DateTime, Decimal, HumanName,
   * Id, Instant, Integer, LanguageCode, Markdown, Oid, PositiveInt, String, UnsignedInt, Uri, Uuid,
   * Xhtml.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> paths;

  /**
   * Deidentify action for one field.
   * @return value or {@code null} for none
   */
  public java.lang.String getAction() {
    return action;
  }

  /**
   * Deidentify action for one field.
   * @param action action or {@code null} for none
   */
  public FieldMetadata setAction(java.lang.String action) {
    this.action = action;
    return this;
  }

  /**
   * List of paths to FHIR fields to be redacted. Each path is a period-separated list where each
   * component is either a field name or FHIR type name, for example: Patient, HumanName. For
   * "choice" types (those defined in the FHIR spec with the form: field[x]) we use two separate
   * components. For example, "deceasedAge.unit" is matched by "Deceased.Age.unit". Supported types
   * are: AdministrativeGenderCode, Base64Binary, Boolean, Code, Date, DateTime, Decimal, HumanName,
   * Id, Instant, Integer, LanguageCode, Markdown, Oid, PositiveInt, String, UnsignedInt, Uri, Uuid,
   * Xhtml.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getPaths() {
    return paths;
  }

  /**
   * List of paths to FHIR fields to be redacted. Each path is a period-separated list where each
   * component is either a field name or FHIR type name, for example: Patient, HumanName. For
   * "choice" types (those defined in the FHIR spec with the form: field[x]) we use two separate
   * components. For example, "deceasedAge.unit" is matched by "Deceased.Age.unit". Supported types
   * are: AdministrativeGenderCode, Base64Binary, Boolean, Code, Date, DateTime, Decimal, HumanName,
   * Id, Instant, Integer, LanguageCode, Markdown, Oid, PositiveInt, String, UnsignedInt, Uri, Uuid,
   * Xhtml.
   * @param paths paths or {@code null} for none
   */
  public FieldMetadata setPaths(java.util.List<java.lang.String> paths) {
    this.paths = paths;
    return this;
  }

  @Override
  public FieldMetadata set(String fieldName, Object value) {
    return (FieldMetadata) super.set(fieldName, value);
  }

  @Override
  public FieldMetadata clone() {
    return (FieldMetadata) super.clone();
  }

}
