/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.healthcare.v1.model;

/**
 * Represents a user's consent in terms of the resources that can be accessed and under what
 * conditions.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Healthcare API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleCloudHealthcareV1ConsentPolicy extends com.google.api.client.json.GenericJson {

  /**
   * Required. The request conditions to meet to grant access. In addition to any supported
   * comparison operators, authorization rules may have `IN` operator as well as at most 10 logical
   * operators that are limited to `AND` (`&&`), `OR` (`||`).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Expr authorizationRule;

  /**
   * The resources that this policy applies to. A resource is a match if it matches all the
   * attributes listed here. If empty, this policy applies to all User data mappings for the given
   * user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Attribute> resourceAttributes;

  static {
    // hack to force ProGuard to consider Attribute used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Attribute.class);
  }

  /**
   * Required. The request conditions to meet to grant access. In addition to any supported
   * comparison operators, authorization rules may have `IN` operator as well as at most 10 logical
   * operators that are limited to `AND` (`&&`), `OR` (`||`).
   * @return value or {@code null} for none
   */
  public Expr getAuthorizationRule() {
    return authorizationRule;
  }

  /**
   * Required. The request conditions to meet to grant access. In addition to any supported
   * comparison operators, authorization rules may have `IN` operator as well as at most 10 logical
   * operators that are limited to `AND` (`&&`), `OR` (`||`).
   * @param authorizationRule authorizationRule or {@code null} for none
   */
  public GoogleCloudHealthcareV1ConsentPolicy setAuthorizationRule(Expr authorizationRule) {
    this.authorizationRule = authorizationRule;
    return this;
  }

  /**
   * The resources that this policy applies to. A resource is a match if it matches all the
   * attributes listed here. If empty, this policy applies to all User data mappings for the given
   * user.
   * @return value or {@code null} for none
   */
  public java.util.List<Attribute> getResourceAttributes() {
    return resourceAttributes;
  }

  /**
   * The resources that this policy applies to. A resource is a match if it matches all the
   * attributes listed here. If empty, this policy applies to all User data mappings for the given
   * user.
   * @param resourceAttributes resourceAttributes or {@code null} for none
   */
  public GoogleCloudHealthcareV1ConsentPolicy setResourceAttributes(java.util.List<Attribute> resourceAttributes) {
    this.resourceAttributes = resourceAttributes;
    return this;
  }

  @Override
  public GoogleCloudHealthcareV1ConsentPolicy set(String fieldName, Object value) {
    return (GoogleCloudHealthcareV1ConsentPolicy) super.set(fieldName, value);
  }

  @Override
  public GoogleCloudHealthcareV1ConsentPolicy clone() {
    return (GoogleCloudHealthcareV1ConsentPolicy) super.clone();
  }

}
