/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.healthcare.v1.model;

/**
 * StreamConfig specifies configuration for a streaming DICOM export.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Healthcare API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleCloudHealthcareV1DicomStreamConfig extends com.google.api.client.json.GenericJson {

  /**
   * Results are appended to this table. The server creates a new table in the given BigQuery
   * dataset if the specified table does not exist. To enable the Cloud Healthcare API to write to
   * your BigQuery table, you must give the Cloud Healthcare API service account the
   * bigquery.dataEditor role. The service account is: `service-{PROJECT_NUMBER}@gcp-sa-
   * healthcare.iam.gserviceaccount.com`. The PROJECT_NUMBER identifies the project that the DICOM
   * store resides in. To get the project number, go to the Cloud Console Dashboard. It is
   * recommended to not have a custom schema in the destination table which could conflict with the
   * schema created by the Cloud Healthcare API. Instance deletions are not applied to the
   * destination table. The destination's table schema will be automatically updated in case a new
   * instance's data is incompatible with the current schema. The schema should not be updated
   * manually as this can cause incompatibilies that cannot be resolved automatically. One
   * resolution in this case is to delete the incompatible table and let the server recreate one,
   * though the newly created table only contains data after the table recreation. BigQuery imposes
   * a 1 MB limit on streaming insert row size, therefore any instance that generates more than 1 MB
   * of BigQuery data will not be streamed. If an instance cannot be streamed to BigQuery, errors
   * will be logged to Cloud Logging (see [Viewing error logs in Cloud
   * Logging](https://cloud.google.com/healthcare/docs/how-tos/logging)).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleCloudHealthcareV1DicomBigQueryDestination bigqueryDestination;

  /**
   * Results are appended to this table. The server creates a new table in the given BigQuery
   * dataset if the specified table does not exist. To enable the Cloud Healthcare API to write to
   * your BigQuery table, you must give the Cloud Healthcare API service account the
   * bigquery.dataEditor role. The service account is: `service-{PROJECT_NUMBER}@gcp-sa-
   * healthcare.iam.gserviceaccount.com`. The PROJECT_NUMBER identifies the project that the DICOM
   * store resides in. To get the project number, go to the Cloud Console Dashboard. It is
   * recommended to not have a custom schema in the destination table which could conflict with the
   * schema created by the Cloud Healthcare API. Instance deletions are not applied to the
   * destination table. The destination's table schema will be automatically updated in case a new
   * instance's data is incompatible with the current schema. The schema should not be updated
   * manually as this can cause incompatibilies that cannot be resolved automatically. One
   * resolution in this case is to delete the incompatible table and let the server recreate one,
   * though the newly created table only contains data after the table recreation. BigQuery imposes
   * a 1 MB limit on streaming insert row size, therefore any instance that generates more than 1 MB
   * of BigQuery data will not be streamed. If an instance cannot be streamed to BigQuery, errors
   * will be logged to Cloud Logging (see [Viewing error logs in Cloud
   * Logging](https://cloud.google.com/healthcare/docs/how-tos/logging)).
   * @return value or {@code null} for none
   */
  public GoogleCloudHealthcareV1DicomBigQueryDestination getBigqueryDestination() {
    return bigqueryDestination;
  }

  /**
   * Results are appended to this table. The server creates a new table in the given BigQuery
   * dataset if the specified table does not exist. To enable the Cloud Healthcare API to write to
   * your BigQuery table, you must give the Cloud Healthcare API service account the
   * bigquery.dataEditor role. The service account is: `service-{PROJECT_NUMBER}@gcp-sa-
   * healthcare.iam.gserviceaccount.com`. The PROJECT_NUMBER identifies the project that the DICOM
   * store resides in. To get the project number, go to the Cloud Console Dashboard. It is
   * recommended to not have a custom schema in the destination table which could conflict with the
   * schema created by the Cloud Healthcare API. Instance deletions are not applied to the
   * destination table. The destination's table schema will be automatically updated in case a new
   * instance's data is incompatible with the current schema. The schema should not be updated
   * manually as this can cause incompatibilies that cannot be resolved automatically. One
   * resolution in this case is to delete the incompatible table and let the server recreate one,
   * though the newly created table only contains data after the table recreation. BigQuery imposes
   * a 1 MB limit on streaming insert row size, therefore any instance that generates more than 1 MB
   * of BigQuery data will not be streamed. If an instance cannot be streamed to BigQuery, errors
   * will be logged to Cloud Logging (see [Viewing error logs in Cloud
   * Logging](https://cloud.google.com/healthcare/docs/how-tos/logging)).
   * @param bigqueryDestination bigqueryDestination or {@code null} for none
   */
  public GoogleCloudHealthcareV1DicomStreamConfig setBigqueryDestination(GoogleCloudHealthcareV1DicomBigQueryDestination bigqueryDestination) {
    this.bigqueryDestination = bigqueryDestination;
    return this;
  }

  @Override
  public GoogleCloudHealthcareV1DicomStreamConfig set(String fieldName, Object value) {
    return (GoogleCloudHealthcareV1DicomStreamConfig) super.set(fieldName, value);
  }

  @Override
  public GoogleCloudHealthcareV1DicomStreamConfig clone() {
    return (GoogleCloudHealthcareV1DicomStreamConfig) super.clone();
  }

}
