/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.healthcare.v1.model;

/**
 * List of metrics for a given HL7v2 store.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Healthcare API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Hl7V2StoreMetrics extends com.google.api.client.json.GenericJson {

  /**
   * List of HL7v2 store metrics by message type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Hl7V2StoreMetric> metrics;

  static {
    // hack to force ProGuard to consider Hl7V2StoreMetric used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Hl7V2StoreMetric.class);
  }

  /**
   * The resource name of the HL7v2 store to get metrics for, in the format
   * `projects/{project_id}/datasets/{dataset_id}/hl7V2Stores/{hl7v2_store_id}`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * List of HL7v2 store metrics by message type.
   * @return value or {@code null} for none
   */
  public java.util.List<Hl7V2StoreMetric> getMetrics() {
    return metrics;
  }

  /**
   * List of HL7v2 store metrics by message type.
   * @param metrics metrics or {@code null} for none
   */
  public Hl7V2StoreMetrics setMetrics(java.util.List<Hl7V2StoreMetric> metrics) {
    this.metrics = metrics;
    return this;
  }

  /**
   * The resource name of the HL7v2 store to get metrics for, in the format
   * `projects/{project_id}/datasets/{dataset_id}/hl7V2Stores/{hl7v2_store_id}`.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The resource name of the HL7v2 store to get metrics for, in the format
   * `projects/{project_id}/datasets/{dataset_id}/hl7V2Stores/{hl7v2_store_id}`.
   * @param name name or {@code null} for none
   */
  public Hl7V2StoreMetrics setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  @Override
  public Hl7V2StoreMetrics set(String fieldName, Object value) {
    return (Hl7V2StoreMetrics) super.set(fieldName, value);
  }

  @Override
  public Hl7V2StoreMetrics clone() {
    return (Hl7V2StoreMetrics) super.clone();
  }

}
