/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.healthcare.v1.model;

/**
 * ProgressCounter provides counters to describe an operation's progress.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Healthcare API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ProgressCounter extends com.google.api.client.json.GenericJson {

  /**
   * The number of units that failed in the operation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long failure;

  /**
   * The number of units that are pending in the operation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long pending;

  /**
   * The number of units that succeeded in the operation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long success;

  /**
   * The number of units that failed in the operation.
   * @return value or {@code null} for none
   */
  public java.lang.Long getFailure() {
    return failure;
  }

  /**
   * The number of units that failed in the operation.
   * @param failure failure or {@code null} for none
   */
  public ProgressCounter setFailure(java.lang.Long failure) {
    this.failure = failure;
    return this;
  }

  /**
   * The number of units that are pending in the operation.
   * @return value or {@code null} for none
   */
  public java.lang.Long getPending() {
    return pending;
  }

  /**
   * The number of units that are pending in the operation.
   * @param pending pending or {@code null} for none
   */
  public ProgressCounter setPending(java.lang.Long pending) {
    this.pending = pending;
    return this;
  }

  /**
   * The number of units that succeeded in the operation.
   * @return value or {@code null} for none
   */
  public java.lang.Long getSuccess() {
    return success;
  }

  /**
   * The number of units that succeeded in the operation.
   * @param success success or {@code null} for none
   */
  public ProgressCounter setSuccess(java.lang.Long success) {
    this.success = success;
    return this;
  }

  @Override
  public ProgressCounter set(String fieldName, Object value) {
    return (ProgressCounter) super.set(fieldName, value);
  }

  @Override
  public ProgressCounter clone() {
    return (ProgressCounter) super.clone();
  }

}
