/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.healthcare.v1.model;

/**
 * Queries all data_ids that are consented for a given use in the given consent store and writes
 * them to a specified destination. The returned Operation includes a progress counter for the
 * number of User data mappings processed. Errors are logged to Cloud Logging (see [Viewing error
 * logs in Cloud Logging] (https://cloud.google.com/healthcare/docs/how-tos/logging) and
 * [QueryAccessibleData] for a sample log entry).
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Healthcare API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class QueryAccessibleDataRequest extends com.google.api.client.json.GenericJson {

  /**
   * The Cloud Storage destination. The Cloud Healthcare API service account must have the
   * `roles/storage.objectAdmin` Cloud IAM role for this Cloud Storage location.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleCloudHealthcareV1ConsentGcsDestination gcsDestination;

  /**
   * The values of request attributes associated with this access request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> requestAttributes;

  /**
   * Optional. The values of resource attributes associated with the type of resources being
   * requested. If no values are specified, then all resource types are included in the output.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> resourceAttributes;

  /**
   * The Cloud Storage destination. The Cloud Healthcare API service account must have the
   * `roles/storage.objectAdmin` Cloud IAM role for this Cloud Storage location.
   * @return value or {@code null} for none
   */
  public GoogleCloudHealthcareV1ConsentGcsDestination getGcsDestination() {
    return gcsDestination;
  }

  /**
   * The Cloud Storage destination. The Cloud Healthcare API service account must have the
   * `roles/storage.objectAdmin` Cloud IAM role for this Cloud Storage location.
   * @param gcsDestination gcsDestination or {@code null} for none
   */
  public QueryAccessibleDataRequest setGcsDestination(GoogleCloudHealthcareV1ConsentGcsDestination gcsDestination) {
    this.gcsDestination = gcsDestination;
    return this;
  }

  /**
   * The values of request attributes associated with this access request.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getRequestAttributes() {
    return requestAttributes;
  }

  /**
   * The values of request attributes associated with this access request.
   * @param requestAttributes requestAttributes or {@code null} for none
   */
  public QueryAccessibleDataRequest setRequestAttributes(java.util.Map<String, java.lang.String> requestAttributes) {
    this.requestAttributes = requestAttributes;
    return this;
  }

  /**
   * Optional. The values of resource attributes associated with the type of resources being
   * requested. If no values are specified, then all resource types are included in the output.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getResourceAttributes() {
    return resourceAttributes;
  }

  /**
   * Optional. The values of resource attributes associated with the type of resources being
   * requested. If no values are specified, then all resource types are included in the output.
   * @param resourceAttributes resourceAttributes or {@code null} for none
   */
  public QueryAccessibleDataRequest setResourceAttributes(java.util.Map<String, java.lang.String> resourceAttributes) {
    this.resourceAttributes = resourceAttributes;
    return this;
  }

  @Override
  public QueryAccessibleDataRequest set(String fieldName, Object value) {
    return (QueryAccessibleDataRequest) super.set(fieldName, value);
  }

  @Override
  public QueryAccessibleDataRequest clone() {
    return (QueryAccessibleDataRequest) super.clone();
  }

}
