/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.healthcare.v1.model;

/**
 * Model definition for RollbackFhirResourcesRequest.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Healthcare API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RollbackFhirResourcesRequest extends com.google.api.client.json.GenericJson {

  /**
   * Optional. CREATE/UPDATE/DELETE/ALL for reverting all txns of a certain type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String changeType;

  /**
   * Optional. Specifies whether to exclude earlier rollbacks.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean excludeRollbacks;

  /**
   * Optional. Parameters for filtering resources
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private RollbackFhirResourceFilteringFields filteringFields;

  /**
   * Optional. When enabled, changes will be reverted without explicit confirmation
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean force;

  /**
   * Optional. GCS object containing list of {resourceType}/{resourceId} lines, identifying
   * resources to be reverted
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String inputGcsObject;

  /**
   * Required. Bucket to deposit result
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String resultGcsBucket;

  /**
   * Required. Time point to rollback to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String rollbackTime;

  /**
   * Optional. If specified, revert only resources of these types
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> type;

  /**
   * Optional. CREATE/UPDATE/DELETE/ALL for reverting all txns of a certain type.
   * @return value or {@code null} for none
   */
  public java.lang.String getChangeType() {
    return changeType;
  }

  /**
   * Optional. CREATE/UPDATE/DELETE/ALL for reverting all txns of a certain type.
   * @param changeType changeType or {@code null} for none
   */
  public RollbackFhirResourcesRequest setChangeType(java.lang.String changeType) {
    this.changeType = changeType;
    return this;
  }

  /**
   * Optional. Specifies whether to exclude earlier rollbacks.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getExcludeRollbacks() {
    return excludeRollbacks;
  }

  /**
   * Optional. Specifies whether to exclude earlier rollbacks.
   * @param excludeRollbacks excludeRollbacks or {@code null} for none
   */
  public RollbackFhirResourcesRequest setExcludeRollbacks(java.lang.Boolean excludeRollbacks) {
    this.excludeRollbacks = excludeRollbacks;
    return this;
  }

  /**
   * Optional. Parameters for filtering resources
   * @return value or {@code null} for none
   */
  public RollbackFhirResourceFilteringFields getFilteringFields() {
    return filteringFields;
  }

  /**
   * Optional. Parameters for filtering resources
   * @param filteringFields filteringFields or {@code null} for none
   */
  public RollbackFhirResourcesRequest setFilteringFields(RollbackFhirResourceFilteringFields filteringFields) {
    this.filteringFields = filteringFields;
    return this;
  }

  /**
   * Optional. When enabled, changes will be reverted without explicit confirmation
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getForce() {
    return force;
  }

  /**
   * Optional. When enabled, changes will be reverted without explicit confirmation
   * @param force force or {@code null} for none
   */
  public RollbackFhirResourcesRequest setForce(java.lang.Boolean force) {
    this.force = force;
    return this;
  }

  /**
   * Optional. GCS object containing list of {resourceType}/{resourceId} lines, identifying
   * resources to be reverted
   * @return value or {@code null} for none
   */
  public java.lang.String getInputGcsObject() {
    return inputGcsObject;
  }

  /**
   * Optional. GCS object containing list of {resourceType}/{resourceId} lines, identifying
   * resources to be reverted
   * @param inputGcsObject inputGcsObject or {@code null} for none
   */
  public RollbackFhirResourcesRequest setInputGcsObject(java.lang.String inputGcsObject) {
    this.inputGcsObject = inputGcsObject;
    return this;
  }

  /**
   * Required. Bucket to deposit result
   * @return value or {@code null} for none
   */
  public java.lang.String getResultGcsBucket() {
    return resultGcsBucket;
  }

  /**
   * Required. Bucket to deposit result
   * @param resultGcsBucket resultGcsBucket or {@code null} for none
   */
  public RollbackFhirResourcesRequest setResultGcsBucket(java.lang.String resultGcsBucket) {
    this.resultGcsBucket = resultGcsBucket;
    return this;
  }

  /**
   * Required. Time point to rollback to.
   * @return value or {@code null} for none
   */
  public String getRollbackTime() {
    return rollbackTime;
  }

  /**
   * Required. Time point to rollback to.
   * @param rollbackTime rollbackTime or {@code null} for none
   */
  public RollbackFhirResourcesRequest setRollbackTime(String rollbackTime) {
    this.rollbackTime = rollbackTime;
    return this;
  }

  /**
   * Optional. If specified, revert only resources of these types
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getType() {
    return type;
  }

  /**
   * Optional. If specified, revert only resources of these types
   * @param type type or {@code null} for none
   */
  public RollbackFhirResourcesRequest setType(java.util.List<java.lang.String> type) {
    this.type = type;
    return this;
  }

  @Override
  public RollbackFhirResourcesRequest set(String fieldName, Object value) {
    return (RollbackFhirResourcesRequest) super.set(fieldName, value);
  }

  @Override
  public RollbackFhirResourcesRequest clone() {
    return (RollbackFhirResourcesRequest) super.clone();
  }

}
