/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.healthcare.v1.model;

/**
 * A schema package contains a set of schemas and type definitions.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Healthcare API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SchemaPackage extends com.google.api.client.json.GenericJson {

  /**
   * Flag to ignore all min_occurs restrictions in the schema. This means that incoming messages can
   * omit any group, segment, field, component, or subcomponent.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean ignoreMinOccurs;

  /**
   * Schema configs that are layered based on their VersionSources that match the incoming message.
   * Schema configs present in higher indices override those in lower indices with the same message
   * type and trigger event if their VersionSources all match an incoming message.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Hl7SchemaConfig> schemas;

  static {
    // hack to force ProGuard to consider Hl7SchemaConfig used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Hl7SchemaConfig.class);
  }

  /**
   * Determines how messages that fail to parse are handled.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String schematizedParsingType;

  /**
   * Schema type definitions that are layered based on their VersionSources that match the incoming
   * message. Type definitions present in higher indices override those in lower indices with the
   * same type name if their VersionSources all match an incoming message.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Hl7TypesConfig> types;

  static {
    // hack to force ProGuard to consider Hl7TypesConfig used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Hl7TypesConfig.class);
  }

  /**
   * Determines how unexpected segments (segments not matched to the schema) are handled.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String unexpectedSegmentHandling;

  /**
   * Flag to ignore all min_occurs restrictions in the schema. This means that incoming messages can
   * omit any group, segment, field, component, or subcomponent.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIgnoreMinOccurs() {
    return ignoreMinOccurs;
  }

  /**
   * Flag to ignore all min_occurs restrictions in the schema. This means that incoming messages can
   * omit any group, segment, field, component, or subcomponent.
   * @param ignoreMinOccurs ignoreMinOccurs or {@code null} for none
   */
  public SchemaPackage setIgnoreMinOccurs(java.lang.Boolean ignoreMinOccurs) {
    this.ignoreMinOccurs = ignoreMinOccurs;
    return this;
  }

  /**
   * Schema configs that are layered based on their VersionSources that match the incoming message.
   * Schema configs present in higher indices override those in lower indices with the same message
   * type and trigger event if their VersionSources all match an incoming message.
   * @return value or {@code null} for none
   */
  public java.util.List<Hl7SchemaConfig> getSchemas() {
    return schemas;
  }

  /**
   * Schema configs that are layered based on their VersionSources that match the incoming message.
   * Schema configs present in higher indices override those in lower indices with the same message
   * type and trigger event if their VersionSources all match an incoming message.
   * @param schemas schemas or {@code null} for none
   */
  public SchemaPackage setSchemas(java.util.List<Hl7SchemaConfig> schemas) {
    this.schemas = schemas;
    return this;
  }

  /**
   * Determines how messages that fail to parse are handled.
   * @return value or {@code null} for none
   */
  public java.lang.String getSchematizedParsingType() {
    return schematizedParsingType;
  }

  /**
   * Determines how messages that fail to parse are handled.
   * @param schematizedParsingType schematizedParsingType or {@code null} for none
   */
  public SchemaPackage setSchematizedParsingType(java.lang.String schematizedParsingType) {
    this.schematizedParsingType = schematizedParsingType;
    return this;
  }

  /**
   * Schema type definitions that are layered based on their VersionSources that match the incoming
   * message. Type definitions present in higher indices override those in lower indices with the
   * same type name if their VersionSources all match an incoming message.
   * @return value or {@code null} for none
   */
  public java.util.List<Hl7TypesConfig> getTypes() {
    return types;
  }

  /**
   * Schema type definitions that are layered based on their VersionSources that match the incoming
   * message. Type definitions present in higher indices override those in lower indices with the
   * same type name if their VersionSources all match an incoming message.
   * @param types types or {@code null} for none
   */
  public SchemaPackage setTypes(java.util.List<Hl7TypesConfig> types) {
    this.types = types;
    return this;
  }

  /**
   * Determines how unexpected segments (segments not matched to the schema) are handled.
   * @return value or {@code null} for none
   */
  public java.lang.String getUnexpectedSegmentHandling() {
    return unexpectedSegmentHandling;
  }

  /**
   * Determines how unexpected segments (segments not matched to the schema) are handled.
   * @param unexpectedSegmentHandling unexpectedSegmentHandling or {@code null} for none
   */
  public SchemaPackage setUnexpectedSegmentHandling(java.lang.String unexpectedSegmentHandling) {
    this.unexpectedSegmentHandling = unexpectedSegmentHandling;
    return this;
  }

  @Override
  public SchemaPackage set(String fieldName, Object value) {
    return (SchemaPackage) super.set(fieldName, value);
  }

  @Override
  public SchemaPackage clone() {
    return (SchemaPackage) super.clone();
  }

}
