/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.healthcare.v1.model;

/**
 * StudyMetrics contains metrics describing a DICOM study.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Healthcare API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class StudyMetrics extends com.google.api.client.json.GenericJson {

  /**
   * Total blob storage bytes for all instances in the study.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long blobStorageSizeBytes;

  /**
   * Number of instances in the study.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long instanceCount;

  /**
   * Number of series in the study.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long seriesCount;

  /**
   * Total structured storage bytes for all instances in the study.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long structuredStorageSizeBytes;

  /**
   * The study resource path. For example, `projects/{project_id}/locations/{location_id}/datasets/{
   * dataset_id}/dicomStores/{dicom_store_id}/dicomWeb/studies/{study_uid}`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String study;

  /**
   * Total blob storage bytes for all instances in the study.
   * @return value or {@code null} for none
   */
  public java.lang.Long getBlobStorageSizeBytes() {
    return blobStorageSizeBytes;
  }

  /**
   * Total blob storage bytes for all instances in the study.
   * @param blobStorageSizeBytes blobStorageSizeBytes or {@code null} for none
   */
  public StudyMetrics setBlobStorageSizeBytes(java.lang.Long blobStorageSizeBytes) {
    this.blobStorageSizeBytes = blobStorageSizeBytes;
    return this;
  }

  /**
   * Number of instances in the study.
   * @return value or {@code null} for none
   */
  public java.lang.Long getInstanceCount() {
    return instanceCount;
  }

  /**
   * Number of instances in the study.
   * @param instanceCount instanceCount or {@code null} for none
   */
  public StudyMetrics setInstanceCount(java.lang.Long instanceCount) {
    this.instanceCount = instanceCount;
    return this;
  }

  /**
   * Number of series in the study.
   * @return value or {@code null} for none
   */
  public java.lang.Long getSeriesCount() {
    return seriesCount;
  }

  /**
   * Number of series in the study.
   * @param seriesCount seriesCount or {@code null} for none
   */
  public StudyMetrics setSeriesCount(java.lang.Long seriesCount) {
    this.seriesCount = seriesCount;
    return this;
  }

  /**
   * Total structured storage bytes for all instances in the study.
   * @return value or {@code null} for none
   */
  public java.lang.Long getStructuredStorageSizeBytes() {
    return structuredStorageSizeBytes;
  }

  /**
   * Total structured storage bytes for all instances in the study.
   * @param structuredStorageSizeBytes structuredStorageSizeBytes or {@code null} for none
   */
  public StudyMetrics setStructuredStorageSizeBytes(java.lang.Long structuredStorageSizeBytes) {
    this.structuredStorageSizeBytes = structuredStorageSizeBytes;
    return this;
  }

  /**
   * The study resource path. For example, `projects/{project_id}/locations/{location_id}/datasets/{
   * dataset_id}/dicomStores/{dicom_store_id}/dicomWeb/studies/{study_uid}`.
   * @return value or {@code null} for none
   */
  public java.lang.String getStudy() {
    return study;
  }

  /**
   * The study resource path. For example, `projects/{project_id}/locations/{location_id}/datasets/{
   * dataset_id}/dicomStores/{dicom_store_id}/dicomWeb/studies/{study_uid}`.
   * @param study study or {@code null} for none
   */
  public StudyMetrics setStudy(java.lang.String study) {
    this.study = study;
    return this;
  }

  @Override
  public StudyMetrics set(String fieldName, Object value) {
    return (StudyMetrics) super.set(fieldName, value);
  }

  @Override
  public StudyMetrics clone() {
    return (StudyMetrics) super.clone();
  }

}
