/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.healthcare.v1.model;

/**
 * A type definition for some HL7v2 type (incl. Segments and Datatypes).
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Healthcare API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Type extends com.google.api.client.json.GenericJson {

  /**
   * The (sub) fields this type has (if not primitive).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Field> fields;

  static {
    // hack to force ProGuard to consider Field used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Field.class);
  }

  /**
   * The name of this type. This would be the segment or datatype name. For example, "PID" or "XPN".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * If this is a primitive type then this field is the type of the primitive For example, STRING.
   * Leave unspecified for composite types.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String primitive;

  /**
   * The (sub) fields this type has (if not primitive).
   * @return value or {@code null} for none
   */
  public java.util.List<Field> getFields() {
    return fields;
  }

  /**
   * The (sub) fields this type has (if not primitive).
   * @param fields fields or {@code null} for none
   */
  public Type setFields(java.util.List<Field> fields) {
    this.fields = fields;
    return this;
  }

  /**
   * The name of this type. This would be the segment or datatype name. For example, "PID" or "XPN".
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of this type. This would be the segment or datatype name. For example, "PID" or "XPN".
   * @param name name or {@code null} for none
   */
  public Type setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * If this is a primitive type then this field is the type of the primitive For example, STRING.
   * Leave unspecified for composite types.
   * @return value or {@code null} for none
   */
  public java.lang.String getPrimitive() {
    return primitive;
  }

  /**
   * If this is a primitive type then this field is the type of the primitive For example, STRING.
   * Leave unspecified for composite types.
   * @param primitive primitive or {@code null} for none
   */
  public Type setPrimitive(java.lang.String primitive) {
    this.primitive = primitive;
    return this;
  }

  @Override
  public Type set(String fieldName, Object value) {
    return (Type) super.set(fieldName, value);
  }

  @Override
  public Type clone() {
    return (Type) super.clone();
  }

}
