/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.healthcare.v1.model;

/**
 * Maps a resource to the associated user and Attributes.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Healthcare API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UserDataMapping extends com.google.api.client.json.GenericJson {

  /**
   * Output only. Indicates the time when this mapping was archived.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String archiveTime;

  /**
   * Output only. Indicates whether this mapping is archived.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean archived;

  /**
   * Required. A unique identifier for the mapped resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String dataId;

  /**
   * Resource name of the User data mapping, of the form `projects/{project_id}/locations/{location_
   * id}/datasets/{dataset_id}/consentStores/{consent_store_id}/userDataMappings/{user_data_mapping_
   * id}`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Attributes of the resource. Only explicitly set attributes are displayed here. Attribute
   * definitions with defaults set implicitly apply to these User data mappings. Attributes listed
   * here must be single valued, that is, exactly one value is specified for the field "values" in
   * each Attribute.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Attribute> resourceAttributes;

  static {
    // hack to force ProGuard to consider Attribute used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Attribute.class);
  }

  /**
   * Required. User's UUID provided by the client.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String userId;

  /**
   * Output only. Indicates the time when this mapping was archived.
   * @return value or {@code null} for none
   */
  public String getArchiveTime() {
    return archiveTime;
  }

  /**
   * Output only. Indicates the time when this mapping was archived.
   * @param archiveTime archiveTime or {@code null} for none
   */
  public UserDataMapping setArchiveTime(String archiveTime) {
    this.archiveTime = archiveTime;
    return this;
  }

  /**
   * Output only. Indicates whether this mapping is archived.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getArchived() {
    return archived;
  }

  /**
   * Output only. Indicates whether this mapping is archived.
   * @param archived archived or {@code null} for none
   */
  public UserDataMapping setArchived(java.lang.Boolean archived) {
    this.archived = archived;
    return this;
  }

  /**
   * Required. A unique identifier for the mapped resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getDataId() {
    return dataId;
  }

  /**
   * Required. A unique identifier for the mapped resource.
   * @param dataId dataId or {@code null} for none
   */
  public UserDataMapping setDataId(java.lang.String dataId) {
    this.dataId = dataId;
    return this;
  }

  /**
   * Resource name of the User data mapping, of the form `projects/{project_id}/locations/{location_
   * id}/datasets/{dataset_id}/consentStores/{consent_store_id}/userDataMappings/{user_data_mapping_
   * id}`.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Resource name of the User data mapping, of the form `projects/{project_id}/locations/{location_
   * id}/datasets/{dataset_id}/consentStores/{consent_store_id}/userDataMappings/{user_data_mapping_
   * id}`.
   * @param name name or {@code null} for none
   */
  public UserDataMapping setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Attributes of the resource. Only explicitly set attributes are displayed here. Attribute
   * definitions with defaults set implicitly apply to these User data mappings. Attributes listed
   * here must be single valued, that is, exactly one value is specified for the field "values" in
   * each Attribute.
   * @return value or {@code null} for none
   */
  public java.util.List<Attribute> getResourceAttributes() {
    return resourceAttributes;
  }

  /**
   * Attributes of the resource. Only explicitly set attributes are displayed here. Attribute
   * definitions with defaults set implicitly apply to these User data mappings. Attributes listed
   * here must be single valued, that is, exactly one value is specified for the field "values" in
   * each Attribute.
   * @param resourceAttributes resourceAttributes or {@code null} for none
   */
  public UserDataMapping setResourceAttributes(java.util.List<Attribute> resourceAttributes) {
    this.resourceAttributes = resourceAttributes;
    return this;
  }

  /**
   * Required. User's UUID provided by the client.
   * @return value or {@code null} for none
   */
  public java.lang.String getUserId() {
    return userId;
  }

  /**
   * Required. User's UUID provided by the client.
   * @param userId userId or {@code null} for none
   */
  public UserDataMapping setUserId(java.lang.String userId) {
    this.userId = userId;
    return this;
  }

  @Override
  public UserDataMapping set(String fieldName, Object value) {
    return (UserDataMapping) super.set(fieldName, value);
  }

  @Override
  public UserDataMapping clone() {
    return (UserDataMapping) super.clone();
  }

}
