/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.healthcare.v1.model;

/**
 * Contains the configuration for FHIR profiles and validation.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Healthcare API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ValidationConfig extends com.google.api.client.json.GenericJson {

  /**
   * Whether to disable FHIRPath validation for incoming resources. Set this to true to disable
   * checking incoming resources for conformance against FHIRPath requirement defined in the FHIR
   * specification. This property only affects resource types that do not have profiles configured
   * for them, any rules in enabled implementation guides will still be enforced.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean disableFhirpathValidation;

  /**
   * Whether to disable profile validation for this FHIR store. Set this to true to disable checking
   * incoming resources for conformance against structure definitions in this FHIR store.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean disableProfileValidation;

  /**
   * Whether to disable reference type validation for incoming resources. Set this to true to
   * disable checking incoming resources for conformance against reference type requirement defined
   * in the FHIR specification. This property only affects resource types that do not have profiles
   * configured for them, any rules in enabled implementation guides will still be enforced.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean disableReferenceTypeValidation;

  /**
   * Whether to disable required fields validation for incoming resources. Set this to true to
   * disable checking incoming resources for conformance against required fields requirement defined
   * in the FHIR specification. This property only affects resource types that do not have profiles
   * configured for them, any rules in enabled implementation guides will still be enforced.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean disableRequiredFieldValidation;

  /**
   * A list of implementation guide URLs in this FHIR store that are used to configure the profiles
   * to use for validation. For example, to use the US Core profiles for validation, set
   * `enabled_implementation_guides` to `["http://hl7.org/fhir/us/core/ImplementationGuide/ig"]`. If
   * `enabled_implementation_guides` is empty or omitted, then incoming resources are only required
   * to conform to the base FHIR profiles. Otherwise, a resource must conform to at least one
   * profile listed in the `global` property of one of the enabled ImplementationGuides. The Cloud
   * Healthcare API does not currently enforce all of the rules in a StructureDefinition. The
   * following rules are supported: - min/max - minValue/maxValue - maxLength - type - fixed[x] -
   * pattern[x] on simple types - slicing, when using "value" as the discriminator type When a URL
   * cannot be resolved (for example, in a type assertion), the server does not return an error.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> enabledImplementationGuides;

  /**
   * Whether to disable FHIRPath validation for incoming resources. Set this to true to disable
   * checking incoming resources for conformance against FHIRPath requirement defined in the FHIR
   * specification. This property only affects resource types that do not have profiles configured
   * for them, any rules in enabled implementation guides will still be enforced.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDisableFhirpathValidation() {
    return disableFhirpathValidation;
  }

  /**
   * Whether to disable FHIRPath validation for incoming resources. Set this to true to disable
   * checking incoming resources for conformance against FHIRPath requirement defined in the FHIR
   * specification. This property only affects resource types that do not have profiles configured
   * for them, any rules in enabled implementation guides will still be enforced.
   * @param disableFhirpathValidation disableFhirpathValidation or {@code null} for none
   */
  public ValidationConfig setDisableFhirpathValidation(java.lang.Boolean disableFhirpathValidation) {
    this.disableFhirpathValidation = disableFhirpathValidation;
    return this;
  }

  /**
   * Whether to disable profile validation for this FHIR store. Set this to true to disable checking
   * incoming resources for conformance against structure definitions in this FHIR store.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDisableProfileValidation() {
    return disableProfileValidation;
  }

  /**
   * Whether to disable profile validation for this FHIR store. Set this to true to disable checking
   * incoming resources for conformance against structure definitions in this FHIR store.
   * @param disableProfileValidation disableProfileValidation or {@code null} for none
   */
  public ValidationConfig setDisableProfileValidation(java.lang.Boolean disableProfileValidation) {
    this.disableProfileValidation = disableProfileValidation;
    return this;
  }

  /**
   * Whether to disable reference type validation for incoming resources. Set this to true to
   * disable checking incoming resources for conformance against reference type requirement defined
   * in the FHIR specification. This property only affects resource types that do not have profiles
   * configured for them, any rules in enabled implementation guides will still be enforced.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDisableReferenceTypeValidation() {
    return disableReferenceTypeValidation;
  }

  /**
   * Whether to disable reference type validation for incoming resources. Set this to true to
   * disable checking incoming resources for conformance against reference type requirement defined
   * in the FHIR specification. This property only affects resource types that do not have profiles
   * configured for them, any rules in enabled implementation guides will still be enforced.
   * @param disableReferenceTypeValidation disableReferenceTypeValidation or {@code null} for none
   */
  public ValidationConfig setDisableReferenceTypeValidation(java.lang.Boolean disableReferenceTypeValidation) {
    this.disableReferenceTypeValidation = disableReferenceTypeValidation;
    return this;
  }

  /**
   * Whether to disable required fields validation for incoming resources. Set this to true to
   * disable checking incoming resources for conformance against required fields requirement defined
   * in the FHIR specification. This property only affects resource types that do not have profiles
   * configured for them, any rules in enabled implementation guides will still be enforced.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDisableRequiredFieldValidation() {
    return disableRequiredFieldValidation;
  }

  /**
   * Whether to disable required fields validation for incoming resources. Set this to true to
   * disable checking incoming resources for conformance against required fields requirement defined
   * in the FHIR specification. This property only affects resource types that do not have profiles
   * configured for them, any rules in enabled implementation guides will still be enforced.
   * @param disableRequiredFieldValidation disableRequiredFieldValidation or {@code null} for none
   */
  public ValidationConfig setDisableRequiredFieldValidation(java.lang.Boolean disableRequiredFieldValidation) {
    this.disableRequiredFieldValidation = disableRequiredFieldValidation;
    return this;
  }

  /**
   * A list of implementation guide URLs in this FHIR store that are used to configure the profiles
   * to use for validation. For example, to use the US Core profiles for validation, set
   * `enabled_implementation_guides` to `["http://hl7.org/fhir/us/core/ImplementationGuide/ig"]`. If
   * `enabled_implementation_guides` is empty or omitted, then incoming resources are only required
   * to conform to the base FHIR profiles. Otherwise, a resource must conform to at least one
   * profile listed in the `global` property of one of the enabled ImplementationGuides. The Cloud
   * Healthcare API does not currently enforce all of the rules in a StructureDefinition. The
   * following rules are supported: - min/max - minValue/maxValue - maxLength - type - fixed[x] -
   * pattern[x] on simple types - slicing, when using "value" as the discriminator type When a URL
   * cannot be resolved (for example, in a type assertion), the server does not return an error.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getEnabledImplementationGuides() {
    return enabledImplementationGuides;
  }

  /**
   * A list of implementation guide URLs in this FHIR store that are used to configure the profiles
   * to use for validation. For example, to use the US Core profiles for validation, set
   * `enabled_implementation_guides` to `["http://hl7.org/fhir/us/core/ImplementationGuide/ig"]`. If
   * `enabled_implementation_guides` is empty or omitted, then incoming resources are only required
   * to conform to the base FHIR profiles. Otherwise, a resource must conform to at least one
   * profile listed in the `global` property of one of the enabled ImplementationGuides. The Cloud
   * Healthcare API does not currently enforce all of the rules in a StructureDefinition. The
   * following rules are supported: - min/max - minValue/maxValue - maxLength - type - fixed[x] -
   * pattern[x] on simple types - slicing, when using "value" as the discriminator type When a URL
   * cannot be resolved (for example, in a type assertion), the server does not return an error.
   * @param enabledImplementationGuides enabledImplementationGuides or {@code null} for none
   */
  public ValidationConfig setEnabledImplementationGuides(java.util.List<java.lang.String> enabledImplementationGuides) {
    this.enabledImplementationGuides = enabledImplementationGuides;
    return this;
  }

  @Override
  public ValidationConfig set(String fieldName, Object value) {
    return (ValidationConfig) super.set(fieldName, value);
  }

  @Override
  public ValidationConfig clone() {
    return (ValidationConfig) super.clone();
  }

}
