/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.translate.model;

/**
 * Model definition for DetectionsResourceItems.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Cloud Translation API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DetectionsResourceItems extends com.google.api.client.json.GenericJson {

  /**
   * The confidence of the detection result of this language.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float confidence;

  /**
   * A boolean to indicate is the language detection result reliable.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isReliable;

  /**
   * The language we detected.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String language;

  /**
   * The confidence of the detection result of this language.
   * @return value or {@code null} for none
   */
  public java.lang.Float getConfidence() {
    return confidence;
  }

  /**
   * The confidence of the detection result of this language.
   * @param confidence confidence or {@code null} for none
   */
  public DetectionsResourceItems setConfidence(java.lang.Float confidence) {
    this.confidence = confidence;
    return this;
  }

  /**
   * A boolean to indicate is the language detection result reliable.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsReliable() {
    return isReliable;
  }

  /**
   * A boolean to indicate is the language detection result reliable.
   * @param isReliable isReliable or {@code null} for none
   */
  public DetectionsResourceItems setIsReliable(java.lang.Boolean isReliable) {
    this.isReliable = isReliable;
    return this;
  }

  /**
   * The language we detected.
   * @return value or {@code null} for none
   */
  public java.lang.String getLanguage() {
    return language;
  }

  /**
   * The language we detected.
   * @param language language or {@code null} for none
   */
  public DetectionsResourceItems setLanguage(java.lang.String language) {
    this.language = language;
    return this;
  }

  @Override
  public DetectionsResourceItems set(String fieldName, Object value) {
    return (DetectionsResourceItems) super.set(fieldName, value);
  }

  @Override
  public DetectionsResourceItems clone() {
    return (DetectionsResourceItems) super.clone();
  }

}
