/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.translate.model;

/**
 * Model definition for TranslationsResource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Cloud Translation API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TranslationsResource extends com.google.api.client.json.GenericJson {

  /**
   * The source language of the initial request, detected automatically, if no source language was
   * passed within the initial request. If the source language was passed, auto-detection of the
   * language will not occur and this field will be empty.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String detectedSourceLanguage;

  /**
   * The `model` type used for this translation. Valid values are listed in public documentation.
   * Can be different from requested `model`. Present only if specific model type was explicitly
   * requested.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String model;

  /**
   * Text translated into the target language.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String translatedText;

  /**
   * The source language of the initial request, detected automatically, if no source language was
   * passed within the initial request. If the source language was passed, auto-detection of the
   * language will not occur and this field will be empty.
   * @return value or {@code null} for none
   */
  public java.lang.String getDetectedSourceLanguage() {
    return detectedSourceLanguage;
  }

  /**
   * The source language of the initial request, detected automatically, if no source language was
   * passed within the initial request. If the source language was passed, auto-detection of the
   * language will not occur and this field will be empty.
   * @param detectedSourceLanguage detectedSourceLanguage or {@code null} for none
   */
  public TranslationsResource setDetectedSourceLanguage(java.lang.String detectedSourceLanguage) {
    this.detectedSourceLanguage = detectedSourceLanguage;
    return this;
  }

  /**
   * The `model` type used for this translation. Valid values are listed in public documentation.
   * Can be different from requested `model`. Present only if specific model type was explicitly
   * requested.
   * @return value or {@code null} for none
   */
  public java.lang.String getModel() {
    return model;
  }

  /**
   * The `model` type used for this translation. Valid values are listed in public documentation.
   * Can be different from requested `model`. Present only if specific model type was explicitly
   * requested.
   * @param model model or {@code null} for none
   */
  public TranslationsResource setModel(java.lang.String model) {
    this.model = model;
    return this;
  }

  /**
   * Text translated into the target language.
   * @return value or {@code null} for none
   */
  public java.lang.String getTranslatedText() {
    return translatedText;
  }

  /**
   * Text translated into the target language.
   * @param translatedText translatedText or {@code null} for none
   */
  public TranslationsResource setTranslatedText(java.lang.String translatedText) {
    this.translatedText = translatedText;
    return this;
  }

  @Override
  public TranslationsResource set(String fieldName, Object value) {
    return (TranslationsResource) super.set(fieldName, value);
  }

  @Override
  public TranslationsResource clone() {
    return (TranslationsResource) super.clone();
  }

}
