/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.CloudDatastoreV1Client;
import com.google.appengine.api.datastore.DataTypeTranslator;
import com.google.appengine.api.datastore.DatastoreApiHelper;
import com.google.appengine.api.datastore.DatastoreServiceConfig;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.InternalTransactionCloudDatastoreV1;
import com.google.appengine.api.datastore.Projection;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.QueryResultsSource;
import com.google.appengine.api.datastore.QueryResultsSourceCloudDatastoreV1;
import com.google.appengine.api.datastore.QueryRunner;
import com.google.appengine.api.datastore.ReadPolicy;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.datastore.TransactionImpl;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.appengine.repackaged.com.google.datastore.v1.CompositeFilter;
import com.google.appengine.repackaged.com.google.datastore.v1.PartitionId;
import com.google.appengine.repackaged.com.google.datastore.v1.Projection;
import com.google.appengine.repackaged.com.google.datastore.v1.PropertyFilter;
import com.google.appengine.repackaged.com.google.datastore.v1.PropertyOrder;
import com.google.appengine.repackaged.com.google.datastore.v1.PropertyReference;
import com.google.appengine.repackaged.com.google.datastore.v1.Query;
import com.google.appengine.repackaged.com.google.datastore.v1.ReadOptions;
import com.google.appengine.repackaged.com.google.datastore.v1.RunQueryRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.RunQueryResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.Value;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.Future;

final class QueryRunnerCloudDatastoreV1
implements QueryRunner {
    private final DatastoreServiceConfig datastoreServiceConfig;
    private final CloudDatastoreV1Client cloudDatastoreV1Client;

    QueryRunnerCloudDatastoreV1(DatastoreServiceConfig datastoreServiceConfig, CloudDatastoreV1Client cloudDatastoreV1Client) {
        this.datastoreServiceConfig = datastoreServiceConfig;
        this.cloudDatastoreV1Client = cloudDatastoreV1Client;
    }

    @Override
    public QueryResultsSource runQuery(FetchOptions fetchOptions, Query query, Transaction txn) {
        RunQueryRequest.Builder queryBldr = QueryRunnerCloudDatastoreV1.toV1Query(query, fetchOptions);
        if (txn != null) {
            TransactionImpl.ensureTxnActive(txn);
            queryBldr.getReadOptionsBuilder().setTransaction(InternalTransactionCloudDatastoreV1.get(txn).getTransactionBytes());
        } else if (this.datastoreServiceConfig.getReadPolicy().getConsistency() == ReadPolicy.Consistency.EVENTUAL) {
            queryBldr.getReadOptionsBuilder().setReadConsistency(ReadOptions.ReadConsistency.EVENTUAL);
        }
        RunQueryRequest request = queryBldr.build();
        Future<RunQueryResponse> result = this.cloudDatastoreV1Client.runQuery(request);
        return new QueryResultsSourceCloudDatastoreV1(this.datastoreServiceConfig.getDatastoreCallbacks(), fetchOptions, txn, query, request, result, this.cloudDatastoreV1Client);
    }

    static RunQueryRequest.Builder toV1Query(Query query, FetchOptions fetchOptions) {
        String name;
        if (query.getFilter() != null) {
            throw new IllegalArgumentException("Geo-spatial queries are not supported in the v1 protocol.");
        }
        RunQueryRequest.Builder requestBldr = RunQueryRequest.newBuilder();
        PartitionId.Builder partitionId = requestBldr.getPartitionIdBuilder().setProjectId(DatastoreApiHelper.toProjectId(query.getAppId()));
        if (!query.getNamespace().isEmpty()) {
            partitionId.setNamespaceId(query.getNamespace());
        }
        Query.Builder queryBldr = requestBldr.getQueryBuilder();
        if (query.getKind() != null) {
            queryBldr.addKindBuilder().setName(query.getKind());
        }
        if (fetchOptions.getOffset() != null) {
            queryBldr.setOffset(fetchOptions.getOffset());
        }
        if (fetchOptions.getLimit() != null) {
            queryBldr.getLimitBuilder().setValue(fetchOptions.getLimit());
        }
        if (fetchOptions.getStartCursor() != null) {
            queryBldr.setStartCursor(fetchOptions.getStartCursor().toByteString());
        }
        if (fetchOptions.getEndCursor() != null) {
            queryBldr.setEndCursor(fetchOptions.getEndCursor().toByteString());
        }
        HashSet<String> groupByProperties = Sets.newHashSet();
        if (query.getDistinct()) {
            if (query.getProjections().isEmpty()) {
                throw new IllegalArgumentException("Projected properties must be set to allow for distinct projections");
            }
            for (Projection projection : query.getProjections()) {
                name = projection.getPropertyName();
                groupByProperties.add(name);
                queryBldr.addDistinctOnBuilder().setName(name);
            }
        }
        if (query.isKeysOnly() && !query.getProjections().isEmpty()) {
            throw new IllegalArgumentException("A query cannot have both projections and keys-only set.");
        }
        for (Projection projection : query.getProjections()) {
            name = projection.getPropertyName();
            if ("__key__".equals(name)) {
                throw new IllegalArgumentException("projections are not supported for the property: __key__");
            }
            Projection.Builder projBuilder = queryBldr.addProjectionBuilder();
            projBuilder.getPropertyBuilder().setName(name);
        }
        if (query.isKeysOnly()) {
            Projection.Builder projBuilder = queryBldr.addProjectionBuilder();
            projBuilder.getPropertyBuilder().setName("__key__");
        }
        CompositeFilter.Builder compositeFilter = CompositeFilter.newBuilder();
        if (query.getAncestor() != null) {
            compositeFilter.addFiltersBuilder().getPropertyFilterBuilder().setOp(PropertyFilter.Operator.HAS_ANCESTOR).setProperty(PropertyReference.newBuilder().setName("__key__")).setValue(Value.newBuilder().setKeyValue(DataTypeTranslator.toV1Key(query.getAncestor())));
        }
        for (Query.FilterPredicate filterPredicate : query.getFilterPredicates()) {
            compositeFilter.addFiltersBuilder().setPropertyFilter(QueryRunnerCloudDatastoreV1.toV1PropertyFilter(filterPredicate));
        }
        if (compositeFilter.getFiltersCount() == 1) {
            queryBldr.setFilter(compositeFilter.getFilters(0));
        } else if (compositeFilter.getFiltersCount() > 1) {
            queryBldr.getFilterBuilder().setCompositeFilter(compositeFilter.setOp(CompositeFilter.Operator.AND));
        }
        for (Query.SortPredicate sortPredicate : query.getSortPredicates()) {
            queryBldr.addOrder(QueryRunnerCloudDatastoreV1.toV1PropertyOrder(sortPredicate));
        }
        return requestBldr;
    }

    private static PropertyFilter.Builder toV1PropertyFilter(Query.FilterPredicate predicate) {
        PropertyFilter.Builder filter = PropertyFilter.newBuilder();
        Query.FilterOperator operator = predicate.getOperator();
        Object value = predicate.getValue();
        if (operator == Query.FilterOperator.IN) {
            if (!(predicate.getValue() instanceof Collection)) {
                throw new IllegalArgumentException("IN filter value is not a Collection.");
            }
            Collection valueCollection = (Collection)value;
            if (valueCollection.size() != 1) {
                throw new IllegalArgumentException("This service only supports 1 object for IN.");
            }
            operator = Query.FilterOperator.EQUAL;
            value = valueCollection.iterator().next();
        }
        filter.setOp(QueryRunnerCloudDatastoreV1.toV1PropertyFilterOperator(operator));
        filter.getPropertyBuilder().setName(predicate.getPropertyName());
        filter.setValue(DataTypeTranslator.toV1ValueForQuery(value));
        return filter;
    }

    private static PropertyFilter.Operator toV1PropertyFilterOperator(Query.FilterOperator operator) {
        switch (operator) {
            case LESS_THAN: {
                return PropertyFilter.Operator.LESS_THAN;
            }
            case LESS_THAN_OR_EQUAL: {
                return PropertyFilter.Operator.LESS_THAN_OR_EQUAL;
            }
            case GREATER_THAN: {
                return PropertyFilter.Operator.GREATER_THAN;
            }
            case GREATER_THAN_OR_EQUAL: {
                return PropertyFilter.Operator.GREATER_THAN_OR_EQUAL;
            }
            case EQUAL: {
                return PropertyFilter.Operator.EQUAL;
            }
        }
        String string = String.valueOf((Object)operator);
        throw new IllegalArgumentException(new StringBuilder(15 + String.valueOf(string).length()).append("Can't convert: ").append(string).toString());
    }

    private static PropertyOrder.Builder toV1PropertyOrder(Query.SortPredicate predicate) {
        return PropertyOrder.newBuilder().setProperty(PropertyReference.newBuilder().setName(predicate.getPropertyName())).setDirection(QueryRunnerCloudDatastoreV1.toV1PropertyOrderDirection(predicate.getDirection()));
    }

    private static PropertyOrder.Direction toV1PropertyOrderDirection(Query.SortDirection direction) {
        switch (direction) {
            case ASCENDING: {
                return PropertyOrder.Direction.ASCENDING;
            }
            case DESCENDING: {
                return PropertyOrder.Direction.DESCENDING;
            }
        }
        String string = String.valueOf((Object)direction);
        throw new IllegalArgumentException(new StringBuilder(11 + String.valueOf(string).length()).append("direction: ").append(string).toString());
    }
}

