/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.Transaction;
import java.util.ArrayList;

public final class TransactionOptions {
    private boolean xg = false;
    private Transaction previousTransaction = null;
    private Mode mode = null;

    private TransactionOptions() {
    }

    TransactionOptions(TransactionOptions original) {
        this.xg = original.xg;
    }

    public TransactionOptions setXG(boolean enable) {
        this.xg = enable;
        return this;
    }

    public TransactionOptions clearXG() {
        this.xg = false;
        return this;
    }

    public boolean isXG() {
        return this.xg;
    }

    public TransactionOptions setPreviousTransaction(Transaction previousTransaction) {
        this.previousTransaction = previousTransaction;
        return this;
    }

    public Transaction previousTransaction() {
        return this.previousTransaction;
    }

    public TransactionOptions setTransactionMode(Mode mode) {
        this.mode = mode;
        return this;
    }

    public Mode transactionMode() {
        return this.mode;
    }

    @Deprecated
    public TransactionOptions multipleEntityGroups(boolean enable) {
        return this.setXG(enable);
    }

    @Deprecated
    public TransactionOptions clearMultipleEntityGroups() {
        return this.clearXG();
    }

    @Deprecated
    public Boolean allowsMultipleEntityGroups() {
        return this.isXG();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionOptions that = (TransactionOptions)o;
        if (this.xg != that.xg) {
            return false;
        }
        if (this.previousTransaction != null ? !this.previousTransaction.equals(that.previousTransaction) : that.previousTransaction != null) {
            return false;
        }
        return this.mode == that.mode;
    }

    public int hashCode() {
        int result = this.xg ? 1 : 0;
        result = 31 * result + (this.previousTransaction != null ? this.previousTransaction.hashCode() : 0);
        result = 31 * result + (this.mode != null ? this.mode.hashCode() : 0);
        return result;
    }

    public String toString() {
        ArrayList<String> result = new ArrayList<String>();
        boolean bl = this.xg;
        result.add(new StringBuilder(8).append("XG=").append(bl).toString());
        String string = String.valueOf((Object)this.mode);
        result.add(new StringBuilder(5 + String.valueOf(string).length()).append("mode=").append(string).toString());
        string = String.valueOf(this.previousTransaction);
        result.add(new StringBuilder(20 + String.valueOf(string).length()).append("previousTransaction=").append(string).toString());
        string = String.valueOf(result);
        return new StringBuilder(18 + String.valueOf(string).length()).append("TransactionOptions").append(string).toString();
    }

    public static final class Builder {
        public static TransactionOptions withXG(boolean enable) {
            return Builder.withDefaults().setXG(enable);
        }

        public static TransactionOptions withTransactionMode(Mode mode) {
            return Builder.withDefaults().setTransactionMode(mode);
        }

        public static TransactionOptions withPreviousTransaction(Transaction previousTransaction) {
            return Builder.withTransactionMode(Mode.READ_WRITE).setPreviousTransaction(previousTransaction);
        }

        @Deprecated
        public static TransactionOptions allowMultipleEntityGroups(boolean enable) {
            return Builder.withDefaults().setXG(enable);
        }

        public static TransactionOptions withDefaults() {
            return new TransactionOptions();
        }

        private Builder() {
        }
    }

    public static enum Mode {
        READ_ONLY,
        READ_WRITE;

    }
}

