/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.mail;

import com.google.appengine.repackaged.com.google.io.protocol.MessageAppender;
import com.google.appengine.repackaged.com.google.io.protocol.Proto2ParserAdapter;
import com.google.appengine.repackaged.com.google.io.protocol.Protocol;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessageEnum;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSink;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSource;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSupport;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolType;
import com.google.appengine.repackaged.com.google.io.protocol.UninterpretedTags;
import com.google.appengine.repackaged.com.google.protobuf.Descriptors;
import com.google.appengine.repackaged.com.google.protobuf.Internal;
import com.google.appengine.repackaged.com.google.protobuf.Parser;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public final class MailServicePb {
    private MailServicePb() {
    }

    public static class MailMessage
    extends ProtocolMessage<MailMessage> {
        private static final long serialVersionUID = 1L;
        private volatile Object sender_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private volatile Object replyto_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private List<byte[]> to_ = null;
        private List<byte[]> cc_ = null;
        private List<byte[]> bcc_ = null;
        private volatile Object subject_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private volatile Object textbody_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private volatile Object htmlbody_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private volatile Object amphtmlbody_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private List<MailAttachment> attachment_ = null;
        private List<MailHeader> header_ = null;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final MailMessage IMMUTABLE_DEFAULT_INSTANCE = new MailMessage(){
            private static final long serialVersionUID = 1L;

            @Override
            public MailMessage clearSender() {
                return this;
            }

            @Override
            public MailMessage setSenderAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public MailMessage setSender(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public MailMessage setSender(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public MailMessage clearReplyTo() {
                return this;
            }

            @Override
            public MailMessage setReplyToAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public MailMessage setReplyTo(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public MailMessage setReplyTo(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public MailMessage clearTo() {
                return this;
            }

            @Override
            public MailMessage setToAsBytes(int i, byte[] v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public MailMessage setTo(int i, String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public MailMessage addToAsBytes(byte[] v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public MailMessage addTo(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public MailMessage setTo(int i, String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public MailMessage addTo(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public MailMessage clearCc() {
                return this;
            }

            @Override
            public MailMessage setCcAsBytes(int i, byte[] v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public MailMessage setCc(int i, String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public MailMessage addCcAsBytes(byte[] v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public MailMessage addCc(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public MailMessage setCc(int i, String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public MailMessage addCc(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public MailMessage clearBcc() {
                return this;
            }

            @Override
            public MailMessage setBccAsBytes(int i, byte[] v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public MailMessage setBcc(int i, String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public MailMessage addBccAsBytes(byte[] v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public MailMessage addBcc(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public MailMessage setBcc(int i, String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public MailMessage addBcc(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public MailMessage clearSubject() {
                return this;
            }

            @Override
            public MailMessage setSubjectAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public MailMessage setSubject(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public MailMessage setSubject(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public MailMessage clearTextBody() {
                return this;
            }

            @Override
            public MailMessage setTextBodyAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public MailMessage setTextBody(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public MailMessage setTextBody(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public MailMessage clearHtmlBody() {
                return this;
            }

            @Override
            public MailMessage setHtmlBodyAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public MailMessage setHtmlBody(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public MailMessage setHtmlBody(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public MailMessage clearAmpHtmlBody() {
                return this;
            }

            @Override
            public MailMessage setAmpHtmlBodyAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public MailMessage setAmpHtmlBody(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public MailMessage setAmpHtmlBody(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public MailMessage clearAttachment() {
                return this;
            }

            @Override
            public MailAttachment getMutableAttachment(int i) {
                return (MailAttachment)ProtocolSupport.unsupportedOperation();
            }

            @Override
            public MailAttachment addAttachment() {
                return (MailAttachment)ProtocolSupport.unsupportedOperation();
            }

            @Override
            public MailAttachment addAttachment(MailAttachment v) {
                return (MailAttachment)ProtocolSupport.unsupportedOperation();
            }

            @Override
            public MailAttachment insertAttachment(int i, MailAttachment v) {
                return (MailAttachment)ProtocolSupport.unsupportedOperation();
            }

            @Override
            public MailAttachment removeAttachment(int i) {
                return (MailAttachment)ProtocolSupport.unsupportedOperation();
            }

            @Override
            public MailMessage clearHeader() {
                return this;
            }

            @Override
            public MailHeader getMutableHeader(int i) {
                return (MailHeader)ProtocolSupport.unsupportedOperation();
            }

            @Override
            public MailHeader addHeader() {
                return (MailHeader)ProtocolSupport.unsupportedOperation();
            }

            @Override
            public MailHeader addHeader(MailHeader v) {
                return (MailHeader)ProtocolSupport.unsupportedOperation();
            }

            @Override
            public MailHeader insertHeader(int i, MailHeader v) {
                return (MailHeader)ProtocolSupport.unsupportedOperation();
            }

            @Override
            public MailHeader removeHeader(int i) {
                return (MailHeader)ProtocolSupport.unsupportedOperation();
            }

            @Override
            public MailMessage mergeFrom(MailMessage that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            @Override
            public MailMessage freeze() {
                return this;
            }

            @Override
            public MailMessage unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public boolean isFrozen() {
                return true;
            }
        };
        private static final Parser<MailMessage> PARSER = new Proto2ParserAdapter<MailMessage>(MailMessage.getDefaultInstance());
        public static final int kSender = 1;
        public static final int kReplyTo = 2;
        public static final int kTo = 3;
        public static final int kCc = 4;
        public static final int kBcc = 5;
        public static final int kSubject = 6;
        public static final int kTextBody = 7;
        public static final int kHtmlBody = 8;
        public static final int kAmpHtmlBody = 11;
        public static final int kAttachment = 9;
        public static final int kHeader = 10;
        public static final String[] text = new String[12];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final byte[] getSenderAsBytes() {
            if (ProtocolMessage.storeStringsOnlyAsBytes()) {
                return (byte[])this.sender_;
            }
            byte[] sender_tmp = ProtocolSupport.stringAsUtf8Bytes(this.sender_);
            this.sender_ = sender_tmp;
            return sender_tmp;
        }

        public final boolean hasSender() {
            return (this.optional_0_ & 1) != 0;
        }

        public MailMessage clearSender() {
            this.optional_0_ &= 0xFFFFFFFE;
            this.sender_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public MailMessage setSenderAsBytes(byte[] x) {
            this.optional_0_ |= 1;
            this.sender_ = x;
            return this;
        }

        public final String getSender() {
            Object ref = this.sender_;
            if (ref instanceof String) {
                return (String)ref;
            }
            byte[] bytes = (byte[])ref;
            String str = ProtocolSupport.toStringUtf8(bytes);
            if (!ProtocolMessage.storeStringsOnlyAsBytes() && Internal.isValidUtf8(bytes)) {
                this.sender_ = str;
            }
            return str;
        }

        public MailMessage setSender(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.sender_ = ProtocolMessage.storeStringsOnlyAsBytes() ? (Object)ProtocolSupport.toBytesUtf8(v) : v;
            return this;
        }

        public final String getSender(Charset cs) {
            if (ProtocolMessage.storeStringsOnlyAsBytes()) {
                return ProtocolSupport.toString((byte[])this.sender_, cs);
            }
            byte[] sender_tmp = ProtocolSupport.stringAsUtf8Bytes(this.sender_);
            this.sender_ = sender_tmp;
            return ProtocolSupport.toString(sender_tmp, cs);
        }

        public MailMessage setSender(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.sender_ = ProtocolSupport.toBytes(v, cs);
            return this;
        }

        public final byte[] getReplyToAsBytes() {
            if (ProtocolMessage.storeStringsOnlyAsBytes()) {
                return (byte[])this.replyto_;
            }
            byte[] replyto_tmp = ProtocolSupport.stringAsUtf8Bytes(this.replyto_);
            this.replyto_ = replyto_tmp;
            return replyto_tmp;
        }

        public final boolean hasReplyTo() {
            return (this.optional_0_ & 2) != 0;
        }

        public MailMessage clearReplyTo() {
            this.optional_0_ &= 0xFFFFFFFD;
            this.replyto_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public MailMessage setReplyToAsBytes(byte[] x) {
            this.optional_0_ |= 2;
            this.replyto_ = x;
            return this;
        }

        public final String getReplyTo() {
            Object ref = this.replyto_;
            if (ref instanceof String) {
                return (String)ref;
            }
            byte[] bytes = (byte[])ref;
            String str = ProtocolSupport.toStringUtf8(bytes);
            if (!ProtocolMessage.storeStringsOnlyAsBytes() && Internal.isValidUtf8(bytes)) {
                this.replyto_ = str;
            }
            return str;
        }

        public MailMessage setReplyTo(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 2;
            this.replyto_ = ProtocolMessage.storeStringsOnlyAsBytes() ? (Object)ProtocolSupport.toBytesUtf8(v) : v;
            return this;
        }

        public final String getReplyTo(Charset cs) {
            if (ProtocolMessage.storeStringsOnlyAsBytes()) {
                return ProtocolSupport.toString((byte[])this.replyto_, cs);
            }
            byte[] replyto_tmp = ProtocolSupport.stringAsUtf8Bytes(this.replyto_);
            this.replyto_ = replyto_tmp;
            return ProtocolSupport.toString(replyto_tmp, cs);
        }

        public MailMessage setReplyTo(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 2;
            this.replyto_ = ProtocolSupport.toBytes(v, cs);
            return this;
        }

        public final int toSize() {
            return this.to_ != null ? this.to_.size() : 0;
        }

        public final byte[] getToAsBytes(int i) {
            assert (i >= 0 && i < (this.to_ != null ? this.to_.size() : 0));
            return this.to_.get(i);
        }

        public MailMessage clearTo() {
            if (this.to_ != null) {
                this.to_.clear();
            }
            return this;
        }

        public final String getTo(int i) {
            return ProtocolSupport.toStringUtf8(this.to_.get(i));
        }

        public MailMessage setToAsBytes(int i, byte[] v) {
            this.to_.set(i, v);
            return this;
        }

        public MailMessage setTo(int i, String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.to_.set(i, ProtocolSupport.toBytesUtf8(v));
            return this;
        }

        public MailMessage addToAsBytes(byte[] v) {
            if (this.to_ == null) {
                this.to_ = new ArrayList<byte[]>(4);
            }
            this.to_.add(v);
            return this;
        }

        public MailMessage addTo(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            if (this.to_ == null) {
                this.to_ = new ArrayList<byte[]>(4);
            }
            this.to_.add(ProtocolSupport.toBytesUtf8(v));
            return this;
        }

        public final Iterator<String> toIterator() {
            return ProtocolSupport.byteArrayToUnicodeIterator(this.to_);
        }

        public final List<String> tos() {
            return ProtocolSupport.byteArrayToUnicodeList(this.to_);
        }

        public final Iterator<byte[]> toAsBytesIterator() {
            return this.to_ == null ? ProtocolSupport.emptyIterator() : this.to_.iterator();
        }

        public final List<byte[]> tosAsBytes() {
            return ProtocolSupport.unmodifiableList(this.to_);
        }

        public final List<byte[]> mutableTosAsBytes() {
            if (this.to_ == null) {
                this.to_ = new ArrayList<byte[]>(4);
            }
            return this.to_;
        }

        public final String getTo(int i, Charset cs) {
            return ProtocolSupport.toString(this.to_.get(i), cs);
        }

        public MailMessage setTo(int i, String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.to_.set(i, ProtocolSupport.toBytes(v, cs));
            return this;
        }

        public MailMessage addTo(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            if (this.to_ == null) {
                this.to_ = new ArrayList<byte[]>(4);
            }
            this.to_.add(ProtocolSupport.toBytes(v, cs));
            return this;
        }

        public final Iterator<String> toIterator(Charset cs) {
            return ProtocolSupport.byteArrayToUnicodeIterator(this.to_, cs);
        }

        public final List<String> tos(Charset cs) {
            return ProtocolSupport.byteArrayToUnicodeList(this.to_, cs);
        }

        public final int ccSize() {
            return this.cc_ != null ? this.cc_.size() : 0;
        }

        public final byte[] getCcAsBytes(int i) {
            assert (i >= 0 && i < (this.cc_ != null ? this.cc_.size() : 0));
            return this.cc_.get(i);
        }

        public MailMessage clearCc() {
            if (this.cc_ != null) {
                this.cc_.clear();
            }
            return this;
        }

        public final String getCc(int i) {
            return ProtocolSupport.toStringUtf8(this.cc_.get(i));
        }

        public MailMessage setCcAsBytes(int i, byte[] v) {
            this.cc_.set(i, v);
            return this;
        }

        public MailMessage setCc(int i, String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.cc_.set(i, ProtocolSupport.toBytesUtf8(v));
            return this;
        }

        public MailMessage addCcAsBytes(byte[] v) {
            if (this.cc_ == null) {
                this.cc_ = new ArrayList<byte[]>(4);
            }
            this.cc_.add(v);
            return this;
        }

        public MailMessage addCc(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            if (this.cc_ == null) {
                this.cc_ = new ArrayList<byte[]>(4);
            }
            this.cc_.add(ProtocolSupport.toBytesUtf8(v));
            return this;
        }

        public final Iterator<String> ccIterator() {
            return ProtocolSupport.byteArrayToUnicodeIterator(this.cc_);
        }

        public final List<String> ccs() {
            return ProtocolSupport.byteArrayToUnicodeList(this.cc_);
        }

        public final Iterator<byte[]> ccAsBytesIterator() {
            return this.cc_ == null ? ProtocolSupport.emptyIterator() : this.cc_.iterator();
        }

        public final List<byte[]> ccsAsBytes() {
            return ProtocolSupport.unmodifiableList(this.cc_);
        }

        public final List<byte[]> mutableCcsAsBytes() {
            if (this.cc_ == null) {
                this.cc_ = new ArrayList<byte[]>(4);
            }
            return this.cc_;
        }

        public final String getCc(int i, Charset cs) {
            return ProtocolSupport.toString(this.cc_.get(i), cs);
        }

        public MailMessage setCc(int i, String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.cc_.set(i, ProtocolSupport.toBytes(v, cs));
            return this;
        }

        public MailMessage addCc(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            if (this.cc_ == null) {
                this.cc_ = new ArrayList<byte[]>(4);
            }
            this.cc_.add(ProtocolSupport.toBytes(v, cs));
            return this;
        }

        public final Iterator<String> ccIterator(Charset cs) {
            return ProtocolSupport.byteArrayToUnicodeIterator(this.cc_, cs);
        }

        public final List<String> ccs(Charset cs) {
            return ProtocolSupport.byteArrayToUnicodeList(this.cc_, cs);
        }

        public final int bccSize() {
            return this.bcc_ != null ? this.bcc_.size() : 0;
        }

        public final byte[] getBccAsBytes(int i) {
            assert (i >= 0 && i < (this.bcc_ != null ? this.bcc_.size() : 0));
            return this.bcc_.get(i);
        }

        public MailMessage clearBcc() {
            if (this.bcc_ != null) {
                this.bcc_.clear();
            }
            return this;
        }

        public final String getBcc(int i) {
            return ProtocolSupport.toStringUtf8(this.bcc_.get(i));
        }

        public MailMessage setBccAsBytes(int i, byte[] v) {
            this.bcc_.set(i, v);
            return this;
        }

        public MailMessage setBcc(int i, String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.bcc_.set(i, ProtocolSupport.toBytesUtf8(v));
            return this;
        }

        public MailMessage addBccAsBytes(byte[] v) {
            if (this.bcc_ == null) {
                this.bcc_ = new ArrayList<byte[]>(4);
            }
            this.bcc_.add(v);
            return this;
        }

        public MailMessage addBcc(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            if (this.bcc_ == null) {
                this.bcc_ = new ArrayList<byte[]>(4);
            }
            this.bcc_.add(ProtocolSupport.toBytesUtf8(v));
            return this;
        }

        public final Iterator<String> bccIterator() {
            return ProtocolSupport.byteArrayToUnicodeIterator(this.bcc_);
        }

        public final List<String> bccs() {
            return ProtocolSupport.byteArrayToUnicodeList(this.bcc_);
        }

        public final Iterator<byte[]> bccAsBytesIterator() {
            return this.bcc_ == null ? ProtocolSupport.emptyIterator() : this.bcc_.iterator();
        }

        public final List<byte[]> bccsAsBytes() {
            return ProtocolSupport.unmodifiableList(this.bcc_);
        }

        public final List<byte[]> mutableBccsAsBytes() {
            if (this.bcc_ == null) {
                this.bcc_ = new ArrayList<byte[]>(4);
            }
            return this.bcc_;
        }

        public final String getBcc(int i, Charset cs) {
            return ProtocolSupport.toString(this.bcc_.get(i), cs);
        }

        public MailMessage setBcc(int i, String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.bcc_.set(i, ProtocolSupport.toBytes(v, cs));
            return this;
        }

        public MailMessage addBcc(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            if (this.bcc_ == null) {
                this.bcc_ = new ArrayList<byte[]>(4);
            }
            this.bcc_.add(ProtocolSupport.toBytes(v, cs));
            return this;
        }

        public final Iterator<String> bccIterator(Charset cs) {
            return ProtocolSupport.byteArrayToUnicodeIterator(this.bcc_, cs);
        }

        public final List<String> bccs(Charset cs) {
            return ProtocolSupport.byteArrayToUnicodeList(this.bcc_, cs);
        }

        public final byte[] getSubjectAsBytes() {
            if (ProtocolMessage.storeStringsOnlyAsBytes()) {
                return (byte[])this.subject_;
            }
            byte[] subject_tmp = ProtocolSupport.stringAsUtf8Bytes(this.subject_);
            this.subject_ = subject_tmp;
            return subject_tmp;
        }

        public final boolean hasSubject() {
            return (this.optional_0_ & 4) != 0;
        }

        public MailMessage clearSubject() {
            this.optional_0_ &= 0xFFFFFFFB;
            this.subject_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public MailMessage setSubjectAsBytes(byte[] x) {
            this.optional_0_ |= 4;
            this.subject_ = x;
            return this;
        }

        public final String getSubject() {
            Object ref = this.subject_;
            if (ref instanceof String) {
                return (String)ref;
            }
            byte[] bytes = (byte[])ref;
            String str = ProtocolSupport.toStringUtf8(bytes);
            if (!ProtocolMessage.storeStringsOnlyAsBytes() && Internal.isValidUtf8(bytes)) {
                this.subject_ = str;
            }
            return str;
        }

        public MailMessage setSubject(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 4;
            this.subject_ = ProtocolMessage.storeStringsOnlyAsBytes() ? (Object)ProtocolSupport.toBytesUtf8(v) : v;
            return this;
        }

        public final String getSubject(Charset cs) {
            if (ProtocolMessage.storeStringsOnlyAsBytes()) {
                return ProtocolSupport.toString((byte[])this.subject_, cs);
            }
            byte[] subject_tmp = ProtocolSupport.stringAsUtf8Bytes(this.subject_);
            this.subject_ = subject_tmp;
            return ProtocolSupport.toString(subject_tmp, cs);
        }

        public MailMessage setSubject(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 4;
            this.subject_ = ProtocolSupport.toBytes(v, cs);
            return this;
        }

        public final byte[] getTextBodyAsBytes() {
            if (ProtocolMessage.storeStringsOnlyAsBytes()) {
                return (byte[])this.textbody_;
            }
            byte[] textbody_tmp = ProtocolSupport.stringAsUtf8Bytes(this.textbody_);
            this.textbody_ = textbody_tmp;
            return textbody_tmp;
        }

        public final boolean hasTextBody() {
            return (this.optional_0_ & 8) != 0;
        }

        public MailMessage clearTextBody() {
            this.optional_0_ &= 0xFFFFFFF7;
            this.textbody_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public MailMessage setTextBodyAsBytes(byte[] x) {
            this.optional_0_ |= 8;
            this.textbody_ = x;
            return this;
        }

        public final String getTextBody() {
            Object ref = this.textbody_;
            if (ref instanceof String) {
                return (String)ref;
            }
            byte[] bytes = (byte[])ref;
            String str = ProtocolSupport.toStringUtf8(bytes);
            if (!ProtocolMessage.storeStringsOnlyAsBytes() && Internal.isValidUtf8(bytes)) {
                this.textbody_ = str;
            }
            return str;
        }

        public MailMessage setTextBody(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 8;
            this.textbody_ = ProtocolMessage.storeStringsOnlyAsBytes() ? (Object)ProtocolSupport.toBytesUtf8(v) : v;
            return this;
        }

        public final String getTextBody(Charset cs) {
            if (ProtocolMessage.storeStringsOnlyAsBytes()) {
                return ProtocolSupport.toString((byte[])this.textbody_, cs);
            }
            byte[] textbody_tmp = ProtocolSupport.stringAsUtf8Bytes(this.textbody_);
            this.textbody_ = textbody_tmp;
            return ProtocolSupport.toString(textbody_tmp, cs);
        }

        public MailMessage setTextBody(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 8;
            this.textbody_ = ProtocolSupport.toBytes(v, cs);
            return this;
        }

        public final byte[] getHtmlBodyAsBytes() {
            if (ProtocolMessage.storeStringsOnlyAsBytes()) {
                return (byte[])this.htmlbody_;
            }
            byte[] htmlbody_tmp = ProtocolSupport.stringAsUtf8Bytes(this.htmlbody_);
            this.htmlbody_ = htmlbody_tmp;
            return htmlbody_tmp;
        }

        public final boolean hasHtmlBody() {
            return (this.optional_0_ & 0x10) != 0;
        }

        public MailMessage clearHtmlBody() {
            this.optional_0_ &= 0xFFFFFFEF;
            this.htmlbody_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public MailMessage setHtmlBodyAsBytes(byte[] x) {
            this.optional_0_ |= 0x10;
            this.htmlbody_ = x;
            return this;
        }

        public final String getHtmlBody() {
            Object ref = this.htmlbody_;
            if (ref instanceof String) {
                return (String)ref;
            }
            byte[] bytes = (byte[])ref;
            String str = ProtocolSupport.toStringUtf8(bytes);
            if (!ProtocolMessage.storeStringsOnlyAsBytes() && Internal.isValidUtf8(bytes)) {
                this.htmlbody_ = str;
            }
            return str;
        }

        public MailMessage setHtmlBody(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 0x10;
            this.htmlbody_ = ProtocolMessage.storeStringsOnlyAsBytes() ? (Object)ProtocolSupport.toBytesUtf8(v) : v;
            return this;
        }

        public final String getHtmlBody(Charset cs) {
            if (ProtocolMessage.storeStringsOnlyAsBytes()) {
                return ProtocolSupport.toString((byte[])this.htmlbody_, cs);
            }
            byte[] htmlbody_tmp = ProtocolSupport.stringAsUtf8Bytes(this.htmlbody_);
            this.htmlbody_ = htmlbody_tmp;
            return ProtocolSupport.toString(htmlbody_tmp, cs);
        }

        public MailMessage setHtmlBody(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 0x10;
            this.htmlbody_ = ProtocolSupport.toBytes(v, cs);
            return this;
        }

        public final byte[] getAmpHtmlBodyAsBytes() {
            if (ProtocolMessage.storeStringsOnlyAsBytes()) {
                return (byte[])this.amphtmlbody_;
            }
            byte[] amphtmlbody_tmp = ProtocolSupport.stringAsUtf8Bytes(this.amphtmlbody_);
            this.amphtmlbody_ = amphtmlbody_tmp;
            return amphtmlbody_tmp;
        }

        public final boolean hasAmpHtmlBody() {
            return (this.optional_0_ & 0x20) != 0;
        }

        public MailMessage clearAmpHtmlBody() {
            this.optional_0_ &= 0xFFFFFFDF;
            this.amphtmlbody_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public MailMessage setAmpHtmlBodyAsBytes(byte[] x) {
            this.optional_0_ |= 0x20;
            this.amphtmlbody_ = x;
            return this;
        }

        public final String getAmpHtmlBody() {
            Object ref = this.amphtmlbody_;
            if (ref instanceof String) {
                return (String)ref;
            }
            byte[] bytes = (byte[])ref;
            String str = ProtocolSupport.toStringUtf8(bytes);
            if (!ProtocolMessage.storeStringsOnlyAsBytes() && Internal.isValidUtf8(bytes)) {
                this.amphtmlbody_ = str;
            }
            return str;
        }

        public MailMessage setAmpHtmlBody(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 0x20;
            this.amphtmlbody_ = ProtocolMessage.storeStringsOnlyAsBytes() ? (Object)ProtocolSupport.toBytesUtf8(v) : v;
            return this;
        }

        public final String getAmpHtmlBody(Charset cs) {
            if (ProtocolMessage.storeStringsOnlyAsBytes()) {
                return ProtocolSupport.toString((byte[])this.amphtmlbody_, cs);
            }
            byte[] amphtmlbody_tmp = ProtocolSupport.stringAsUtf8Bytes(this.amphtmlbody_);
            this.amphtmlbody_ = amphtmlbody_tmp;
            return ProtocolSupport.toString(amphtmlbody_tmp, cs);
        }

        public MailMessage setAmpHtmlBody(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 0x20;
            this.amphtmlbody_ = ProtocolSupport.toBytes(v, cs);
            return this;
        }

        public final int attachmentSize() {
            return this.attachment_ != null ? this.attachment_.size() : 0;
        }

        public final MailAttachment getAttachment(int i) {
            assert (i >= 0 && i < (this.attachment_ != null ? this.attachment_.size() : 0));
            return this.attachment_.get(i);
        }

        public MailMessage clearAttachment() {
            if (this.attachment_ != null) {
                this.attachment_.clear();
            }
            return this;
        }

        public MailAttachment getMutableAttachment(int i) {
            assert (i >= 0 && this.attachment_ != null && i < this.attachment_.size());
            return this.attachment_.get(i);
        }

        public MailAttachment addAttachment() {
            MailAttachment v = new MailAttachment();
            if (this.attachment_ == null) {
                this.attachment_ = new ArrayList<MailAttachment>(4);
            }
            this.attachment_.add(v);
            return v;
        }

        public MailAttachment addAttachment(MailAttachment v) {
            if (this.attachment_ == null) {
                this.attachment_ = new ArrayList<MailAttachment>(4);
            }
            this.attachment_.add(v);
            return v;
        }

        public MailAttachment insertAttachment(int i, MailAttachment v) {
            if (this.attachment_ == null) {
                this.attachment_ = new ArrayList<MailAttachment>(4);
            }
            this.attachment_.add(i, v);
            return v;
        }

        public MailAttachment removeAttachment(int i) {
            return this.attachment_.remove(i);
        }

        public final Iterator<MailAttachment> attachmentIterator() {
            if (this.attachment_ == null) {
                return ProtocolSupport.emptyIterator();
            }
            return this.attachment_.iterator();
        }

        public final List<MailAttachment> attachments() {
            return ProtocolSupport.unmodifiableList(this.attachment_);
        }

        public final List<MailAttachment> mutableAttachments() {
            if (this.attachment_ == null) {
                this.attachment_ = new ArrayList<MailAttachment>(4);
            }
            return this.attachment_;
        }

        public final int headerSize() {
            return this.header_ != null ? this.header_.size() : 0;
        }

        public final MailHeader getHeader(int i) {
            assert (i >= 0 && i < (this.header_ != null ? this.header_.size() : 0));
            return this.header_.get(i);
        }

        public MailMessage clearHeader() {
            if (this.header_ != null) {
                this.header_.clear();
            }
            return this;
        }

        public MailHeader getMutableHeader(int i) {
            assert (i >= 0 && this.header_ != null && i < this.header_.size());
            return this.header_.get(i);
        }

        public MailHeader addHeader() {
            MailHeader v = new MailHeader();
            if (this.header_ == null) {
                this.header_ = new ArrayList<MailHeader>(4);
            }
            this.header_.add(v);
            return v;
        }

        public MailHeader addHeader(MailHeader v) {
            if (this.header_ == null) {
                this.header_ = new ArrayList<MailHeader>(4);
            }
            this.header_.add(v);
            return v;
        }

        public MailHeader insertHeader(int i, MailHeader v) {
            if (this.header_ == null) {
                this.header_ = new ArrayList<MailHeader>(4);
            }
            this.header_.add(i, v);
            return v;
        }

        public MailHeader removeHeader(int i) {
            return this.header_.remove(i);
        }

        public final Iterator<MailHeader> headerIterator() {
            if (this.header_ == null) {
                return ProtocolSupport.emptyIterator();
            }
            return this.header_.iterator();
        }

        public final List<MailHeader> headers() {
            return ProtocolSupport.unmodifiableList(this.header_);
        }

        public final List<MailHeader> mutableHeaders() {
            if (this.header_ == null) {
                this.header_ = new ArrayList<MailHeader>(4);
            }
            return this.header_;
        }

        @Override
        public MailMessage mergeFrom(MailMessage that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                this.sender_ = that.sender_;
            }
            if ((that_t0 & 2) != 0) {
                this_t0 |= 2;
                this.replyto_ = that.replyto_;
            }
            if (that.to_ != null && that.to_.size() > 0) {
                if (this.to_ == null) {
                    this.to_ = new ArrayList<byte[]>(that.to_);
                } else {
                    this.to_.addAll(that.to_);
                }
            }
            if (that.cc_ != null && that.cc_.size() > 0) {
                if (this.cc_ == null) {
                    this.cc_ = new ArrayList<byte[]>(that.cc_);
                } else {
                    this.cc_.addAll(that.cc_);
                }
            }
            if (that.bcc_ != null && that.bcc_.size() > 0) {
                if (this.bcc_ == null) {
                    this.bcc_ = new ArrayList<byte[]>(that.bcc_);
                } else {
                    this.bcc_.addAll(that.bcc_);
                }
            }
            if ((that_t0 & 4) != 0) {
                this_t0 |= 4;
                this.subject_ = that.subject_;
            }
            if ((that_t0 & 8) != 0) {
                this_t0 |= 8;
                this.textbody_ = that.textbody_;
            }
            if ((that_t0 & 0x10) != 0) {
                this_t0 |= 0x10;
                this.htmlbody_ = that.htmlbody_;
            }
            if ((that_t0 & 0x20) != 0) {
                this_t0 |= 0x20;
                this.amphtmlbody_ = that.amphtmlbody_;
            }
            if (that.attachment_ != null && that.attachment_.size() > 0) {
                if (this.attachment_ == null) {
                    this.attachment_ = new ArrayList<MailAttachment>(that.attachment_.size());
                } else if (this.attachment_ instanceof ArrayList) {
                    ((ArrayList)this.attachment_).ensureCapacity(this.attachment_.size() + that.attachment_.size());
                }
                for (MailAttachment mailAttachment : that.attachment_) {
                    this.addAttachment().mergeFrom(mailAttachment);
                }
            }
            if (that.header_ != null && that.header_.size() > 0) {
                if (this.header_ == null) {
                    this.header_ = new ArrayList<MailHeader>(that.header_.size());
                } else if (this.header_ instanceof ArrayList) {
                    ((ArrayList)this.header_).ensureCapacity(this.header_.size() + that.header_.size());
                }
                for (MailHeader mailHeader : that.header_) {
                    this.addHeader().mergeFrom(mailHeader);
                }
            }
            if (that.uninterpreted != null) {
                this.getUninterpretedForWrite().putAll(that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(MailMessage that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(MailMessage that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(MailMessage that, boolean ignoreUninterpreted) {
            int i;
            if (that == null) {
                return false;
            }
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (this_t0 != that_t0) {
                return false;
            }
            if ((this_t0 & 1) != 0 && !ProtocolSupport.stringEquals(this.sender_, that.sender_)) {
                return false;
            }
            if ((this_t0 & 2) != 0 && !ProtocolSupport.stringEquals(this.replyto_, that.replyto_)) {
                return false;
            }
            int n = this.to_ != null ? this.to_.size() : 0;
            if (n != (that.to_ != null ? that.to_.size() : 0)) {
                return false;
            }
            for (i = 0; i < n; ++i) {
                if (Arrays.equals(this.to_.get(i), that.to_.get(i))) continue;
                return false;
            }
            n = this.cc_ != null ? this.cc_.size() : 0;
            if (n != (that.cc_ != null ? that.cc_.size() : 0)) {
                return false;
            }
            for (i = 0; i < n; ++i) {
                if (Arrays.equals(this.cc_.get(i), that.cc_.get(i))) continue;
                return false;
            }
            n = this.bcc_ != null ? this.bcc_.size() : 0;
            if (n != (that.bcc_ != null ? that.bcc_.size() : 0)) {
                return false;
            }
            for (i = 0; i < n; ++i) {
                if (Arrays.equals(this.bcc_.get(i), that.bcc_.get(i))) continue;
                return false;
            }
            if ((this_t0 & 4) != 0 && !ProtocolSupport.stringEquals(this.subject_, that.subject_)) {
                return false;
            }
            if ((this_t0 & 8) != 0 && !ProtocolSupport.stringEquals(this.textbody_, that.textbody_)) {
                return false;
            }
            if ((this_t0 & 0x10) != 0 && !ProtocolSupport.stringEquals(this.htmlbody_, that.htmlbody_)) {
                return false;
            }
            if ((this_t0 & 0x20) != 0 && !ProtocolSupport.stringEquals(this.amphtmlbody_, that.amphtmlbody_)) {
                return false;
            }
            n = this.attachment_ != null ? this.attachment_.size() : 0;
            if (n != (that.attachment_ != null ? that.attachment_.size() : 0)) {
                return false;
            }
            for (i = 0; i < n; ++i) {
                if (this.attachment_.get(i).equals(that.attachment_.get(i), ignoreUninterpreted)) continue;
                return false;
            }
            n = this.header_ != null ? this.header_.size() : 0;
            if (n != (that.header_ != null ? that.header_.size() : 0)) {
                return false;
            }
            for (i = 0; i < n; ++i) {
                if (this.header_.get(i).equals(that.header_.get(i), ignoreUninterpreted)) continue;
                return false;
            }
            return ignoreUninterpreted || UninterpretedTags.equivalent(this.uninterpreted, that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof MailMessage && this.equals((MailMessage)that);
        }

        @Override
        public int hashCode() {
            int i;
            int n;
            int hash = -1153084626;
            int this_t0 = this.optional_0_;
            hash = hash * 31 + ((this_t0 & 1) != 0 ? ProtocolSupport.stringHashCode(this.sender_) : -113);
            hash = hash * 31 + ((this_t0 & 2) != 0 ? ProtocolSupport.stringHashCode(this.replyto_) : -113);
            hash *= 31;
            int n2 = n = this.to_ != null ? this.to_.size() : 0;
            for (i = 0; i < n; ++i) {
                hash = hash * 31 + ProtocolSupport.stringHashCode(this.to_.get(i));
            }
            hash *= 31;
            int n3 = n = this.cc_ != null ? this.cc_.size() : 0;
            for (i = 0; i < n; ++i) {
                hash = hash * 31 + ProtocolSupport.stringHashCode(this.cc_.get(i));
            }
            hash *= 31;
            int n4 = n = this.bcc_ != null ? this.bcc_.size() : 0;
            for (i = 0; i < n; ++i) {
                hash = hash * 31 + ProtocolSupport.stringHashCode(this.bcc_.get(i));
            }
            hash = hash * 31 + ((this_t0 & 4) != 0 ? ProtocolSupport.stringHashCode(this.subject_) : -113);
            hash = hash * 31 + ((this_t0 & 8) != 0 ? ProtocolSupport.stringHashCode(this.textbody_) : -113);
            hash = hash * 31 + ((this_t0 & 0x10) != 0 ? ProtocolSupport.stringHashCode(this.htmlbody_) : -113);
            hash *= 31;
            int n5 = n = this.attachment_ != null ? this.attachment_.size() : 0;
            for (i = 0; i < n; ++i) {
                hash = hash * 31 + this.attachment_.get(i).hashCode();
            }
            hash *= 31;
            int n6 = n = this.header_ != null ? this.header_.size() : 0;
            for (i = 0; i < n; ++i) {
                hash = hash * 31 + this.header_.get(i).hashCode();
            }
            hash = hash * 31 + ((this_t0 & 0x20) != 0 ? ProtocolSupport.stringHashCode(this.amphtmlbody_) : -113);
            if (this.uninterpreted != null && !this.uninterpreted.isEmpty()) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public boolean isInitialized() {
            int this_t0 = this.optional_0_;
            if ((this_t0 & 5) != 5) {
                return false;
            }
            if (this.attachment_ != null) {
                for (MailAttachment mailAttachment : this.attachment_) {
                    if (mailAttachment.isInitialized()) continue;
                    return false;
                }
            }
            if (this.header_ != null) {
                for (MailHeader mailHeader : this.header_) {
                    if (mailHeader.isInitialized()) continue;
                    return false;
                }
            }
            return true;
        }

        @Override
        public int encodingSize() {
            int i;
            int n = 2 + ProtocolSupport.stringEncodingSize(this.sender_) + ProtocolSupport.stringEncodingSize(this.subject_);
            int m = this.to_ != null ? this.to_.size() : 0;
            n += m;
            for (i = 0; i < m; ++i) {
                n += Protocol.stringSize(this.to_.get(i).length);
            }
            m = this.cc_ != null ? this.cc_.size() : 0;
            n += m;
            for (i = 0; i < m; ++i) {
                n += Protocol.stringSize(this.cc_.get(i).length);
            }
            m = this.bcc_ != null ? this.bcc_.size() : 0;
            n += m;
            for (i = 0; i < m; ++i) {
                n += Protocol.stringSize(this.bcc_.get(i).length);
            }
            m = this.attachment_ != null ? this.attachment_.size() : 0;
            n += m;
            for (i = 0; i < m; ++i) {
                n += Protocol.stringSize(this.attachment_.get(i).getSerializedSize());
            }
            m = this.header_ != null ? this.header_.size() : 0;
            n += m;
            for (i = 0; i < m; ++i) {
                n += Protocol.stringSize(this.header_.get(i).getSerializedSize());
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 0x3A) != 0) {
                if ((this_t0 & 2) != 0) {
                    n += 1 + ProtocolSupport.stringEncodingSize(this.replyto_);
                }
                if ((this_t0 & 8) != 0) {
                    n += 1 + ProtocolSupport.stringEncodingSize(this.textbody_);
                }
                if ((this_t0 & 0x10) != 0) {
                    n += 1 + ProtocolSupport.stringEncodingSize(this.htmlbody_);
                }
                if ((this_t0 & 0x20) != 0) {
                    n += 1 + ProtocolSupport.stringEncodingSize(this.amphtmlbody_);
                }
            }
            return this.uninterpreted != null ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int i;
            int n = 12 + ProtocolSupport.stringAsUtf8Bytes(this.sender_).length + ProtocolSupport.stringAsUtf8Bytes(this.subject_).length;
            int m = this.to_ != null ? this.to_.size() : 0;
            n += 6 * m;
            for (i = 0; i < m; ++i) {
                n += this.to_.get(i).length;
            }
            m = this.cc_ != null ? this.cc_.size() : 0;
            n += 6 * m;
            for (i = 0; i < m; ++i) {
                n += this.cc_.get(i).length;
            }
            m = this.bcc_ != null ? this.bcc_.size() : 0;
            n += 6 * m;
            for (i = 0; i < m; ++i) {
                n += this.bcc_.get(i).length;
            }
            m = this.attachment_ != null ? this.attachment_.size() : 0;
            n += 6 * m;
            for (i = 0; i < m; ++i) {
                n += this.attachment_.get(i).maxEncodingSize();
            }
            m = this.header_ != null ? this.header_.size() : 0;
            n += 6 * m;
            for (i = 0; i < m; ++i) {
                n += this.header_.get(i).maxEncodingSize();
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 0x3A) != 0) {
                if ((this_t0 & 2) != 0) {
                    n += 6 + ProtocolSupport.stringAsUtf8Bytes(this.replyto_).length;
                }
                if ((this_t0 & 8) != 0) {
                    n += 6 + ProtocolSupport.stringAsUtf8Bytes(this.textbody_).length;
                }
                if ((this_t0 & 0x10) != 0) {
                    n += 6 + ProtocolSupport.stringAsUtf8Bytes(this.htmlbody_).length;
                }
                if ((this_t0 & 0x20) != 0) {
                    n += 6 + ProtocolSupport.stringAsUtf8Bytes(this.amphtmlbody_).length;
                }
            }
            return this.uninterpreted != null ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        @Override
        public MessageAppender getMessageAppender() {
            return this.getUninterpretedForWrite();
        }

        @Override
        protected MailMessage internalClear() {
            this.optional_0_ = 0;
            this.sender_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.replyto_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            if (this.to_ != null) {
                this.to_.clear();
            }
            if (this.cc_ != null) {
                this.cc_.clear();
            }
            if (this.bcc_ != null) {
                this.bcc_.clear();
            }
            this.subject_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.textbody_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.htmlbody_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.amphtmlbody_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            if (this.attachment_ != null) {
                this.attachment_.clear();
            }
            if (this.header_ != null) {
                this.header_.clear();
            }
            this.uninterpreted = null;
            return this;
        }

        @Override
        public MailMessage newInstance() {
            return new MailMessage();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        protected ProtocolMessage.FieldAccessorTable internalGetFieldAccessorTable() {
            return FieldAccessorTableHolder.internal_field_accessor_table;
        }

        public static Descriptors.Descriptor getDescriptor() {
            return FieldAccessorTableHolder.internal_field_accessor_table.getDescriptor();
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            Object v;
            int i;
            int m;
            sink.putByte((byte)10);
            sink.putPrefixedData(ProtocolSupport.stringAsUtf8Bytes(this.sender_));
            int this_t0 = this.optional_0_;
            if ((this_t0 & 2) != 0) {
                sink.putByte((byte)18);
                sink.putPrefixedData(ProtocolSupport.stringAsUtf8Bytes(this.replyto_));
            }
            int n = m = this.to_ != null ? this.to_.size() : 0;
            for (i = 0; i < m; ++i) {
                v = this.to_.get(i);
                sink.putByte((byte)26);
                sink.putPrefixedData((byte[])v);
            }
            int n2 = m = this.cc_ != null ? this.cc_.size() : 0;
            for (i = 0; i < m; ++i) {
                v = this.cc_.get(i);
                sink.putByte((byte)34);
                sink.putPrefixedData((byte[])v);
            }
            int n3 = m = this.bcc_ != null ? this.bcc_.size() : 0;
            for (i = 0; i < m; ++i) {
                v = this.bcc_.get(i);
                sink.putByte((byte)42);
                sink.putPrefixedData((byte[])v);
            }
            sink.putByte((byte)50);
            sink.putPrefixedData(ProtocolSupport.stringAsUtf8Bytes(this.subject_));
            if ((this_t0 & 8) != 0) {
                sink.putByte((byte)58);
                sink.putPrefixedData(ProtocolSupport.stringAsUtf8Bytes(this.textbody_));
            }
            if ((this_t0 & 0x10) != 0) {
                sink.putByte((byte)66);
                sink.putPrefixedData(ProtocolSupport.stringAsUtf8Bytes(this.htmlbody_));
            }
            int n4 = m = this.attachment_ != null ? this.attachment_.size() : 0;
            for (i = 0; i < m; ++i) {
                v = this.attachment_.get(i);
                sink.putByte((byte)74);
                sink.putForeign((ProtocolMessage)v);
            }
            int n5 = m = this.header_ != null ? this.header_.size() : 0;
            for (i = 0; i < m; ++i) {
                v = this.header_.get(i);
                sink.putByte((byte)82);
                sink.putForeign((ProtocolMessage)v);
            }
            if ((this_t0 & 0x20) != 0) {
                sink.putByte((byte)90);
                sink.putPrefixedData(ProtocolSupport.stringAsUtf8Bytes(this.amphtmlbody_));
            }
            if (this.uninterpreted != null) {
                this.uninterpreted.put(sink);
            }
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block14: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block14;
                    }
                    case 10: {
                        this.sender_ = source.getPrefixedData();
                        this_t0 |= 1;
                        continue block14;
                    }
                    case 18: {
                        this.replyto_ = source.getPrefixedData();
                        this_t0 |= 2;
                        continue block14;
                    }
                    case 26: {
                        this.addToAsBytes(source.getPrefixedData());
                        continue block14;
                    }
                    case 34: {
                        this.addCcAsBytes(source.getPrefixedData());
                        continue block14;
                    }
                    case 42: {
                        this.addBccAsBytes(source.getPrefixedData());
                        continue block14;
                    }
                    case 50: {
                        this.subject_ = source.getPrefixedData();
                        this_t0 |= 4;
                        continue block14;
                    }
                    case 58: {
                        this.textbody_ = source.getPrefixedData();
                        this_t0 |= 8;
                        continue block14;
                    }
                    case 66: {
                        this.htmlbody_ = source.getPrefixedData();
                        this_t0 |= 0x10;
                        continue block14;
                    }
                    case 74: {
                        source.push(source.getVarInt());
                        if (!this.addAttachment().merge(source)) {
                            result = false;
                            break block14;
                        }
                        source.pop();
                        continue block14;
                    }
                    case 82: {
                        source.push(source.getVarInt());
                        if (!this.addHeader().merge(source)) {
                            result = false;
                            break block14;
                        }
                        source.pop();
                        continue block14;
                    }
                    case 90: {
                        this.amphtmlbody_ = source.getPrefixedData();
                        this_t0 |= 0x20;
                        continue block14;
                    }
                    default: {
                        this.getUninterpretedForWrite().putBytes(tt, source.getUninterpreted(tt));
                        continue block14;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        @Override
        public MailMessage getDefaultInstanceForType() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public static final MailMessage getDefaultInstance() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        @Override
        public Parser<MailMessage> getParserForType() {
            return PARSER;
        }

        public static Parser<MailMessage> parser() {
            return PARSER;
        }

        @Override
        public MailMessage freeze() {
            this.sender_ = ProtocolSupport.freezeString(this.sender_);
            this.replyto_ = ProtocolSupport.freezeString(this.replyto_);
            this.to_ = ProtocolSupport.freezeStrings(this.to_);
            this.cc_ = ProtocolSupport.freezeStrings(this.cc_);
            this.bcc_ = ProtocolSupport.freezeStrings(this.bcc_);
            this.subject_ = ProtocolSupport.freezeString(this.subject_);
            this.textbody_ = ProtocolSupport.freezeString(this.textbody_);
            this.htmlbody_ = ProtocolSupport.freezeString(this.htmlbody_);
            this.amphtmlbody_ = ProtocolSupport.freezeString(this.amphtmlbody_);
            this.attachment_ = ProtocolSupport.freezeMessages(this.attachment_);
            this.header_ = ProtocolSupport.freezeMessages(this.header_);
            return this;
        }

        @Override
        public MailMessage unfreeze() {
            this.to_ = ProtocolSupport.unfreezeStrings(this.to_);
            this.cc_ = ProtocolSupport.unfreezeStrings(this.cc_);
            this.bcc_ = ProtocolSupport.unfreezeStrings(this.bcc_);
            this.attachment_ = ProtocolSupport.unfreezeMessages(this.attachment_);
            this.header_ = ProtocolSupport.unfreezeMessages(this.header_);
            return this;
        }

        @Override
        public boolean isFrozen() {
            return ProtocolSupport.isFrozenStrings(this.to_) || ProtocolSupport.isFrozenStrings(this.cc_) || ProtocolSupport.isFrozenStrings(this.bcc_) || ProtocolSupport.isFrozenMessages(this.attachment_) || ProtocolSupport.isFrozenMessages(this.header_);
        }

        public UninterpretedTags getUninterpretedForWrite() {
            if (this.uninterpreted == null) {
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        @Override
        protected String internalGetImmutableClassName() {
            return "com.google.appengine.api.mail.proto2api.MailServicePb$MailMessage";
        }

        static {
            MailMessage.text[0] = "ErrorCode";
            MailMessage.text[1] = "Sender";
            MailMessage.text[2] = "ReplyTo";
            MailMessage.text[3] = "To";
            MailMessage.text[4] = "Cc";
            MailMessage.text[5] = "Bcc";
            MailMessage.text[6] = "Subject";
            MailMessage.text[7] = "TextBody";
            MailMessage.text[8] = "HtmlBody";
            MailMessage.text[9] = "Attachment";
            MailMessage.text[10] = "Header";
            MailMessage.text[11] = "AmpHtmlBody";
            types = new int[12];
            Arrays.fill(types, 6);
            MailMessage.types[0] = 0;
            MailMessage.types[1] = 2;
            MailMessage.types[2] = 2;
            MailMessage.types[3] = 2;
            MailMessage.types[4] = 2;
            MailMessage.types[5] = 2;
            MailMessage.types[6] = 2;
            MailMessage.types[7] = 2;
            MailMessage.types[8] = 2;
            MailMessage.types[9] = 2;
            MailMessage.types[10] = 2;
            MailMessage.types[11] = 2;
        }

        private static class FieldAccessorTableHolder {
            private static final ProtocolMessage.FieldAccessorTable internal_field_accessor_table = new ProtocolMessage.FieldAccessorTable(MailMessage.class, StaticHolder.access$600(), "com.google.appengine.api.mail.proto2api.MailServicePbInternalDescriptors", 3);

            private FieldAccessorTableHolder() {
            }
        }

        private static final class StaticHolder {
            private static final ProtocolType protocolType = ProtocolType.newProtocolType(MailMessage.class, "Z!apphosting/api/mail_service.proto\n\u0016apphosting.MailMessage\u0013\u001a\u0006Sender \u0001(\u00020\t8\u0002\u0014\u0013\u001a\u0007ReplyTo \u0002(\u00020\t8\u0001\u0014\u0013\u001a\u0002To \u0003(\u00020\t8\u0003\u0014\u0013\u001a\u0002Cc \u0004(\u00020\t8\u0003\u0014\u0013\u001a\u0003Bcc \u0005(\u00020\t8\u0003\u0014\u0013\u001a\u0007Subject \u0006(\u00020\t8\u0002\u0014\u0013\u001a\bTextBody \u0007(\u00020\t8\u0001\u0014\u0013\u001a\bHtmlBody \b(\u00020\t8\u0001\u0014\u0013\u001a\u000bAmpHtmlBody \u000b(\u00020\t8\u0001\u0014\u0013\u001a\nAttachment \t(\u00020\u000b8\u0003J\u0019apphosting.MailAttachment\u00a3\u0001\u00aa\u0001\u0005ctype\u00b2\u0001\u0006proto2\u00a4\u0001\u0014\u0013\u001a\u0006Header \n(\u00020\u000b8\u0003J\u0015apphosting.MailHeader\u00a3\u0001\u00aa\u0001\u0005ctype\u00b2\u0001\u0006proto2\u00a4\u0001\u0014", new ProtocolType.FieldType("Sender", "sender", 1, 0, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("ReplyTo", "replyto", 2, 1, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("To", "to", 3, -1, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REPEATED), new ProtocolType.FieldType("Cc", "cc", 4, -1, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REPEATED), new ProtocolType.FieldType("Bcc", "bcc", 5, -1, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REPEATED), new ProtocolType.FieldType("Subject", "subject", 6, 2, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("TextBody", "textbody", 7, 3, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("HtmlBody", "htmlbody", 8, 4, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("AmpHtmlBody", "amphtmlbody", 11, 5, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("Attachment", "attachment", 9, -1, ProtocolType.FieldBaseType.FOREIGN, ProtocolType.Presence.REPEATED, MailAttachment.class), new ProtocolType.FieldType("Header", "header", 10, -1, ProtocolType.FieldBaseType.FOREIGN, ProtocolType.Presence.REPEATED, MailHeader.class));

            private StaticHolder() {
            }
        }
    }

    public static class MailHeader
    extends ProtocolMessage<MailHeader> {
        private static final long serialVersionUID = 1L;
        private volatile Object name_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private volatile Object value_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final MailHeader IMMUTABLE_DEFAULT_INSTANCE = new MailHeader(){
            private static final long serialVersionUID = 1L;

            @Override
            public MailHeader clearName() {
                return this;
            }

            @Override
            public MailHeader setNameAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public MailHeader setName(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public MailHeader setName(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public MailHeader clearValue() {
                return this;
            }

            @Override
            public MailHeader setValueAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public MailHeader setValue(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public MailHeader setValue(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public MailHeader mergeFrom(MailHeader that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            @Override
            public MailHeader freeze() {
                return this;
            }

            @Override
            public MailHeader unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public boolean isFrozen() {
                return true;
            }
        };
        private static final Parser<MailHeader> PARSER = new Proto2ParserAdapter<MailHeader>(MailHeader.getDefaultInstance());
        public static final int kname = 1;
        public static final int kvalue = 2;
        public static final String[] text = new String[3];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final byte[] getNameAsBytes() {
            if (ProtocolMessage.storeStringsOnlyAsBytes()) {
                return (byte[])this.name_;
            }
            byte[] name_tmp = ProtocolSupport.stringAsUtf8Bytes(this.name_);
            this.name_ = name_tmp;
            return name_tmp;
        }

        public final boolean hasName() {
            return (this.optional_0_ & 1) != 0;
        }

        public MailHeader clearName() {
            this.optional_0_ &= 0xFFFFFFFE;
            this.name_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public MailHeader setNameAsBytes(byte[] x) {
            this.optional_0_ |= 1;
            this.name_ = x;
            return this;
        }

        public final String getName() {
            Object ref = this.name_;
            if (ref instanceof String) {
                return (String)ref;
            }
            byte[] bytes = (byte[])ref;
            String str = ProtocolSupport.toStringUtf8(bytes);
            if (!ProtocolMessage.storeStringsOnlyAsBytes() && Internal.isValidUtf8(bytes)) {
                this.name_ = str;
            }
            return str;
        }

        public MailHeader setName(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.name_ = ProtocolMessage.storeStringsOnlyAsBytes() ? (Object)ProtocolSupport.toBytesUtf8(v) : v;
            return this;
        }

        public final String getName(Charset cs) {
            if (ProtocolMessage.storeStringsOnlyAsBytes()) {
                return ProtocolSupport.toString((byte[])this.name_, cs);
            }
            byte[] name_tmp = ProtocolSupport.stringAsUtf8Bytes(this.name_);
            this.name_ = name_tmp;
            return ProtocolSupport.toString(name_tmp, cs);
        }

        public MailHeader setName(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.name_ = ProtocolSupport.toBytes(v, cs);
            return this;
        }

        public final byte[] getValueAsBytes() {
            if (ProtocolMessage.storeStringsOnlyAsBytes()) {
                return (byte[])this.value_;
            }
            byte[] value_tmp = ProtocolSupport.stringAsUtf8Bytes(this.value_);
            this.value_ = value_tmp;
            return value_tmp;
        }

        public final boolean hasValue() {
            return (this.optional_0_ & 2) != 0;
        }

        public MailHeader clearValue() {
            this.optional_0_ &= 0xFFFFFFFD;
            this.value_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public MailHeader setValueAsBytes(byte[] x) {
            this.optional_0_ |= 2;
            this.value_ = x;
            return this;
        }

        public final String getValue() {
            Object ref = this.value_;
            if (ref instanceof String) {
                return (String)ref;
            }
            byte[] bytes = (byte[])ref;
            String str = ProtocolSupport.toStringUtf8(bytes);
            if (!ProtocolMessage.storeStringsOnlyAsBytes() && Internal.isValidUtf8(bytes)) {
                this.value_ = str;
            }
            return str;
        }

        public MailHeader setValue(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 2;
            this.value_ = ProtocolMessage.storeStringsOnlyAsBytes() ? (Object)ProtocolSupport.toBytesUtf8(v) : v;
            return this;
        }

        public final String getValue(Charset cs) {
            if (ProtocolMessage.storeStringsOnlyAsBytes()) {
                return ProtocolSupport.toString((byte[])this.value_, cs);
            }
            byte[] value_tmp = ProtocolSupport.stringAsUtf8Bytes(this.value_);
            this.value_ = value_tmp;
            return ProtocolSupport.toString(value_tmp, cs);
        }

        public MailHeader setValue(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 2;
            this.value_ = ProtocolSupport.toBytes(v, cs);
            return this;
        }

        @Override
        public MailHeader mergeFrom(MailHeader that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                this.name_ = that.name_;
            }
            if ((that_t0 & 2) != 0) {
                this_t0 |= 2;
                this.value_ = that.value_;
            }
            if (that.uninterpreted != null) {
                this.getUninterpretedForWrite().putAll(that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(MailHeader that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(MailHeader that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(MailHeader that, boolean ignoreUninterpreted) {
            if (that == null) {
                return false;
            }
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (this_t0 != that_t0) {
                return false;
            }
            if ((this_t0 & 1) != 0 && !ProtocolSupport.stringEquals(this.name_, that.name_)) {
                return false;
            }
            if ((this_t0 & 2) != 0 && !ProtocolSupport.stringEquals(this.value_, that.value_)) {
                return false;
            }
            return ignoreUninterpreted || UninterpretedTags.equivalent(this.uninterpreted, that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof MailHeader && this.equals((MailHeader)that);
        }

        @Override
        public int hashCode() {
            int hash = 1269833986;
            int this_t0 = this.optional_0_;
            hash = hash * 31 + ((this_t0 & 1) != 0 ? ProtocolSupport.stringHashCode(this.name_) : -113);
            hash = hash * 31 + ((this_t0 & 2) != 0 ? ProtocolSupport.stringHashCode(this.value_) : -113);
            if (this.uninterpreted != null && !this.uninterpreted.isEmpty()) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public boolean isInitialized() {
            int this_t0 = this.optional_0_;
            return (this_t0 & 3) == 3;
        }

        @Override
        public int encodingSize() {
            int n = 2 + ProtocolSupport.stringEncodingSize(this.name_) + ProtocolSupport.stringEncodingSize(this.value_);
            return this.uninterpreted != null ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int n = 12 + ProtocolSupport.stringAsUtf8Bytes(this.name_).length + ProtocolSupport.stringAsUtf8Bytes(this.value_).length;
            return this.uninterpreted != null ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        @Override
        public MessageAppender getMessageAppender() {
            return this.getUninterpretedForWrite();
        }

        @Override
        protected MailHeader internalClear() {
            this.optional_0_ = 0;
            this.name_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.value_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.uninterpreted = null;
            return this;
        }

        @Override
        public MailHeader newInstance() {
            return new MailHeader();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        protected ProtocolMessage.FieldAccessorTable internalGetFieldAccessorTable() {
            return FieldAccessorTableHolder.internal_field_accessor_table;
        }

        public static Descriptors.Descriptor getDescriptor() {
            return FieldAccessorTableHolder.internal_field_accessor_table.getDescriptor();
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            sink.putByte((byte)10);
            sink.putPrefixedData(ProtocolSupport.stringAsUtf8Bytes(this.name_));
            sink.putByte((byte)18);
            sink.putPrefixedData(ProtocolSupport.stringAsUtf8Bytes(this.value_));
            if (this.uninterpreted != null) {
                this.uninterpreted.put(sink);
            }
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block5: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block5;
                    }
                    case 10: {
                        this.name_ = source.getPrefixedData();
                        this_t0 |= 1;
                        continue block5;
                    }
                    case 18: {
                        this.value_ = source.getPrefixedData();
                        this_t0 |= 2;
                        continue block5;
                    }
                    default: {
                        this.getUninterpretedForWrite().putBytes(tt, source.getUninterpreted(tt));
                        continue block5;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        @Override
        public MailHeader getDefaultInstanceForType() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public static final MailHeader getDefaultInstance() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        @Override
        public Parser<MailHeader> getParserForType() {
            return PARSER;
        }

        public static Parser<MailHeader> parser() {
            return PARSER;
        }

        @Override
        public MailHeader freeze() {
            this.name_ = ProtocolSupport.freezeString(this.name_);
            this.value_ = ProtocolSupport.freezeString(this.value_);
            return this;
        }

        public UninterpretedTags getUninterpretedForWrite() {
            if (this.uninterpreted == null) {
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        @Override
        protected String internalGetImmutableClassName() {
            return "com.google.appengine.api.mail.proto2api.MailServicePb$MailHeader";
        }

        static {
            MailHeader.text[0] = "ErrorCode";
            MailHeader.text[1] = "name";
            MailHeader.text[2] = "value";
            types = new int[3];
            Arrays.fill(types, 6);
            MailHeader.types[0] = 0;
            MailHeader.types[1] = 2;
            MailHeader.types[2] = 2;
        }

        private static class FieldAccessorTableHolder {
            private static final ProtocolMessage.FieldAccessorTable internal_field_accessor_table = new ProtocolMessage.FieldAccessorTable(MailHeader.class, StaticHolder.access$400(), "com.google.appengine.api.mail.proto2api.MailServicePbInternalDescriptors", 2);

            private FieldAccessorTableHolder() {
            }
        }

        private static final class StaticHolder {
            private static final ProtocolType protocolType = ProtocolType.newProtocolType(MailHeader.class, "Z!apphosting/api/mail_service.proto\n\u0015apphosting.MailHeader\u0013\u001a\u0004name \u0001(\u00020\t8\u0002\u0014\u0013\u001a\u0005value \u0002(\u00020\t8\u0002\u0014", new ProtocolType.FieldType("name", "name", 1, 0, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("value", "value", 2, 1, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED));

            private StaticHolder() {
            }
        }
    }

    public static class MailAttachment
    extends ProtocolMessage<MailAttachment> {
        private static final long serialVersionUID = 1L;
        private volatile Object filename_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private volatile Object data_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private volatile Object contentid_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private boolean deprecated_contentid_set_ = false;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final MailAttachment IMMUTABLE_DEFAULT_INSTANCE = new MailAttachment(){
            private static final long serialVersionUID = 1L;

            @Override
            public MailAttachment clearFileName() {
                return this;
            }

            @Override
            public MailAttachment setFileNameAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public MailAttachment setFileName(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public MailAttachment setFileName(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public MailAttachment clearData() {
                return this;
            }

            @Override
            public MailAttachment setDataAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public MailAttachment setData(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public MailAttachment setData(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public MailAttachment clearContentID() {
                return this;
            }

            @Override
            public MailAttachment setContentIDAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public MailAttachment setContentID(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public MailAttachment setContentID(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public MailAttachment clearDEPRECATEDContentIDSet() {
                return this;
            }

            @Override
            public MailAttachment setDEPRECATEDContentIDSet(boolean x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public MailAttachment mergeFrom(MailAttachment that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            @Override
            public MailAttachment freeze() {
                return this;
            }

            @Override
            public MailAttachment unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public boolean isFrozen() {
                return true;
            }
        };
        private static final Parser<MailAttachment> PARSER = new Proto2ParserAdapter<MailAttachment>(MailAttachment.getDefaultInstance());
        public static final int kFileName = 1;
        public static final int kData = 2;
        public static final int kContentID = 3;
        public static final int kDEPRECATED_ContentID_set = 13;
        public static final String[] text = new String[14];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final byte[] getFileNameAsBytes() {
            if (ProtocolMessage.storeStringsOnlyAsBytes()) {
                return (byte[])this.filename_;
            }
            byte[] filename_tmp = ProtocolSupport.stringAsUtf8Bytes(this.filename_);
            this.filename_ = filename_tmp;
            return filename_tmp;
        }

        public final boolean hasFileName() {
            return (this.optional_0_ & 1) != 0;
        }

        public MailAttachment clearFileName() {
            this.optional_0_ &= 0xFFFFFFFE;
            this.filename_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public MailAttachment setFileNameAsBytes(byte[] x) {
            this.optional_0_ |= 1;
            this.filename_ = x;
            return this;
        }

        public final String getFileName() {
            Object ref = this.filename_;
            if (ref instanceof String) {
                return (String)ref;
            }
            byte[] bytes = (byte[])ref;
            String str = ProtocolSupport.toStringUtf8(bytes);
            if (!ProtocolMessage.storeStringsOnlyAsBytes() && Internal.isValidUtf8(bytes)) {
                this.filename_ = str;
            }
            return str;
        }

        public MailAttachment setFileName(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.filename_ = ProtocolMessage.storeStringsOnlyAsBytes() ? (Object)ProtocolSupport.toBytesUtf8(v) : v;
            return this;
        }

        public final String getFileName(Charset cs) {
            if (ProtocolMessage.storeStringsOnlyAsBytes()) {
                return ProtocolSupport.toString((byte[])this.filename_, cs);
            }
            byte[] filename_tmp = ProtocolSupport.stringAsUtf8Bytes(this.filename_);
            this.filename_ = filename_tmp;
            return ProtocolSupport.toString(filename_tmp, cs);
        }

        public MailAttachment setFileName(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.filename_ = ProtocolSupport.toBytes(v, cs);
            return this;
        }

        public final byte[] getDataAsBytes() {
            if (ProtocolMessage.storeStringsOnlyAsBytes()) {
                return (byte[])this.data_;
            }
            byte[] data_tmp = ProtocolSupport.stringAsUtf8Bytes(this.data_);
            this.data_ = data_tmp;
            return data_tmp;
        }

        public final boolean hasData() {
            return (this.optional_0_ & 2) != 0;
        }

        public MailAttachment clearData() {
            this.optional_0_ &= 0xFFFFFFFD;
            this.data_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public MailAttachment setDataAsBytes(byte[] x) {
            this.optional_0_ |= 2;
            this.data_ = x;
            return this;
        }

        public final String getData() {
            Object ref = this.data_;
            if (ref instanceof String) {
                return (String)ref;
            }
            byte[] bytes = (byte[])ref;
            String str = ProtocolSupport.toStringUtf8(bytes);
            if (!ProtocolMessage.storeStringsOnlyAsBytes() && Internal.isValidUtf8(bytes)) {
                this.data_ = str;
            }
            return str;
        }

        public MailAttachment setData(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 2;
            this.data_ = ProtocolMessage.storeStringsOnlyAsBytes() ? (Object)ProtocolSupport.toBytesUtf8(v) : v;
            return this;
        }

        public final String getData(Charset cs) {
            if (ProtocolMessage.storeStringsOnlyAsBytes()) {
                return ProtocolSupport.toString((byte[])this.data_, cs);
            }
            byte[] data_tmp = ProtocolSupport.stringAsUtf8Bytes(this.data_);
            this.data_ = data_tmp;
            return ProtocolSupport.toString(data_tmp, cs);
        }

        public MailAttachment setData(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 2;
            this.data_ = ProtocolSupport.toBytes(v, cs);
            return this;
        }

        public final byte[] getContentIDAsBytes() {
            if (ProtocolMessage.storeStringsOnlyAsBytes()) {
                return (byte[])this.contentid_;
            }
            byte[] contentid_tmp = ProtocolSupport.stringAsUtf8Bytes(this.contentid_);
            this.contentid_ = contentid_tmp;
            return contentid_tmp;
        }

        public final boolean hasContentID() {
            return (this.optional_0_ & 4) != 0;
        }

        public MailAttachment clearContentID() {
            this.optional_0_ &= 0xFFFFFFFB;
            this.contentid_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public MailAttachment setContentIDAsBytes(byte[] x) {
            this.optional_0_ |= 4;
            this.contentid_ = x;
            return this;
        }

        public final String getContentID() {
            Object ref = this.contentid_;
            if (ref instanceof String) {
                return (String)ref;
            }
            byte[] bytes = (byte[])ref;
            String str = ProtocolSupport.toStringUtf8(bytes);
            if (!ProtocolMessage.storeStringsOnlyAsBytes() && Internal.isValidUtf8(bytes)) {
                this.contentid_ = str;
            }
            return str;
        }

        public MailAttachment setContentID(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 4;
            this.contentid_ = ProtocolMessage.storeStringsOnlyAsBytes() ? (Object)ProtocolSupport.toBytesUtf8(v) : v;
            return this;
        }

        public final String getContentID(Charset cs) {
            if (ProtocolMessage.storeStringsOnlyAsBytes()) {
                return ProtocolSupport.toString((byte[])this.contentid_, cs);
            }
            byte[] contentid_tmp = ProtocolSupport.stringAsUtf8Bytes(this.contentid_);
            this.contentid_ = contentid_tmp;
            return ProtocolSupport.toString(contentid_tmp, cs);
        }

        public MailAttachment setContentID(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 4;
            this.contentid_ = ProtocolSupport.toBytes(v, cs);
            return this;
        }

        public final boolean isDEPRECATEDContentIDSet() {
            return this.deprecated_contentid_set_;
        }

        public final boolean hasDEPRECATEDContentIDSet() {
            return (this.optional_0_ & 8) != 0;
        }

        public MailAttachment clearDEPRECATEDContentIDSet() {
            this.optional_0_ &= 0xFFFFFFF7;
            this.deprecated_contentid_set_ = false;
            return this;
        }

        public MailAttachment setDEPRECATEDContentIDSet(boolean x) {
            this.optional_0_ |= 8;
            this.deprecated_contentid_set_ = x;
            return this;
        }

        @Override
        public MailAttachment mergeFrom(MailAttachment that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                this.filename_ = that.filename_;
            }
            if ((that_t0 & 2) != 0) {
                this_t0 |= 2;
                this.data_ = that.data_;
            }
            if ((that_t0 & 4) != 0) {
                this_t0 |= 4;
                this.contentid_ = that.contentid_;
            }
            if ((that_t0 & 8) != 0) {
                this_t0 |= 8;
                this.deprecated_contentid_set_ = that.deprecated_contentid_set_;
            }
            if (that.uninterpreted != null) {
                this.getUninterpretedForWrite().putAll(that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(MailAttachment that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(MailAttachment that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(MailAttachment that, boolean ignoreUninterpreted) {
            if (that == null) {
                return false;
            }
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (this_t0 != that_t0) {
                return false;
            }
            if ((this_t0 & 1) != 0 && !ProtocolSupport.stringEquals(this.filename_, that.filename_)) {
                return false;
            }
            if ((this_t0 & 2) != 0 && !ProtocolSupport.stringEquals(this.data_, that.data_)) {
                return false;
            }
            if ((this_t0 & 4) != 0 && !ProtocolSupport.stringEquals(this.contentid_, that.contentid_)) {
                return false;
            }
            if ((this_t0 & 8) != 0 && this.deprecated_contentid_set_ != that.deprecated_contentid_set_) {
                return false;
            }
            return ignoreUninterpreted || UninterpretedTags.equivalent(this.uninterpreted, that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof MailAttachment && this.equals((MailAttachment)that);
        }

        @Override
        public int hashCode() {
            int hash = -1936143812;
            int this_t0 = this.optional_0_;
            hash = hash * 31 + ((this_t0 & 1) != 0 ? ProtocolSupport.stringHashCode(this.filename_) : -113);
            hash = hash * 31 + ((this_t0 & 2) != 0 ? ProtocolSupport.stringHashCode(this.data_) : -113);
            hash = hash * 31 + ((this_t0 & 4) != 0 ? ProtocolSupport.stringHashCode(this.contentid_) : -113);
            hash = hash * 31 + ((this_t0 & 8) != 0 ? (this.deprecated_contentid_set_ ? 1231 : 1237) : -113);
            if (this.uninterpreted != null && !this.uninterpreted.isEmpty()) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public boolean isInitialized() {
            int this_t0 = this.optional_0_;
            return (this_t0 & 3) == 3;
        }

        @Override
        public int encodingSize() {
            int n = 2 + ProtocolSupport.stringEncodingSize(this.filename_) + ProtocolSupport.stringEncodingSize(this.data_);
            int this_t0 = this.optional_0_;
            if ((this_t0 & 0xC) != 0) {
                if ((this_t0 & 4) != 0) {
                    n += 1 + ProtocolSupport.stringEncodingSize(this.contentid_);
                }
                if ((this_t0 & 8) != 0) {
                    n += 2;
                }
            }
            return this.uninterpreted != null ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int n = 14 + ProtocolSupport.stringAsUtf8Bytes(this.filename_).length + ProtocolSupport.stringAsUtf8Bytes(this.data_).length;
            int this_t0 = this.optional_0_;
            if ((this_t0 & 4) != 0) {
                n += 6 + ProtocolSupport.stringAsUtf8Bytes(this.contentid_).length;
            }
            return this.uninterpreted != null ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        @Override
        public MessageAppender getMessageAppender() {
            return this.getUninterpretedForWrite();
        }

        @Override
        protected MailAttachment internalClear() {
            this.optional_0_ = 0;
            this.filename_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.data_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.contentid_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.deprecated_contentid_set_ = false;
            this.uninterpreted = null;
            return this;
        }

        @Override
        public MailAttachment newInstance() {
            return new MailAttachment();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        protected ProtocolMessage.FieldAccessorTable internalGetFieldAccessorTable() {
            return FieldAccessorTableHolder.internal_field_accessor_table;
        }

        public static Descriptors.Descriptor getDescriptor() {
            return FieldAccessorTableHolder.internal_field_accessor_table.getDescriptor();
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            sink.putByte((byte)10);
            sink.putPrefixedData(ProtocolSupport.stringAsUtf8Bytes(this.filename_));
            sink.putByte((byte)18);
            sink.putPrefixedData(ProtocolSupport.stringAsUtf8Bytes(this.data_));
            int this_t0 = this.optional_0_;
            if ((this_t0 & 4) != 0) {
                sink.putByte((byte)26);
                sink.putPrefixedData(ProtocolSupport.stringAsUtf8Bytes(this.contentid_));
            }
            if ((this_t0 & 8) != 0) {
                sink.putByte((byte)104);
                sink.putBoolean(this.deprecated_contentid_set_);
            }
            if (this.uninterpreted != null) {
                this.uninterpreted.put(sink);
            }
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block7: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block7;
                    }
                    case 10: {
                        this.filename_ = source.getPrefixedData();
                        this_t0 |= 1;
                        continue block7;
                    }
                    case 18: {
                        this.data_ = source.getPrefixedData();
                        this_t0 |= 2;
                        continue block7;
                    }
                    case 26: {
                        this.contentid_ = source.getPrefixedData();
                        this_t0 |= 4;
                        continue block7;
                    }
                    case 104: {
                        this.deprecated_contentid_set_ = source.getBoolean();
                        this_t0 |= 8;
                        continue block7;
                    }
                    default: {
                        this.getUninterpretedForWrite().putBytes(tt, source.getUninterpreted(tt));
                        continue block7;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        @Override
        public MailAttachment getDefaultInstanceForType() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public static final MailAttachment getDefaultInstance() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        @Override
        public Parser<MailAttachment> getParserForType() {
            return PARSER;
        }

        public static Parser<MailAttachment> parser() {
            return PARSER;
        }

        @Override
        public MailAttachment freeze() {
            this.filename_ = ProtocolSupport.freezeString(this.filename_);
            this.data_ = ProtocolSupport.freezeString(this.data_);
            this.contentid_ = ProtocolSupport.freezeString(this.contentid_);
            return this;
        }

        public UninterpretedTags getUninterpretedForWrite() {
            if (this.uninterpreted == null) {
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        @Override
        protected String internalGetImmutableClassName() {
            return "com.google.appengine.api.mail.proto2api.MailServicePb$MailAttachment";
        }

        static {
            MailAttachment.text[0] = "ErrorCode";
            MailAttachment.text[1] = "FileName";
            MailAttachment.text[2] = "Data";
            MailAttachment.text[3] = "ContentID";
            MailAttachment.text[13] = "DEPRECATED_ContentID_set";
            types = new int[14];
            Arrays.fill(types, 6);
            MailAttachment.types[0] = 0;
            MailAttachment.types[1] = 2;
            MailAttachment.types[2] = 2;
            MailAttachment.types[3] = 2;
            MailAttachment.types[13] = 0;
        }

        private static class FieldAccessorTableHolder {
            private static final ProtocolMessage.FieldAccessorTable internal_field_accessor_table = new ProtocolMessage.FieldAccessorTable(MailAttachment.class, StaticHolder.access$200(), "com.google.appengine.api.mail.proto2api.MailServicePbInternalDescriptors", 1);

            private FieldAccessorTableHolder() {
            }
        }

        private static final class StaticHolder {
            private static final ProtocolType protocolType = ProtocolType.newProtocolType(MailAttachment.class, "Z!apphosting/api/mail_service.proto\n\u0019apphosting.MailAttachment\u0013\u001a\bFileName \u0001(\u00020\t8\u0002\u0014\u0013\u001a\u0004Data \u0002(\u00020\t8\u0002\u0014\u0013\u001a\tContentID \u0003(\u00020\t8\u0001\u0014\u0013\u001a\u0018DEPRECATED_ContentID_set \r(\u00000\b8\u0001\u00d0\u0001\u0001\u0014", new ProtocolType.FieldType("FileName", "filename", 1, 0, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("Data", "data", 2, 1, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("ContentID", "contentid", 3, 2, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("DEPRECATED_ContentID_set", "deprecated_contentid_set", 13, 3, ProtocolType.FieldBaseType.BOOL, ProtocolType.Presence.OPTIONAL));

            private StaticHolder() {
            }
        }
    }

    public static class MailServiceError
    extends ProtocolMessage<MailServiceError> {
        private static final long serialVersionUID = 1L;
        private UninterpretedTags uninterpreted;
        public static final MailServiceError IMMUTABLE_DEFAULT_INSTANCE = new MailServiceError(){
            private static final long serialVersionUID = 1L;

            @Override
            public MailServiceError mergeFrom(MailServiceError that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            @Override
            public MailServiceError freeze() {
                return this;
            }

            @Override
            public MailServiceError unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            @Override
            public boolean isFrozen() {
                return true;
            }
        };
        private static final Parser<MailServiceError> PARSER = new Proto2ParserAdapter<MailServiceError>(MailServiceError.getDefaultInstance());
        public static final String[] text = new String[1];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        @Override
        public MailServiceError mergeFrom(MailServiceError that) {
            assert (that != this);
            if (that.uninterpreted != null) {
                this.getUninterpretedForWrite().putAll(that.uninterpreted);
            }
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(MailServiceError that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(MailServiceError that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(MailServiceError that, boolean ignoreUninterpreted) {
            if (that == null) {
                return false;
            }
            if (that == this) {
                return true;
            }
            return ignoreUninterpreted || UninterpretedTags.equivalent(this.uninterpreted, that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof MailServiceError && this.equals((MailServiceError)that);
        }

        @Override
        public int hashCode() {
            int hash = -448357120;
            if (this.uninterpreted != null && !this.uninterpreted.isEmpty()) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public boolean isInitialized() {
            return true;
        }

        @Override
        public int encodingSize() {
            int n = 0;
            return this.uninterpreted != null ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int n = 0;
            return this.uninterpreted != null ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        @Override
        public MessageAppender getMessageAppender() {
            return this.getUninterpretedForWrite();
        }

        @Override
        protected MailServiceError internalClear() {
            this.uninterpreted = null;
            return this;
        }

        @Override
        public MailServiceError newInstance() {
            return new MailServiceError();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        protected ProtocolMessage.FieldAccessorTable internalGetFieldAccessorTable() {
            return FieldAccessorTableHolder.internal_field_accessor_table;
        }

        public static Descriptors.Descriptor getDescriptor() {
            return FieldAccessorTableHolder.internal_field_accessor_table.getDescriptor();
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            if (this.uninterpreted != null) {
                this.uninterpreted.put(sink);
            }
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            block3: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block3;
                    }
                    default: {
                        this.getUninterpretedForWrite().putBytes(tt, source.getUninterpreted(tt));
                        continue block3;
                    }
                }
            }
            return result;
        }

        @Override
        public MailServiceError getDefaultInstanceForType() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public static final MailServiceError getDefaultInstance() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        @Override
        public Parser<MailServiceError> getParserForType() {
            return PARSER;
        }

        public static Parser<MailServiceError> parser() {
            return PARSER;
        }

        public UninterpretedTags getUninterpretedForWrite() {
            if (this.uninterpreted == null) {
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        @Override
        protected String internalGetImmutableClassName() {
            return "com.google.appengine.api.mail.proto2api.MailServicePb$MailServiceError";
        }

        static {
            MailServiceError.text[0] = "ErrorCode";
            types = new int[1];
            Arrays.fill(types, 6);
            MailServiceError.types[0] = 0;
        }

        private static class FieldAccessorTableHolder {
            private static final ProtocolMessage.FieldAccessorTable internal_field_accessor_table = new ProtocolMessage.FieldAccessorTable(MailServiceError.class, StaticHolder.access$000(), "com.google.appengine.api.mail.proto2api.MailServicePbInternalDescriptors", 0);

            private FieldAccessorTableHolder() {
            }
        }

        private static final class StaticHolder {
            private static final ProtocolType protocolType = ProtocolType.newProtocolType(MailServiceError.class, "Z!apphosting/api/mail_service.proto\n\u001bapphosting.MailServiceErrorsz\tErrorCode\u008b\u0001\u0092\u0001\u0002OK\u0098\u0001\u0000\u008c\u0001\u008b\u0001\u0092\u0001\u000eINTERNAL_ERROR\u0098\u0001\u0001\u008c\u0001\u008b\u0001\u0092\u0001\u000bBAD_REQUEST\u0098\u0001\u0002\u008c\u0001\u008b\u0001\u0092\u0001\u0013UNAUTHORIZED_SENDER\u0098\u0001\u0003\u008c\u0001\u008b\u0001\u0092\u0001\u0017INVALID_ATTACHMENT_TYPE\u0098\u0001\u0004\u008c\u0001\u008b\u0001\u0092\u0001\u0013INVALID_HEADER_NAME\u0098\u0001\u0005\u008c\u0001\u008b\u0001\u0092\u0001\u0012INVALID_CONTENT_ID\u0098\u0001\u0006\u008c\u0001t", new ProtocolType.FieldType[0]);

            private StaticHolder() {
            }
        }

        public static enum ErrorCode implements ProtocolMessageEnum
        {
            OK(0),
            INTERNAL_ERROR(1),
            BAD_REQUEST(2),
            UNAUTHORIZED_SENDER(3),
            INVALID_ATTACHMENT_TYPE(4),
            INVALID_HEADER_NAME(5),
            INVALID_CONTENT_ID(6);

            public static final ErrorCode ErrorCode_MIN;
            public static final ErrorCode ErrorCode_MAX;
            private final int value;

            @Override
            public int getValue() {
                return this.value;
            }

            public static ErrorCode forNumber(int value) {
                return ErrorCode.valueOf(value);
            }

            public static ErrorCode valueOf(int value) {
                switch (value) {
                    case 0: {
                        return OK;
                    }
                    case 1: {
                        return INTERNAL_ERROR;
                    }
                    case 2: {
                        return BAD_REQUEST;
                    }
                    case 3: {
                        return UNAUTHORIZED_SENDER;
                    }
                    case 4: {
                        return INVALID_ATTACHMENT_TYPE;
                    }
                    case 5: {
                        return INVALID_HEADER_NAME;
                    }
                    case 6: {
                        return INVALID_CONTENT_ID;
                    }
                }
                return null;
            }

            private ErrorCode(int v) {
                this.value = v;
            }

            static {
                ErrorCode_MIN = OK;
                ErrorCode_MAX = INVALID_CONTENT_ID;
            }
        }
    }
}

