/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.net.base;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.net.InetAddresses;
import com.google.appengine.repackaged.com.google.errorprone.annotations.Immutable;
import com.google.net.base.CidrAddressBlock;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Level;
import javax.annotation.Nullable;

@Immutable
public class CidrAddressBlock
implements Iterable<InetAddress>,
Serializable {
    private final InetAddress ip;
    private final int netmask;
    private static final int AUTO_NETMASK = -1;

    public CidrAddressBlock(String s) {
        this(CidrAddressBlock.parseInetAddress(s), CidrAddressBlock.parseNetmask(s), false);
    }

    public CidrAddressBlock(String ip, int netmask) {
        this(InetAddresses.forString(ip), CidrAddressBlock.checkNotNegative(netmask), false);
    }

    public CidrAddressBlock(InetAddress ip) {
        this(ip, -1, false);
    }

    public CidrAddressBlock(InetAddress ip, int netmask) {
        this(ip, CidrAddressBlock.checkNotNegative(netmask), false);
    }

    public static CidrAddressBlock create(InetAddress ip, int netmask) {
        return new CidrAddressBlock(ip, CidrAddressBlock.checkNotNegative(netmask), true);
    }

    public static CidrAddressBlock create(String s) {
        return new CidrAddressBlock(CidrAddressBlock.parseInetAddress(s), CidrAddressBlock.parseNetmask(s), true);
    }

    private CidrAddressBlock(InetAddress ip, int netmask, boolean truncate) {
        if (netmask == -1) {
            this.ip = ip;
            this.netmask = ip.getAddress().length * 8;
            return;
        }
        InetAddress truncatedIp = CidrAddressBlock.applyNetmask(ip, netmask);
        if (!truncate && !truncatedIp.equals(ip)) {
            String string = CidrAddressBlock.getCidrString(ip, netmask);
            String string2 = CidrAddressBlock.getCidrString(truncatedIp, netmask);
            throw new IllegalArgumentException(new StringBuilder(58 + String.valueOf(string).length() + String.valueOf(string2).length()).append("CIDR block: ").append(string).append(" is not properly truncated, should have been: ").append(string2).toString());
        }
        this.ip = truncatedIp;
        this.netmask = netmask;
    }

    private static String getCidrString(InetAddress ip, int netmask) {
        String string = ip.getHostAddress();
        return new StringBuilder(12 + String.valueOf(string).length()).append(string).append("/").append(netmask).toString();
    }

    private static InetAddress parseInetAddress(String s) {
        int slash = s.indexOf(47);
        return InetAddresses.forString(slash < 0 ? s : s.substring(0, slash));
    }

    private static int parseNetmask(String s) {
        int slash = s.indexOf(47);
        if (slash < 0) {
            return -1;
        }
        try {
            return CidrAddressBlock.checkNotNegative(Integer.parseInt(s.substring(slash + 1)));
        }
        catch (NumberFormatException nfe) {
            String string = String.valueOf(s.substring(slash + 1));
            throw new IllegalArgumentException(string.length() != 0 ? "Invalid netmask: ".concat(string) : new String("Invalid netmask: "));
        }
    }

    private static int checkNotNegative(int netmask) {
        Preconditions.checkArgument(netmask >= 0, "CIDR netmask '%s' must not be negative.", netmask);
        return netmask;
    }

    private static InetAddress applyNetmask(InetAddress ip, int netmask) {
        byte[] bytes = ip.getAddress();
        Preconditions.checkArgument(netmask >= 0 && netmask <= bytes.length * 8, "CIDR netmask '%s' is out of range: 0 <= netmask <= %s.", netmask, bytes.length * 8);
        int cidrByte = netmask == 0 ? 0 : (netmask - 1) / 8;
        int numBits = netmask - cidrByte * 8;
        int bitMask = -1 << 8 - numBits;
        bytes[cidrByte] = (byte)(bytes[cidrByte] & bitMask);
        for (int i = cidrByte + 1; i < bytes.length; ++i) {
            bytes[i] = 0;
        }
        try {
            return InetAddress.getByAddress(bytes);
        }
        catch (UnknownHostException uhe) {
            throw new IllegalArgumentException(String.format("Error creating InetAddress from byte array '%s'.", Arrays.toString(bytes)), uhe);
        }
    }

    public String getIp() {
        return this.ip.getHostAddress();
    }

    public InetAddress getInetAddress() {
        return this.ip;
    }

    public int getNetmask() {
        return this.netmask;
    }

    public boolean contains(@Nullable InetAddress ipAddr) {
        if (ipAddr == null) {
            return false;
        }
        if (ipAddr.getClass() != this.ip.getClass()) {
            return false;
        }
        try {
            return this.ip.equals(CidrAddressBlock.applyNetmask(ipAddr, this.netmask));
        }
        catch (IllegalArgumentException iae) {
            CidrAddressBlock.CidrAddressBlockLogger.access$000().logp(Level.WARNING, "com.google.appengine.repackaged.com.google.net.base.CidrAddressBlock", "contains", iae.getMessage());
            return false;
        }
    }

    public boolean contains(@Nullable CidrAddressBlock cidr) {
        if (cidr == null) {
            return false;
        }
        if (cidr.netmask < this.netmask) {
            return false;
        }
        return this.contains(cidr.getInetAddress());
    }

    public boolean contains(@Nullable String s) {
        if (s == null) {
            return false;
        }
        try {
            return this.contains(CidrAddressBlock.create(s));
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    public InetAddress getAllOnesAddress() {
        byte[] bytes = this.ip.getAddress();
        int cidrByte = this.netmask == 0 ? 0 : (this.netmask - 1) / 8;
        int numBits = this.netmask - cidrByte * 8;
        int bitMask = ~(-1 << 8 - numBits);
        bytes[cidrByte] = (byte)(bytes[cidrByte] | bitMask);
        for (int i = cidrByte + 1; i < bytes.length; ++i) {
            bytes[i] = -1;
        }
        try {
            return InetAddress.getByAddress(bytes);
        }
        catch (UnknownHostException uhe) {
            throw new IllegalArgumentException(String.format("Error creating InetAddress from byte array '%s'.", Arrays.toString(bytes)), uhe);
        }
    }

    @Override
    public Iterator<InetAddress> iterator() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public int hashCode() {
        return InetAddresses.coerceToInteger(this.ip);
    }

    public boolean equals(@Nullable Object o) {
        if (!(o instanceof CidrAddressBlock)) {
            return false;
        }
        CidrAddressBlock cidr = (CidrAddressBlock)o;
        return this.ip.equals(cidr.ip) && this.netmask == cidr.netmask;
    }

    public String toString() {
        return CidrAddressBlock.getCidrString(this.ip, this.netmask);
    }
}

