/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner.config;

import com.google.caliper.runner.config.CaliperConfig;
import com.google.caliper.runner.config.DeviceType;
import com.google.caliper.runner.config.InvalidConfigurationException;
import com.google.caliper.runner.config.LoggingConfigLoader;
import com.google.caliper.runner.options.CaliperOptions;
import com.google.caliper.util.Util;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.io.ByteSource;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import dagger.Module;
import dagger.Provides;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.LogManager;
import javax.inject.Singleton;

@Module
public abstract class CaliperConfigModule {
    private CaliperConfigModule() {
    }

    @Provides
    @Singleton
    static CaliperConfig caliperConfig(CaliperOptions caliperOptions, LoggingConfigLoader loggingConfigLoader) {
        loggingConfigLoader.loadLoggingConfig();
        ImmutableMap<String, String> globalConfig = CaliperConfigModule.loadGlobalConfig();
        ImmutableMap<String, String> userConfig = CaliperConfigModule.loadUserConfig(caliperOptions);
        ImmutableMap<String, String> commandLineConfig = caliperOptions.configProperties();
        CaliperConfig config = CaliperConfigModule.merge(globalConfig, userConfig, commandLineConfig);
        DeviceType deviceType = config.getDeviceConfig(caliperOptions).type();
        String string = String.valueOf((Object)deviceType);
        ImmutableMap<String, String> globalDeviceTypeConfig = CaliperConfigModule.loadGlobalConfig(new StringBuilder(1 + String.valueOf(string).length()).append("-").append(string).toString());
        String string2 = String.valueOf((Object)deviceType);
        ImmutableMap<String, String> userDeviceTypeConfig = CaliperConfigModule.loadUserConfig(caliperOptions, new StringBuilder(1 + String.valueOf(string2).length()).append("-").append(string2).toString());
        return CaliperConfigModule.merge(globalConfig, globalDeviceTypeConfig, userConfig, userDeviceTypeConfig, commandLineConfig);
    }

    private static ImmutableMap<String, String> loadUserConfig(CaliperOptions caliperOptions) {
        File configFile = caliperOptions.caliperConfigFile();
        if (configFile.exists()) {
            try {
                return Util.loadProperties((ByteSource)Files.asByteSource((File)configFile));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        ByteSource supplier = Util.resourceSupplier(CaliperConfig.class, (String)"default-config.properties");
        CaliperConfigModule.tryCopyIfNeeded(supplier, configFile);
        try {
            return Util.loadProperties((ByteSource)supplier);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static ImmutableMap<String, String> loadUserConfig(CaliperOptions caliperOptions, String suffix) {
        File mainConfigFile = caliperOptions.caliperConfigFile().getAbsoluteFile();
        String mainConfigFileBaseName = Files.getNameWithoutExtension((String)mainConfigFile.getName());
        String configFileName = new StringBuilder(11 + String.valueOf(mainConfigFileBaseName).length() + String.valueOf(suffix).length()).append(mainConfigFileBaseName).append(suffix).append(".properties").toString();
        File parentDir = mainConfigFile.getParentFile();
        File configFile = parentDir == null ? new File(configFileName) : new File(parentDir, configFileName);
        if (configFile.exists()) {
            try {
                return Util.loadProperties((ByteSource)Files.asByteSource((File)configFile));
            }
            catch (IOException e) {
                String string = String.valueOf(configFile);
                throw new InvalidConfigurationException(new StringBuilder(27 + String.valueOf(string).length()).append("Couldn't load config file: ").append(string).toString(), e);
            }
        }
        return ImmutableMap.of();
    }

    private static CaliperConfig merge(ImmutableMap<String, String> ... maps) {
        HashMap result = Maps.newHashMap();
        for (ImmutableMap<String, String> map : maps) {
            result.putAll(map);
        }
        Iterables.removeIf(result.values(), (Predicate)Predicates.equalTo((Object)""));
        return new CaliperConfig((ImmutableMap<String, String>)ImmutableMap.copyOf((Map)result));
    }

    private static ImmutableMap<String, String> loadGlobalConfig() {
        return CaliperConfigModule.loadGlobalConfig("");
    }

    private static ImmutableMap<String, String> loadGlobalConfig(String suffix) {
        try {
            return Util.loadProperties((ByteSource)Util.resourceSupplier(CaliperConfig.class, (String)new StringBuilder(24 + String.valueOf(suffix).length()).append("global-config").append(suffix).append(".properties").toString()));
        }
        catch (IOException impossible) {
            throw new AssertionError((Object)impossible);
        }
    }

    private static void tryCopyIfNeeded(ByteSource supplier, File rcFile) {
        if (!rcFile.exists()) {
            try {
                supplier.copyTo(Files.asByteSink((File)rcFile, (FileWriteMode[])new FileWriteMode[0]));
            }
            catch (IOException e) {
                rcFile.delete();
            }
        }
    }

    @Provides
    static LogManager provideLogManager() {
        return LogManager.getLogManager();
    }
}

