/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner.instrument;

import com.google.caliper.bridge.AbstractLogMessageVisitor;
import com.google.caliper.bridge.StopMeasurementLogMessage;
import com.google.caliper.core.BenchmarkClassModel;
import com.google.caliper.core.InvalidBenchmarkException;
import com.google.caliper.model.ArbitraryMeasurement;
import com.google.caliper.model.InstrumentType;
import com.google.caliper.model.Measurement;
import com.google.caliper.runner.config.SupportsVmType;
import com.google.caliper.runner.config.VmType;
import com.google.caliper.runner.instrument.Instrument;
import com.google.caliper.runner.instrument.MeasurementCollectingVisitor;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.lang.reflect.Modifier;
import java.util.Collection;

@SupportsVmType(value={VmType.JVM})
public final class ArbitraryMeasurementInstrument
extends Instrument {
    @Override
    public boolean isBenchmarkMethod(BenchmarkClassModel.MethodModel method) {
        return method.isAnnotationPresent(ArbitraryMeasurement.class);
    }

    @Override
    public Instrument.InstrumentedMethod createInstrumentedMethod(BenchmarkClassModel.MethodModel benchmarkMethod) throws InvalidBenchmarkException {
        if (!benchmarkMethod.parameterTypes().isEmpty()) {
            String string = String.valueOf(benchmarkMethod.name());
            throw new InvalidBenchmarkException(string.length() != 0 ? "Arbitrary measurement methods should take no parameters: ".concat(string) : new String("Arbitrary measurement methods should take no parameters: "), new Object[0]);
        }
        if (!benchmarkMethod.returnType().isPresent() || !((String)benchmarkMethod.returnType().get()).equals("double")) {
            String string = String.valueOf(benchmarkMethod.name());
            throw new InvalidBenchmarkException(string.length() != 0 ? "Arbitrary measurement methods must have a return type of double: ".concat(string) : new String("Arbitrary measurement methods must have a return type of double: "), new Object[0]);
        }
        if (Modifier.isStatic(benchmarkMethod.modifiers())) {
            String string = String.valueOf(benchmarkMethod.name());
            throw new InvalidBenchmarkException(string.length() != 0 ? "Arbitrary measurement methods must not be static: ".concat(string) : new String("Arbitrary measurement methods must not be static: "), new Object[0]);
        }
        if (!Modifier.isPublic(benchmarkMethod.modifiers())) {
            String string = String.valueOf(benchmarkMethod.name());
            throw new InvalidBenchmarkException(string.length() != 0 ? "Arbitrary measurement methods must be public: ".concat(string) : new String("Arbitrary measurement methods must be public: "), new Object[0]);
        }
        return new ArbitraryMeasurementInstrumentedMethod(benchmarkMethod);
    }

    @Override
    public boolean parallelizable() {
        return false;
    }

    @Override
    public ImmutableSet<String> instrumentOptions() {
        return ImmutableSet.of((Object)"gcBeforeEach");
    }

    private static final class SingleMeasurementCollectingVisitor
    extends AbstractLogMessageVisitor
    implements MeasurementCollectingVisitor {
        Optional<Measurement> measurement = Optional.absent();

        private SingleMeasurementCollectingVisitor() {
        }

        @Override
        public boolean isDoneCollecting() {
            return this.measurement.isPresent();
        }

        @Override
        public boolean isWarmupComplete() {
            return true;
        }

        @Override
        public ImmutableList<Measurement> getMeasurements() {
            return ImmutableList.copyOf((Collection)this.measurement.asSet());
        }

        public void visit(StopMeasurementLogMessage logMessage) {
            this.measurement = Optional.of((Object)((Measurement)Iterables.getOnlyElement((Iterable)logMessage.measurements())));
        }

        @Override
        public ImmutableList<String> getMessages() {
            return ImmutableList.of();
        }
    }

    private final class ArbitraryMeasurementInstrumentedMethod
    extends Instrument.InstrumentedMethod {
        protected ArbitraryMeasurementInstrumentedMethod(BenchmarkClassModel.MethodModel benchmarkMethod) {
            super(ArbitraryMeasurementInstrument.this, benchmarkMethod);
        }

        @Override
        public InstrumentType type() {
            return InstrumentType.ARBITRARY_MEASUREMENT;
        }

        @Override
        public ImmutableMap<String, String> workerOptions() {
            return ImmutableMap.of((Object)"gcBeforeEach", (Object)((String)ArbitraryMeasurementInstrument.this.options.get((Object)"gcBeforeEach")));
        }

        @Override
        public MeasurementCollectingVisitor getMeasurementCollectingVisitor() {
            return new SingleMeasurementCollectingVisitor();
        }
    }
}

