/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner.worker.targetinfo;

import com.google.caliper.bridge.TargetInfoRequest;
import com.google.caliper.bridge.WorkerRequest;
import com.google.caliper.runner.options.CaliperOptions;
import com.google.caliper.runner.server.LocalPort;
import com.google.caliper.runner.target.Target;
import com.google.caliper.runner.worker.WorkerScoped;
import com.google.caliper.runner.worker.WorkerSpec;
import java.io.PrintWriter;
import java.util.UUID;
import javax.inject.Inject;

@WorkerScoped
final class TargetInfoSpec
extends WorkerSpec {
    private final Target target;
    private final CaliperOptions options;

    @Inject
    TargetInfoSpec(Target target, UUID id, @LocalPort int port, CaliperOptions options) {
        super(target, id, id, port, options.benchmarkClassName());
        this.target = target;
        this.options = options;
    }

    @Override
    public String name() {
        String string = String.valueOf(this.target.name());
        return string.length() != 0 ? "target-info-".concat(string) : new String("target-info-");
    }

    @Override
    public WorkerRequest request() {
        return TargetInfoRequest.create(this.options.userParameters());
    }

    @Override
    public void printInfoHeader(PrintWriter writer) {
        String string = String.valueOf(this.id());
        writer.println(new StringBuilder(11 + String.valueOf(string).length()).append("Worker Id: ").append(string).toString());
        String string2 = String.valueOf(this.options.benchmarkClassName());
        writer.println(string2.length() != 0 ? "Benchmark Class Name: ".concat(string2) : new String("Benchmark Class Name: "));
    }
}

