/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.alloydb;

import com.google.auth.oauth2.GoogleCredentials;
import com.google.common.base.Objects;
import java.util.List;
import java.util.function.Supplier;

public class ConnectorConfig {
    private final String targetPrincipal;
    private final List<String> delegates;
    private final String adminServiceEndpoint;
    private final Supplier<GoogleCredentials> googleCredentialsSupplier;
    private final GoogleCredentials googleCredentials;
    private final String googleCredentialsPath;
    private final String quotaProject;

    private ConnectorConfig(String targetPrincipal, List<String> delegates, String adminServiceEndpoint, Supplier<GoogleCredentials> googleCredentialsSupplier, GoogleCredentials googleCredentials, String googleCredentialsPath, String quotaProject) {
        this.targetPrincipal = targetPrincipal;
        this.delegates = delegates;
        this.adminServiceEndpoint = adminServiceEndpoint;
        this.googleCredentialsSupplier = googleCredentialsSupplier;
        this.googleCredentials = googleCredentials;
        this.googleCredentialsPath = googleCredentialsPath;
        this.quotaProject = quotaProject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConnectorConfig)) {
            return false;
        }
        ConnectorConfig that = (ConnectorConfig)o;
        return Objects.equal((Object)this.targetPrincipal, (Object)that.targetPrincipal) && Objects.equal(this.delegates, that.delegates) && Objects.equal((Object)this.adminServiceEndpoint, (Object)that.adminServiceEndpoint) && Objects.equal(this.googleCredentialsSupplier, that.googleCredentialsSupplier) && Objects.equal((Object)this.googleCredentials, (Object)that.googleCredentials) && Objects.equal((Object)this.googleCredentialsPath, (Object)that.googleCredentialsPath) && Objects.equal((Object)this.quotaProject, (Object)that.quotaProject);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.targetPrincipal, this.delegates, this.adminServiceEndpoint, this.googleCredentialsSupplier, this.googleCredentials, this.googleCredentialsPath, this.quotaProject});
    }

    public String getTargetPrincipal() {
        return this.targetPrincipal;
    }

    public List<String> getDelegates() {
        return this.delegates;
    }

    public String getAdminServiceEndpoint() {
        return this.adminServiceEndpoint;
    }

    public Supplier<GoogleCredentials> getGoogleCredentialsSupplier() {
        return this.googleCredentialsSupplier;
    }

    public GoogleCredentials getGoogleCredentials() {
        return this.googleCredentials;
    }

    public String getGoogleCredentialsPath() {
        return this.googleCredentialsPath;
    }

    public String getQuotaProject() {
        return this.quotaProject;
    }

    public static class Builder {
        private String targetPrincipal;
        private List<String> delegates;
        private String adminServiceEndpoint;
        private Supplier<GoogleCredentials> googleCredentialsSupplier;
        private GoogleCredentials googleCredentials;
        private String googleCredentialsPath;
        private String quotaProject;

        public Builder withTargetPrincipal(String targetPrincipal) {
            this.targetPrincipal = targetPrincipal;
            return this;
        }

        public Builder withDelegates(List<String> delegates) {
            this.delegates = delegates;
            return this;
        }

        public Builder withAdminServiceEndpoint(String adminServiceEndpoint) {
            this.adminServiceEndpoint = adminServiceEndpoint;
            return this;
        }

        public Builder withGoogleCredentialsSupplier(Supplier<GoogleCredentials> googleCredentialsSupplier) {
            this.googleCredentialsSupplier = googleCredentialsSupplier;
            return this;
        }

        public Builder withGoogleCredentials(GoogleCredentials googleCredentials) {
            this.googleCredentials = googleCredentials;
            return this;
        }

        public Builder withGoogleCredentialsPath(String googleCredentialsPath) {
            this.googleCredentialsPath = googleCredentialsPath;
            return this;
        }

        public Builder withQuotaProject(String quotaProject) {
            this.quotaProject = quotaProject;
            return this;
        }

        public ConnectorConfig build() {
            int googleCredsCount = 0;
            if (this.googleCredentials != null) {
                ++googleCredsCount;
            }
            if (this.googleCredentialsPath != null) {
                ++googleCredsCount;
            }
            if (this.googleCredentialsSupplier != null) {
                ++googleCredsCount;
            }
            if (googleCredsCount > 1) {
                throw new IllegalStateException("Invalid configuration, more than one GoogleCredentials field has a value (googleCredentials, googleCredentialsPath, googleCredentialsSupplier)");
            }
            return new ConnectorConfig(this.targetPrincipal, this.delegates, this.adminServiceEndpoint, this.googleCredentialsSupplier, this.googleCredentials, this.googleCredentialsPath, this.quotaProject);
        }
    }
}

