/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.alloydb;

import com.google.cloud.alloydb.ConnectionInfoRepository;
import com.google.cloud.alloydb.TerminalException;
import com.google.cloud.alloydb.v1alpha.AlloyDBAdminClient;
import com.google.cloud.alloydb.v1alpha.ClusterName;
import com.google.cloud.alloydb.v1alpha.ConnectionInfo;
import com.google.cloud.alloydb.v1alpha.GenerateClientCertificateRequest;
import com.google.cloud.alloydb.v1alpha.GenerateClientCertificateResponse;
import com.google.cloud.alloydb.v1alpha.InstanceName;
import com.google.common.io.BaseEncoding;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.protobuf.ByteString;
import com.google.protobuf.Duration;
import io.grpc.Status;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.security.KeyPair;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;

class DefaultConnectionInfoRepository
implements ConnectionInfoRepository,
Closeable {
    private static final String OPENSSL_PUBLIC_KEY_BEGIN = "-----BEGIN RSA PUBLIC KEY-----";
    private static final String OPENSSL_PUBLIC_KEY_END = "-----END RSA PUBLIC KEY-----";
    private static final String X_509 = "X.509";
    private static final int PEM_LINE_LENGTH = 64;
    private static final List<Status.Code> TERMINAL_STATUS_CODES = Arrays.asList(Status.Code.NOT_FOUND, Status.Code.PERMISSION_DENIED, Status.Code.INVALID_ARGUMENT);
    private final ListeningScheduledExecutorService executor;
    private final AlloyDBAdminClient alloyDBAdminClient;

    DefaultConnectionInfoRepository(ListeningScheduledExecutorService executor, AlloyDBAdminClient alloyDBAdminClient) {
        this.executor = executor;
        this.alloyDBAdminClient = alloyDBAdminClient;
    }

    @Override
    public ListenableFuture<com.google.cloud.alloydb.ConnectionInfo> getConnectionInfo(InstanceName instanceName, KeyPair keyPair) {
        ListenableFuture infoFuture = this.executor.submit(() -> this.getConnectionInfo(instanceName));
        ListenableFuture clientCertificateResponseFuture = this.executor.submit(() -> this.getGenerateClientCertificateResponse(instanceName, keyPair));
        return Futures.whenAllComplete((ListenableFuture[])new ListenableFuture[]{infoFuture, clientCertificateResponseFuture}).call(() -> {
            ConnectionInfo info = (ConnectionInfo)Futures.getDone((Future)infoFuture);
            GenerateClientCertificateResponse certificateResponse = (GenerateClientCertificateResponse)Futures.getDone((Future)clientCertificateResponseFuture);
            List certificateChainBytes = certificateResponse.getPemCertificateChainList().asByteStringList();
            ArrayList<X509Certificate> certificateChain = new ArrayList<X509Certificate>();
            for (ByteString certificateChainByte : certificateChainBytes) {
                certificateChain.add(this.parseCertificate(certificateChainByte));
            }
            X509Certificate clientCertificate = (X509Certificate)certificateChain.get(0);
            ByteString caCertificateBytes = certificateResponse.getCaCertBytes();
            X509Certificate caCertificate = this.parseCertificate(caCertificateBytes);
            return new com.google.cloud.alloydb.ConnectionInfo(info.getIpAddress(), info.getPublicIpAddress(), info.getPscDnsName(), info.getInstanceUid(), clientCertificate, certificateChain, caCertificate);
        }, (Executor)this.executor);
    }

    @Override
    public void close() {
        this.alloyDBAdminClient.close();
    }

    private ConnectionInfo getConnectionInfo(InstanceName instanceName) {
        try {
            return this.alloyDBAdminClient.getConnectionInfo(instanceName);
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    private GenerateClientCertificateResponse getGenerateClientCertificateResponse(InstanceName instanceName, KeyPair keyPair) {
        GenerateClientCertificateRequest request = GenerateClientCertificateRequest.newBuilder().setParent(this.getParent(instanceName)).setCertDuration(Duration.newBuilder().setSeconds(3600L)).setPublicKey(this.generatePublicKeyCert(keyPair)).setUseMetadataExchange(true).build();
        try {
            return this.alloyDBAdminClient.generateClientCertificate(request);
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    private RuntimeException handleException(Exception e) {
        Status status = Status.fromThrowable((Throwable)e);
        String message = String.format("AlloyDB Admin API failed to return the connection info. Reason: %s", e.getMessage());
        if (TERMINAL_STATUS_CODES.contains(status.getCode())) {
            return new TerminalException(message, e);
        }
        return new RuntimeException(message, e);
    }

    private String getParent(InstanceName instanceName) {
        return ClusterName.of((String)instanceName.getProject(), (String)instanceName.getLocation(), (String)instanceName.getCluster()).toString();
    }

    private String generatePublicKeyCert(KeyPair keyPair) {
        StringBuilder sb = new StringBuilder();
        sb.append(OPENSSL_PUBLIC_KEY_BEGIN).append("\n");
        String base64Key = BaseEncoding.base64().withSeparator("\n", 64).encode(keyPair.getPublic().getEncoded());
        sb.append(base64Key).append("\n");
        sb.append(OPENSSL_PUBLIC_KEY_END).append("\n");
        return sb.toString();
    }

    private X509Certificate parseCertificate(ByteString cert) throws CertificateException {
        ByteArrayInputStream certStream = new ByteArrayInputStream(cert.toByteArray());
        CertificateFactory x509CertificateFactory = CertificateFactory.getInstance(X_509);
        return (X509Certificate)x509CertificateFactory.generateCertificate(certStream);
    }
}

