/*
 * Decompiled with CFR 0.152.
 */
package com.google.datastore.v1.client;

import com.google.api.client.http.HttpResponse;
import com.google.common.io.BaseEncoding;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

class EndToEndChecksumHandler {
    static final String HTTP_REQUEST_CHECKSUM_HEADER = "x-request-checksum-348659783";
    static final String HTTP_RESPONSE_CHECKSUM_HEADER = "x-response-checksum-348659783";
    private static final String MD5 = "MD5";

    EndToEndChecksumHandler() {
    }

    static String computeChecksum(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        return BaseEncoding.base16().encode(EndToEndChecksumHandler.getMessageDigestInstance().digest(bytes));
    }

    static boolean validateChecksum(String checksum, byte[] bytes) {
        return checksum != null && !checksum.isEmpty() && bytes != null && bytes.length > 0 && checksum.equalsIgnoreCase(EndToEndChecksumHandler.computeChecksum(bytes));
    }

    static MessageDigest getMessageDigestInstance() {
        try {
            return MessageDigest.getInstance(MD5);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("MD5 algorithm is not found when computing checksum!");
        }
    }

    static boolean hasChecksumHeader(HttpResponse response) {
        String checksum = EndToEndChecksumHandler.getChecksumHeader(response);
        return checksum != null && !checksum.isEmpty();
    }

    static String getChecksumHeader(HttpResponse response) {
        return response.getHeaders().getFirstHeaderStringValue(HTTP_RESPONSE_CHECKSUM_HEADER);
    }
}

