/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.models;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.bigtable.v2.Mutation;
import com.google.cloud.bigtable.data.v2.models.MutationApi;
import com.google.cloud.bigtable.data.v2.models.Range;
import com.google.cloud.bigtable.data.v2.models.Validations;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Nonnull;

public final class Mutation
implements MutationApi<Mutation>,
Serializable {
    private static final long serialVersionUID = 5893216644683374340L;
    @InternalApi(value="Visible for testing")
    static final int MAX_MUTATIONS = 100000;
    @InternalApi(value="Visible for testing")
    static final int MAX_BYTE_SIZE = 0xC800000;
    @InternalApi(value="Visible for testing")
    static final long SERVER_SIDE_TIMESTAMP = -1L;
    private final boolean allowServersideTimestamp;
    private transient ImmutableList.Builder<com.google.bigtable.v2.Mutation> mutations = ImmutableList.builder();
    private int numMutations;
    private long byteSize;

    public static Mutation create() {
        return new Mutation(false);
    }

    @BetaApi
    public static Mutation createUnsafe() {
        return new Mutation(true);
    }

    private Mutation(boolean allowServersideTimestamp) {
        this.allowServersideTimestamp = allowServersideTimestamp;
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        ImmutableList deserialized = (ImmutableList)input.readObject();
        this.mutations = ImmutableList.builder().addAll((Iterable)deserialized);
    }

    private void writeObject(ObjectOutputStream output) throws IOException {
        output.defaultWriteObject();
        output.writeObject(this.mutations.build());
    }

    @Override
    public Mutation setCell(@Nonnull String familyName, @Nonnull String qualifier, @Nonnull String value) {
        return this.setCell(familyName, Mutation.wrapByteString(qualifier), Mutation.wrapByteString(value));
    }

    @Override
    public Mutation setCell(@Nonnull String familyName, @Nonnull String qualifier, long timestamp, @Nonnull String value) {
        return this.setCell(familyName, Mutation.wrapByteString(qualifier), timestamp, Mutation.wrapByteString(value));
    }

    @Override
    public Mutation setCell(@Nonnull String familyName, @Nonnull ByteString qualifier, @Nonnull ByteString value) {
        long timestamp = System.currentTimeMillis() * 1000L;
        return this.setCell(familyName, qualifier, timestamp, value);
    }

    @Override
    public Mutation setCell(@Nonnull String familyName, @Nonnull ByteString qualifier, long timestamp, @Nonnull ByteString value) {
        Validations.validateFamily(familyName);
        Preconditions.checkNotNull((Object)qualifier, (Object)"qualifier can't be null.");
        Preconditions.checkNotNull((Object)value, (Object)"value can't be null.");
        if (!this.allowServersideTimestamp) {
            Preconditions.checkArgument((timestamp != -1L ? 1 : 0) != 0, (Object)"Serverside timestamps are not supported");
        }
        this.addMutation(com.google.bigtable.v2.Mutation.newBuilder().setSetCell(Mutation.SetCell.newBuilder().setFamilyName(familyName).setColumnQualifier(qualifier).setTimestampMicros(timestamp).setValue(value).build()).build());
        return this;
    }

    @Override
    public Mutation deleteCells(@Nonnull String familyName, @Nonnull String qualifier) {
        return this.deleteCells(familyName, Mutation.wrapByteString(qualifier));
    }

    @Override
    public Mutation deleteCells(@Nonnull String familyName, @Nonnull ByteString qualifier) {
        Validations.validateFamily(familyName);
        Preconditions.checkNotNull((Object)qualifier, (Object)"qualifier can't be null.");
        return this.deleteCells(familyName, qualifier, Range.TimestampRange.unbounded());
    }

    @Override
    public Mutation deleteCells(@Nonnull String familyName, @Nonnull ByteString qualifier, @Nonnull Range.TimestampRange timestampRange) {
        Validations.validateFamily(familyName);
        Preconditions.checkNotNull((Object)qualifier, (Object)"qualifier can't be null.");
        Preconditions.checkNotNull((Object)timestampRange, (Object)"timestampRange can't be null.");
        Mutation.DeleteFromColumn.Builder builder = Mutation.DeleteFromColumn.newBuilder().setFamilyName(familyName).setColumnQualifier(qualifier);
        switch (timestampRange.getStartBound()) {
            case CLOSED: {
                builder.getTimeRangeBuilder().setStartTimestampMicros(((Long)timestampRange.getStart()).longValue());
                break;
            }
            case OPEN: {
                builder.getTimeRangeBuilder().setStartTimestampMicros((Long)timestampRange.getStart() + 1L);
                break;
            }
            case UNBOUNDED: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown start bound: " + (Object)((Object)timestampRange.getStartBound()));
            }
        }
        switch (timestampRange.getEndBound()) {
            case CLOSED: {
                builder.getTimeRangeBuilder().setEndTimestampMicros((Long)timestampRange.getEnd() + 1L);
                break;
            }
            case OPEN: {
                builder.getTimeRangeBuilder().setEndTimestampMicros(((Long)timestampRange.getEnd()).longValue());
                break;
            }
            case UNBOUNDED: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown end bound: " + (Object)((Object)timestampRange.getEndBound()));
            }
        }
        this.addMutation(com.google.bigtable.v2.Mutation.newBuilder().setDeleteFromColumn(builder.build()).build());
        return this;
    }

    @Override
    public Mutation deleteFamily(@Nonnull String familyName) {
        Validations.validateFamily(familyName);
        this.addMutation(com.google.bigtable.v2.Mutation.newBuilder().setDeleteFromFamily(Mutation.DeleteFromFamily.newBuilder().setFamilyName(familyName).build()).build());
        return this;
    }

    @Override
    public Mutation deleteRow() {
        this.addMutation(com.google.bigtable.v2.Mutation.newBuilder().setDeleteFromRow(Mutation.DeleteFromRow.getDefaultInstance()).build());
        return this;
    }

    private void addMutation(com.google.bigtable.v2.Mutation mutation) {
        Preconditions.checkState((this.numMutations + 1 <= 100000 ? 1 : 0) != 0, (Object)"Too many mutations per row");
        Preconditions.checkState((this.byteSize + (long)mutation.getSerializedSize() <= 0xC800000L ? 1 : 0) != 0, (Object)"Byte size of mutations is too large");
        ++this.numMutations;
        this.byteSize += (long)mutation.getSerializedSize();
        this.mutations.add((Object)mutation);
    }

    private static ByteString wrapByteString(String str) {
        if (str == null) {
            return null;
        }
        return ByteString.copyFromUtf8((String)str);
    }

    List<com.google.bigtable.v2.Mutation> getMutations() {
        return this.mutations.build();
    }
}

