/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import io.opencensus.trace.EndSpanOptions;
import io.opencensus.trace.Span;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.Tracing;

public class TraceUtil {
    private final Tracer tracer = Tracing.getTracer();
    private static final TraceUtil traceUtil = new TraceUtil();
    static final String SPAN_NAME_ALLOCATEIDS = "CloudDatastoreOperation.allocateIds";
    static final String SPAN_NAME_TRANSACTION = "CloudDatastoreOperation.readWriteTransaction";
    static final String SPAN_NAME_BEGINTRANSACTION = "CloudDatastoreOperation.beginTransaction";
    static final String SPAN_NAME_COMMIT = "CloudDatastoreOperation.commit";
    static final String SPAN_NAME_LOOKUP = "CloudDatastoreOperation.lookup";
    static final String SPAN_NAME_RESERVEIDS = "CloudDatastoreOperation.reserveIds";
    static final String SPAN_NAME_ROLLBACK = "CloudDatastoreOperation.rollback";
    static final String SPAN_NAME_RUNQUERY = "CloudDatastoreOperation.runQuery";
    static final String SPAN_NAME_RUN_AGGREGATION_QUERY = "CloudDatastoreOperation.runAggregationQuery";
    static final EndSpanOptions END_SPAN_OPTIONS = EndSpanOptions.builder().setSampleToLocalSpanStore(true).build();

    protected Span startSpan(String spanName) {
        return this.tracer.spanBuilder(spanName).startSpan();
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    public static TraceUtil getInstance() {
        return traceUtil;
    }

    private TraceUtil() {
    }
}

