/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.api.core.ObsoleteApi;
import com.google.cloud.datastore.Value;
import com.google.common.base.MoreObjects;
import java.util.Map;
import java.util.Objects;

public class AggregationResult {
    private final Map<String, ? extends Value<?>> properties;

    public AggregationResult(Map<String, ? extends Value<?>> properties) {
        this.properties = properties;
    }

    @ObsoleteApi(value="Please use getLong(String) instead, see Github issue #1175 for details.")
    public Long get(String alias) {
        return this.getLong(alias);
    }

    public Long getLong(String alias) {
        Value<?> value = this.properties.get(alias);
        switch (value.getType()) {
            case DOUBLE: {
                return ((Double)value.get()).longValue();
            }
            case LONG: {
                return (Long)value.get();
            }
        }
        throw new RuntimeException(String.format("Unsupported type %s received for alias '%s'.", new Object[]{value.getType(), alias}));
    }

    public Double getDouble(String alias) {
        Value<?> value = this.properties.get(alias);
        switch (value.getType()) {
            case LONG: {
                return ((Long)value.get()).doubleValue();
            }
            case DOUBLE: {
                return (Double)value.get();
            }
        }
        throw new RuntimeException(String.format("Unsupported type %s received for alias '%s'.", new Object[]{value.getType(), alias}));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregationResult that = (AggregationResult)o;
        return this.properties.equals(that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.properties);
    }

    public String toString() {
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper((Object)this);
        for (Map.Entry<String, Value<?>> entry : this.properties.entrySet()) {
            toStringHelper.add(entry.getKey(), entry.getValue().get());
        }
        return toStringHelper.toString();
    }
}

