/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.models;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.cloud.Structs;
import com.google.common.base.Objects;
import com.google.protobuf.Struct;
import java.util.Map;
import org.threeten.bp.Duration;

@BetaApi
public class ExecutionStats {
    private final long resultsReturned;
    private final Duration executionDuration;
    private final long readOperations;
    private final Map<String, Object> debugStats;

    @InternalApi
    public ExecutionStats(com.google.datastore.v1.ExecutionStats proto) {
        this.resultsReturned = proto.getResultsReturned();
        this.executionDuration = Duration.ofNanos((long)proto.getExecutionDuration().getNanos());
        this.readOperations = proto.getReadOperations();
        this.debugStats = Structs.asMap((Struct)proto.getDebugStats());
    }

    public long getResultsReturned() {
        return this.resultsReturned;
    }

    public Map<String, Object> getDebugStats() {
        return this.debugStats;
    }

    public Duration getExecutionDuration() {
        return this.executionDuration;
    }

    public long getReadOperations() {
        return this.readOperations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExecutionStats)) {
            return false;
        }
        ExecutionStats that = (ExecutionStats)o;
        return Objects.equal((Object)this.resultsReturned, (Object)that.resultsReturned) && Objects.equal((Object)this.executionDuration, (Object)that.executionDuration) && Objects.equal((Object)this.readOperations, (Object)that.readOperations) && Objects.equal(this.debugStats, that.debugStats);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.resultsReturned, this.executionDuration, this.readOperations, this.debugStats});
    }
}

