/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging.spi.v2;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.grpc.ApiException;
import com.google.api.gax.grpc.ChannelProvider;
import com.google.api.gax.grpc.ExecutorProvider;
import com.google.api.gax.grpc.FixedChannelProvider;
import com.google.api.gax.grpc.FixedExecutorProvider;
import com.google.api.gax.grpc.InstantiatingChannelProvider;
import com.google.api.gax.grpc.ProviderManager;
import com.google.api.gax.grpc.UnaryCallSettings;
import com.google.cloud.NoCredentials;
import com.google.cloud.ServiceOptions;
import com.google.cloud.grpc.GrpcTransportOptions;
import com.google.cloud.logging.LoggingException;
import com.google.cloud.logging.LoggingOptions;
import com.google.cloud.logging.spi.v2.ConfigClient;
import com.google.cloud.logging.spi.v2.ConfigSettings;
import com.google.cloud.logging.spi.v2.LoggingClient;
import com.google.cloud.logging.spi.v2.LoggingRpc;
import com.google.cloud.logging.spi.v2.LoggingSettings;
import com.google.cloud.logging.spi.v2.MetricsClient;
import com.google.cloud.logging.spi.v2.MetricsSettings;
import com.google.logging.v2.CreateLogMetricRequest;
import com.google.logging.v2.CreateSinkRequest;
import com.google.logging.v2.DeleteLogMetricRequest;
import com.google.logging.v2.DeleteLogRequest;
import com.google.logging.v2.DeleteSinkRequest;
import com.google.logging.v2.GetLogMetricRequest;
import com.google.logging.v2.GetSinkRequest;
import com.google.logging.v2.ListLogEntriesRequest;
import com.google.logging.v2.ListLogEntriesResponse;
import com.google.logging.v2.ListLogMetricsRequest;
import com.google.logging.v2.ListLogMetricsResponse;
import com.google.logging.v2.ListMonitoredResourceDescriptorsRequest;
import com.google.logging.v2.ListMonitoredResourceDescriptorsResponse;
import com.google.logging.v2.ListSinksRequest;
import com.google.logging.v2.ListSinksResponse;
import com.google.logging.v2.LogMetric;
import com.google.logging.v2.LogSink;
import com.google.logging.v2.UpdateLogMetricRequest;
import com.google.logging.v2.UpdateSinkRequest;
import com.google.logging.v2.WriteLogEntriesRequest;
import com.google.logging.v2.WriteLogEntriesResponse;
import com.google.protobuf.Empty;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Status;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;

public class GrpcLoggingRpc
implements LoggingRpc {
    private final ConfigClient configClient;
    private final LoggingClient loggingClient;
    private final MetricsClient metricsClient;
    private final ScheduledExecutorService executor;
    private final ProviderManager providerManager;
    private final GrpcTransportOptions.ExecutorFactory<ScheduledExecutorService> executorFactory;
    private boolean closed;

    public GrpcLoggingRpc(LoggingOptions options) throws IOException {
        GrpcTransportOptions transportOptions = (GrpcTransportOptions)options.getTransportOptions();
        this.executorFactory = transportOptions.getExecutorFactory();
        this.executor = (ScheduledExecutorService)this.executorFactory.get();
        try {
            ChannelProvider channelProvider;
            FixedExecutorProvider executorProvider = FixedExecutorProvider.create((ScheduledExecutorService)this.executor);
            if (options.getHost().contains("localhost") || NoCredentials.getInstance().equals((Object)options.getCredentials())) {
                ManagedChannel managedChannel = ManagedChannelBuilder.forTarget((String)options.getHost()).usePlaintext(true).executor((Executor)this.executor).build();
                channelProvider = FixedChannelProvider.create((ManagedChannel)managedChannel);
            } else {
                channelProvider = GrpcTransportOptions.setUpChannelProvider((InstantiatingChannelProvider.Builder)LoggingSettings.defaultChannelProviderBuilder(), (ServiceOptions)options);
            }
            this.providerManager = ProviderManager.newBuilder().setChannelProvider(channelProvider).setExecutorProvider((ExecutorProvider)executorProvider).build();
            UnaryCallSettings.Builder callSettingsBuilder = transportOptions.getApiCallSettings(options.getRetrySettings());
            ConfigSettings.Builder confBuilder = ConfigSettings.defaultBuilder().setExecutorProvider((ExecutorProvider)this.providerManager).setChannelProvider((ChannelProvider)this.providerManager).applyToAllUnaryMethods(callSettingsBuilder);
            LoggingSettings.Builder logBuilder = LoggingSettings.defaultBuilder().setExecutorProvider((ExecutorProvider)this.providerManager).setChannelProvider((ChannelProvider)this.providerManager).applyToAllUnaryMethods(callSettingsBuilder);
            MetricsSettings.Builder metricsBuilder = MetricsSettings.defaultBuilder().setExecutorProvider((ExecutorProvider)this.providerManager).setChannelProvider((ChannelProvider)this.providerManager).applyToAllUnaryMethods(callSettingsBuilder);
            this.configClient = ConfigClient.create(confBuilder.build());
            this.loggingClient = LoggingClient.create(logBuilder.build());
            this.metricsClient = MetricsClient.create(metricsBuilder.build());
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    private static <V> ApiFuture<V> translate(ApiFuture<V> from, boolean idempotent, Status.Code ... returnNullOn) {
        final Set<Object> returnNullOnSet = returnNullOn.length > 0 ? EnumSet.of(returnNullOn[0], returnNullOn) : Collections.emptySet();
        return ApiFutures.catching(from, ApiException.class, (ApiFunction)new ApiFunction<ApiException, V>(){

            public V apply(ApiException exception) {
                if (returnNullOnSet.contains(exception.getStatusCode())) {
                    return null;
                }
                throw new LoggingException(exception);
            }
        });
    }

    @Override
    public ApiFuture<LogSink> create(CreateSinkRequest request) {
        return GrpcLoggingRpc.translate(this.configClient.createSinkCallable().futureCall((Object)request), true, new Status.Code[0]);
    }

    @Override
    public ApiFuture<LogSink> update(UpdateSinkRequest request) {
        return GrpcLoggingRpc.translate(this.configClient.updateSinkCallable().futureCall((Object)request), true, new Status.Code[0]);
    }

    @Override
    public ApiFuture<LogSink> get(GetSinkRequest request) {
        return GrpcLoggingRpc.translate(this.configClient.getSinkCallable().futureCall((Object)request), true, Status.Code.NOT_FOUND);
    }

    @Override
    public ApiFuture<ListSinksResponse> list(ListSinksRequest request) {
        return GrpcLoggingRpc.translate(this.configClient.listSinksCallable().futureCall((Object)request), true, new Status.Code[0]);
    }

    @Override
    public ApiFuture<Empty> delete(DeleteSinkRequest request) {
        return GrpcLoggingRpc.translate(this.configClient.deleteSinkCallable().futureCall((Object)request), true, Status.Code.NOT_FOUND);
    }

    @Override
    public ApiFuture<Empty> delete(DeleteLogRequest request) {
        return GrpcLoggingRpc.translate(this.loggingClient.deleteLogCallable().futureCall((Object)request), true, Status.Code.NOT_FOUND);
    }

    @Override
    public ApiFuture<WriteLogEntriesResponse> write(WriteLogEntriesRequest request) {
        return GrpcLoggingRpc.translate(this.loggingClient.writeLogEntriesCallable().futureCall((Object)request), false, new Status.Code[0]);
    }

    @Override
    public ApiFuture<ListLogEntriesResponse> list(ListLogEntriesRequest request) {
        return GrpcLoggingRpc.translate(this.loggingClient.listLogEntriesCallable().futureCall((Object)request), true, new Status.Code[0]);
    }

    @Override
    public ApiFuture<ListMonitoredResourceDescriptorsResponse> list(ListMonitoredResourceDescriptorsRequest request) {
        return GrpcLoggingRpc.translate(this.loggingClient.listMonitoredResourceDescriptorsCallable().futureCall((Object)request), true, new Status.Code[0]);
    }

    @Override
    public ApiFuture<LogMetric> create(CreateLogMetricRequest request) {
        return GrpcLoggingRpc.translate(this.metricsClient.createLogMetricCallable().futureCall((Object)request), true, new Status.Code[0]);
    }

    @Override
    public ApiFuture<LogMetric> update(UpdateLogMetricRequest request) {
        return GrpcLoggingRpc.translate(this.metricsClient.updateLogMetricCallable().futureCall((Object)request), true, new Status.Code[0]);
    }

    @Override
    public ApiFuture<LogMetric> get(GetLogMetricRequest request) {
        return GrpcLoggingRpc.translate(this.metricsClient.getLogMetricCallable().futureCall((Object)request), true, Status.Code.NOT_FOUND);
    }

    @Override
    public ApiFuture<ListLogMetricsResponse> list(ListLogMetricsRequest request) {
        return GrpcLoggingRpc.translate(this.metricsClient.listLogMetricsCallable().futureCall((Object)request), true, new Status.Code[0]);
    }

    @Override
    public ApiFuture<Empty> delete(DeleteLogMetricRequest request) {
        return GrpcLoggingRpc.translate(this.metricsClient.deleteLogMetricCallable().futureCall((Object)request), true, Status.Code.NOT_FOUND);
    }

    @Override
    public void close() throws Exception {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.configClient.close();
        this.loggingClient.close();
        this.metricsClient.close();
        this.providerManager.getChannel().shutdown();
        this.executorFactory.release((ExecutorService)this.executor);
    }
}

