/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging;

import com.google.cloud.logging.MonitoredResourceUtil;
import com.google.cloud.logging.ResourceTypeEnvironmentGetter;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.function.Supplier;

public final class MetadataLoader {
    public static final String ENV_FLEXIBLE = "flex";
    public static final String ENV_STANDARD = "standard";
    private final ResourceTypeEnvironmentGetter getter;
    private final ImmutableMap<MonitoredResourceUtil.Label, Supplier<String>> labelResolvers = ImmutableMap.builder().put((Object)MonitoredResourceUtil.Label.ClusterName, this::getClusterName).put((Object)MonitoredResourceUtil.Label.ConfigurationName, this::getConfigName).put((Object)MonitoredResourceUtil.Label.ContainerName, this::getContainerName).put((Object)MonitoredResourceUtil.Label.Env, this::getEnv).put((Object)MonitoredResourceUtil.Label.FunctionName, this::getFunctionName).put((Object)MonitoredResourceUtil.Label.InstanceId, this::getInstanceId).put((Object)MonitoredResourceUtil.Label.InstanceName, this::getInstanceName).put((Object)MonitoredResourceUtil.Label.CloudRunLocation, this::getCloudRunLocation).put((Object)MonitoredResourceUtil.Label.GKELocation, this::getGKELocation).put((Object)MonitoredResourceUtil.Label.ModuleId, this::getModuleId).put((Object)MonitoredResourceUtil.Label.NamespaceName, this::getNamespaceName).put((Object)MonitoredResourceUtil.Label.PodName, this::getPodName).put((Object)MonitoredResourceUtil.Label.ProjectId, this::getProjectId).put((Object)MonitoredResourceUtil.Label.Region, this::getRegion).put((Object)MonitoredResourceUtil.Label.RevisionName, this::getRevisionName).put((Object)MonitoredResourceUtil.Label.ServiceName, this::getServiceName).put((Object)MonitoredResourceUtil.Label.VersionId, this::getVersionId).put((Object)MonitoredResourceUtil.Label.Zone, this::getZone).buildOrThrow();

    public MetadataLoader(ResourceTypeEnvironmentGetter getter) {
        this.getter = getter;
    }

    public String getValue(MonitoredResourceUtil.Label label) {
        Supplier lambda = (Supplier)this.labelResolvers.get((Object)label);
        if (lambda != null) {
            return (String)lambda.get();
        }
        return null;
    }

    private String getClusterName() {
        return this.getter.getAttribute("instance/attributes/cluster-name");
    }

    private String getConfigName() {
        return this.getter.getEnv("K_CONFIGURATION");
    }

    private String getContainerName() {
        return this.getter.getEnv("CONTAINER_NAME");
    }

    private String getEnv() {
        String value = this.getter.getAttribute("instance/attributes/startup-script");
        if ("/var/lib/flex/startup_script.sh".equals(value)) {
            return ENV_FLEXIBLE;
        }
        return ENV_STANDARD;
    }

    private String getFunctionName() {
        String value = this.getter.getEnv("K_SERVICE");
        if (value == null) {
            value = this.getter.getEnv("FUNCTION_NAME");
        }
        return value;
    }

    private String getInstanceId() {
        return this.getter.getAttribute("instance/id");
    }

    private String getInstanceName() {
        return this.getter.getAttribute("instance/name");
    }

    private String getCloudRunLocation() {
        return this.getRegion();
    }

    private String getGKELocation() {
        return this.getZone();
    }

    private String getModuleId() {
        return this.getter.getEnv("GAE_SERVICE");
    }

    private String getNamespaceName() {
        String value = null;
        try {
            value = new String(Files.readAllBytes(Paths.get("/var/run/secrets/kubernetes.io/serviceaccount/namespace", new String[0])), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            value = this.getter.getEnv("NAMESPACE_NAME");
        }
        return value;
    }

    private String getPodName() {
        String value = this.getter.getEnv("POD_NAME");
        if (value != null) {
            return value;
        }
        return this.getter.getEnv("HOSTNAME");
    }

    private String getProjectId() {
        return this.getter.getAttribute("project/project-id");
    }

    private String getRegion() {
        String loc = this.getter.getAttribute("instance/region");
        if (loc != null) {
            return loc.substring(loc.lastIndexOf(47) + 1);
        }
        return null;
    }

    private String getRevisionName() {
        return this.getter.getEnv("K_REVISION");
    }

    private String getServiceName() {
        return this.getter.getEnv("K_SERVICE");
    }

    private String getVersionId() {
        return this.getter.getEnv("GAE_VERSION");
    }

    private String getZone() {
        String loc = this.getter.getAttribute("instance/zone");
        if (loc != null) {
            return loc.substring(loc.lastIndexOf(47) + 1);
        }
        return null;
    }
}

