/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging;

import com.google.api.client.util.Strings;
import com.google.api.gax.core.GaxProperties;
import com.google.cloud.Tuple;
import com.google.cloud.logging.LogEntry;
import com.google.cloud.logging.Logging;
import com.google.cloud.logging.Payload;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.protobuf.ListValue;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

public final class Instrumentation {
    public static final String DIAGNOSTIC_INFO_KEY = "logging.googleapis.com/diagnostic";
    public static final String INSTRUMENTATION_SOURCE_KEY = "instrumentation_source";
    public static final String INSTRUMENTATION_NAME_KEY = "name";
    public static final String INSTRUMENTATION_VERSION_KEY = "version";
    public static final String JAVA_LIBRARY_NAME_PREFIX = "java";
    public static final String DEFAULT_INSTRUMENTATION_VERSION = "3.15.9";
    public static final String INSTRUMENTATION_LOG_NAME = "diagnostic-log";
    public static final int MAX_DIAGNOSTIC_VALUE_LENGTH = 14;
    public static final int MAX_DIAGNOSTIC_ENTIES = 3;
    private static boolean instrumentationAdded = false;
    private static final Object instrumentationLock = new Object();

    public static Tuple<Boolean, Iterable<LogEntry>> populateInstrumentationInfo(Iterable<LogEntry> logEntries) {
        boolean isWritten = Instrumentation.setInstrumentationStatus(true);
        if (isWritten) {
            return Tuple.of((Object)false, logEntries);
        }
        ArrayList<LogEntry> entries = new ArrayList<LogEntry>();
        for (LogEntry logEntry : logEntries) {
            if (!isWritten && ((Payload)logEntry.getPayload()).getType() == Payload.Type.JSON && ((Struct)((Payload.JsonPayload)logEntry.getPayload()).getData()).containsFields(DIAGNOSTIC_INFO_KEY)) {
                try {
                    ListValue infoList = ((Struct)((Payload.JsonPayload)logEntry.getPayload()).getData()).getFieldsOrThrow(DIAGNOSTIC_INFO_KEY).getStructValue().getFieldsOrThrow(INSTRUMENTATION_SOURCE_KEY).getListValue();
                    entries.add(Instrumentation.createDiagnosticEntry(null, null, infoList));
                    isWritten = true;
                }
                catch (RuntimeException ex) {
                    System.err.println("ERROR: unexpected exception in populateInstrumentationInfo: " + ex);
                }
                continue;
            }
            entries.add(logEntry);
        }
        if (!isWritten) {
            entries.add(Instrumentation.createDiagnosticEntry(null, null, null));
        }
        return Tuple.of((Object)true, entries);
    }

    public static Logging.WriteOption[] addPartialSuccessOption(Logging.WriteOption[] options) {
        if (options == null) {
            return options;
        }
        ArrayList<Logging.WriteOption> writeOptions = new ArrayList<Logging.WriteOption>();
        Collections.addAll(writeOptions, options);
        writeOptions.removeIf(option -> option.getOptionType() == Logging.WriteOption.OptionType.PARTIAL_SUCCESS);
        writeOptions.add(Logging.WriteOption.partialSuccess(true));
        return (Logging.WriteOption[])Iterables.toArray(writeOptions, Logging.WriteOption.class);
    }

    public static LogEntry createDiagnosticEntry(String libraryName, String libraryVersion) {
        return Instrumentation.createDiagnosticEntry(libraryName, libraryVersion, null);
    }

    private static LogEntry createDiagnosticEntry(String libraryName, String libraryVersion, ListValue existingLibraryList) {
        Struct instrumentation = Struct.newBuilder().putAllFields((Map)ImmutableMap.of((Object)INSTRUMENTATION_SOURCE_KEY, (Object)Value.newBuilder().setListValue(Instrumentation.generateLibrariesList(libraryName, libraryVersion, existingLibraryList)).build())).build();
        return LogEntry.newBuilder(Payload.JsonPayload.of(Struct.newBuilder().putAllFields((Map)ImmutableMap.of((Object)DIAGNOSTIC_INFO_KEY, (Object)Value.newBuilder().setStructValue(instrumentation).build())).build())).setLogName(INSTRUMENTATION_LOG_NAME).build();
    }

    private static ListValue generateLibrariesList(String libraryName, String libraryVersion, ListValue existingLibraryList) {
        if (Strings.isNullOrEmpty((String)libraryName) || !libraryName.startsWith(JAVA_LIBRARY_NAME_PREFIX)) {
            libraryName = JAVA_LIBRARY_NAME_PREFIX;
        }
        if (Strings.isNullOrEmpty((String)libraryVersion)) {
            libraryVersion = Instrumentation.getLibraryVersion(Instrumentation.class);
        }
        Struct libraryInfo = Instrumentation.createInfoStruct(libraryName, libraryVersion);
        ListValue.Builder libraryList = ListValue.newBuilder();
        if (existingLibraryList != null) {
            for (Value val : existingLibraryList.getValuesList()) {
                if (!val.hasStructValue()) continue;
                try {
                    String version;
                    String name = val.getStructValue().getFieldsOrThrow(INSTRUMENTATION_NAME_KEY).getStringValue();
                    if (Strings.isNullOrEmpty((String)name) || !name.startsWith(JAVA_LIBRARY_NAME_PREFIX) || Strings.isNullOrEmpty((String)(version = val.getStructValue().getFieldsOrThrow(INSTRUMENTATION_VERSION_KEY).getStringValue()))) continue;
                    libraryList.addValues(Value.newBuilder().setStructValue(Instrumentation.createInfoStruct(name, version)).build());
                    if (libraryList.getValuesCount() != 3) continue;
                    break;
                }
                catch (RuntimeException ex) {
                    System.err.println("ERROR: unexpected exception in generateLibrariesList: " + ex);
                }
            }
        }
        libraryList.addValues(Value.newBuilder().setStructValue(libraryInfo).build());
        return libraryList.build();
    }

    private static Struct createInfoStruct(String libraryName, String libraryVersion) {
        return Struct.newBuilder().putAllFields((Map)ImmutableMap.of((Object)INSTRUMENTATION_NAME_KEY, (Object)Value.newBuilder().setStringValue(Instrumentation.truncateValue(libraryName)).build(), (Object)INSTRUMENTATION_VERSION_KEY, (Object)Value.newBuilder().setStringValue(Instrumentation.truncateValue(libraryVersion)).build())).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean setInstrumentationStatus(boolean value) {
        if (instrumentationAdded == value) {
            return instrumentationAdded;
        }
        Object object = instrumentationLock;
        synchronized (object) {
            boolean current = instrumentationAdded;
            instrumentationAdded = value;
            return current;
        }
    }

    public static String getLibraryVersion(Class<?> libraryClass) {
        String libraryVersion = GaxProperties.getLibraryVersion(libraryClass);
        if (Strings.isNullOrEmpty((String)libraryVersion)) {
            libraryVersion = DEFAULT_INSTRUMENTATION_VERSION;
        }
        return libraryVersion;
    }

    public static String truncateValue(String value) {
        if (Strings.isNullOrEmpty((String)value) || value.length() < 14) {
            return value;
        }
        return value.substring(0, 14) + "*";
    }

    private Instrumentation() {
    }
}

