/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.spanner.InstanceId;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Objects;

public final class DatabaseId {
    private static final PathTemplate NAME_TEMPLATE = PathTemplate.create((String)"projects/{project}/instances/{instance}/databases/{database}");
    private final InstanceId instanceId;
    private final String database;

    DatabaseId(InstanceId instanceId, String database) {
        this.instanceId = instanceId;
        this.database = database;
    }

    public InstanceId getInstanceId() {
        return this.instanceId;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getName() {
        return String.format("projects/%s/instances/%s/databases/%s", this.instanceId.getProject(), this.instanceId.getInstance(), this.database);
    }

    public int hashCode() {
        return Objects.hash(this.instanceId, this.database);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatabaseId that = (DatabaseId)o;
        return that.instanceId.equals(this.instanceId) && that.database.equals(this.database);
    }

    public String toString() {
        return this.getName();
    }

    static DatabaseId of(String name) {
        Map parts = NAME_TEMPLATE.match(name);
        Preconditions.checkArgument((parts != null ? 1 : 0) != 0, (String)"Name should conform to pattern %s: %s", (Object[])new Object[]{NAME_TEMPLATE, name});
        return DatabaseId.of((String)parts.get("project"), (String)parts.get("instance"), (String)parts.get("database"));
    }

    public static DatabaseId of(String project, String instance, String database) {
        return new DatabaseId(new InstanceId(project, instance), database);
    }

    public static DatabaseId of(InstanceId instanceId, String database) {
        return new DatabaseId(instanceId, database);
    }
}

