/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vertexai.generativeai;

import com.google.cloud.vertexai.api.FunctionDeclaration;
import com.google.cloud.vertexai.api.Schema;
import com.google.cloud.vertexai.api.Type;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.gson.JsonObject;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;

public final class FunctionDeclarationMaker {
    public static FunctionDeclaration fromJsonString(String jsonString) throws InvalidProtocolBufferException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)jsonString) ? 1 : 0) != 0, (Object)"Input String can't be null or empty.");
        FunctionDeclaration.Builder builder = FunctionDeclaration.newBuilder();
        JsonFormat.parser().merge(jsonString, (Message.Builder)builder);
        FunctionDeclaration declaration = builder.build();
        if (declaration.getName().isEmpty()) {
            throw new IllegalArgumentException("name field must be present.");
        }
        return declaration;
    }

    public static FunctionDeclaration fromJsonObject(JsonObject jsonObject) throws InvalidProtocolBufferException {
        Preconditions.checkNotNull((Object)jsonObject, (Object)"JsonObject can't be null.");
        return FunctionDeclarationMaker.fromJsonString(jsonObject.toString());
    }

    public static FunctionDeclaration fromFunc(String functionDescription, Method function, String ... orderedParameterNames) {
        if (!Modifier.isStatic(function.getModifiers())) {
            throw new IllegalArgumentException("Instance methods are not supported. Please use static methods.");
        }
        Schema.Builder parametersBuilder = Schema.newBuilder().setType(Type.OBJECT);
        Parameter[] parameters = function.getParameters();
        if (orderedParameterNames.length > 0 && orderedParameterNames.length != parameters.length) {
            throw new IllegalArgumentException("The number of parameter names does not match the number of parameters in the method.");
        }
        for (int i = 0; i < parameters.length; ++i) {
            if (orderedParameterNames.length == 0) {
                if (!parameters[i].isNamePresent()) {
                    throw new IllegalStateException("Failed to retrieve the parameter name from reflection. Please compile your code with  \"-parameters\" flag or use `fromFunc(String, Method, String...)` to manually enter parameter names");
                }
                FunctionDeclarationMaker.addParameterToParametersBuilder(parametersBuilder, parameters[i].getName(), parameters[i].getType());
                continue;
            }
            FunctionDeclarationMaker.addParameterToParametersBuilder(parametersBuilder, orderedParameterNames[i], parameters[i].getType());
        }
        return FunctionDeclaration.newBuilder().setName(function.getName()).setDescription(functionDescription).setParameters(parametersBuilder).build();
    }

    private static void addParameterToParametersBuilder(Schema.Builder parametersBuilder, String parameterName, Class<?> parameterType) {
        Schema.Builder parameterBuilder = Schema.newBuilder().setDescription(parameterName);
        switch (parameterType.getName()) {
            case "java.lang.String": {
                parameterBuilder.setType(Type.STRING);
                break;
            }
            case "boolean": {
                parameterBuilder.setType(Type.BOOLEAN);
                break;
            }
            case "int": {
                parameterBuilder.setType(Type.INTEGER);
                break;
            }
            case "double": 
            case "float": {
                parameterBuilder.setType(Type.NUMBER);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported parameter type " + parameterType.getName() + " for parameter " + parameterName);
            }
        }
        parametersBuilder.addRequired(parameterName).putProperties(parameterName, parameterBuilder.build());
    }
}

