/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.trace.pubsub;

import brave.Span;
import brave.SpanCustomizer;
import brave.Tracer;
import brave.Tracing;
import brave.messaging.MessagingRequest;
import brave.messaging.MessagingTracing;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import brave.sampler.SamplerFunction;
import com.google.cloud.pubsub.v1.MessageReceiver;
import com.google.cloud.pubsub.v1.PublisherInterface;
import com.google.cloud.pubsub.v1.stub.SubscriberStub;
import com.google.cloud.spring.autoconfigure.trace.pubsub.PubSubConsumerRequest;
import com.google.cloud.spring.autoconfigure.trace.pubsub.PubSubProducerRequest;
import com.google.cloud.spring.autoconfigure.trace.pubsub.TracingMessageReceiver;
import com.google.cloud.spring.autoconfigure.trace.pubsub.TracingPublisher;
import com.google.cloud.spring.autoconfigure.trace.pubsub.TracingSubscriberStub;
import com.google.pubsub.v1.PubsubMessage;
import com.google.pubsub.v1.PullResponse;
import com.google.pubsub.v1.ReceivedMessage;
import java.util.LinkedHashSet;
import java.util.Set;

final class PubSubTracing {
    static final Propagation.Getter<PubsubMessage.Builder, String> GETTER = new Propagation.Getter<PubsubMessage.Builder, String>(){

        public String get(PubsubMessage.Builder request, String key) {
            return request.getAttributesOrDefault(key, null);
        }

        public String toString() {
            return "PubsubMessage.Builder::getAttributesOrThrow";
        }
    };
    final Tracing tracing;
    final Tracer tracer;
    final TraceContext.Extractor<PubSubProducerRequest> producerExtractor;
    final TraceContext.Extractor<PubSubConsumerRequest> consumerExtractor;
    final TraceContext.Extractor<PubsubMessage.Builder> processorExtractor;
    final TraceContext.Injector<PubSubProducerRequest> producerInjector;
    final TraceContext.Injector<PubSubConsumerRequest> consumerInjector;
    final Set<String> traceIdHeaders;
    final TraceContextOrSamplingFlags emptyExtraction;
    final SamplerFunction<MessagingRequest> producerSampler;
    final SamplerFunction<MessagingRequest> consumerSampler;
    final String remoteServiceName;
    final boolean singleRootSpanOnReceiveBatch;

    PubSubTracing(Builder builder) {
        this.tracing = builder.messagingTracing.tracing();
        this.tracer = this.tracing.tracer();
        MessagingTracing messagingTracing = builder.messagingTracing;
        Propagation propagation = this.tracing.propagation();
        this.producerExtractor = propagation.extractor(PubSubProducerRequest.GETTER);
        this.consumerExtractor = propagation.extractor(PubSubConsumerRequest.GETTER);
        this.processorExtractor = propagation.extractor(GETTER);
        this.producerInjector = propagation.injector(PubSubProducerRequest.SETTER);
        this.consumerInjector = propagation.injector(PubSubConsumerRequest.SETTER);
        this.producerSampler = messagingTracing.producerSampler();
        this.consumerSampler = messagingTracing.consumerSampler();
        this.remoteServiceName = builder.remoteServiceName;
        this.singleRootSpanOnReceiveBatch = builder.singleRootSpanOnReceiveBatch;
        this.traceIdHeaders = new LinkedHashSet<String>(propagation.keys());
        this.emptyExtraction = propagation.extractor((c, k) -> null).extract((Object)Boolean.TRUE);
    }

    public static PubSubTracing create(Tracing tracing) {
        return PubSubTracing.newBuilder(tracing).build();
    }

    public static PubSubTracing create(MessagingTracing messagingTracing) {
        return PubSubTracing.newBuilder(messagingTracing).build();
    }

    public static Builder newBuilder(Tracing tracing) {
        return PubSubTracing.newBuilder(MessagingTracing.create((Tracing)tracing));
    }

    public static Builder newBuilder(MessagingTracing messagingTracing) {
        return new Builder(messagingTracing);
    }

    public TracingPublisher publisher(PublisherInterface publisher, String topic) {
        return new TracingPublisher(publisher, this, topic);
    }

    public TracingSubscriberStub subscriberStub(SubscriberStub subscriberStub) {
        return new TracingSubscriberStub(subscriberStub, this);
    }

    public TracingMessageReceiver messageReceiver(MessageReceiver messageReceiver, String subscriptionName) {
        return new TracingMessageReceiver(messageReceiver, this, subscriptionName);
    }

    public Span nextSpan(PubsubMessage.Builder message) {
        TraceContextOrSamplingFlags extracted = this.extractAndClearTraceIdHeaders(this.processorExtractor, message, message);
        Span result = this.tracer.nextSpan(extracted);
        if (extracted.context() == null && !result.isNoop()) {
            PubSubTracing.addTags(message, (SpanCustomizer)result);
        }
        return result;
    }

    Span nextMessagingSpan(SamplerFunction<MessagingRequest> sampler, MessagingRequest request, TraceContextOrSamplingFlags extracted) {
        Boolean sampled = extracted.sampled();
        if (sampled == null && (sampled = sampler.trySample((Object)request)) != null) {
            extracted = extracted.sampled(sampled.booleanValue());
        }
        return this.tracer.nextSpan(extracted);
    }

    <R> TraceContextOrSamplingFlags extractAndClearTraceIdHeaders(TraceContext.Extractor<R> extractor, R request, PubsubMessage.Builder message) {
        TraceContextOrSamplingFlags extracted = extractor.extract(request);
        if (extracted.samplingFlags() == null) {
            this.clearTraceIdHeaders(message);
        }
        return extracted;
    }

    void clearTraceIdHeaders(PubsubMessage.Builder message) {
        for (String traceIDHeader : this.traceIdHeaders) {
            message.removeAttributes(traceIDHeader);
        }
    }

    static void addTags(PubsubMessage.Builder message, SpanCustomizer result) {
        if (message.getMessageId() != null && !"".equals(message.getMessageId())) {
            result.tag("pubsub.message.id", message.getMessageId());
        }
    }

    PullResponse tracePullResponse(PullResponse delegate, String subscriptionName) {
        if (delegate.getReceivedMessagesCount() == 0 || this.tracing.isNoop()) {
            return delegate;
        }
        Span[] batchSpan = null;
        if (this.singleRootSpanOnReceiveBatch) {
            batchSpan = new Span[1];
        }
        PullResponse.Builder wrappedPullResponseBuilder = delegate.toBuilder();
        for (int i = 0; i < delegate.getReceivedMessagesCount(); ++i) {
            wrappedPullResponseBuilder.setReceivedMessages(i, this.traceReceivedMessage(delegate.getReceivedMessages(i), subscriptionName, batchSpan));
        }
        return wrappedPullResponseBuilder.build();
    }

    private ReceivedMessage traceReceivedMessage(ReceivedMessage receivedMessage, String subscriptionName, Span[] batchSpan) {
        PubsubMessage.Builder wrappedMessage = receivedMessage.getMessage().toBuilder();
        this.postProcessMessageForConsuming(wrappedMessage, subscriptionName, batchSpan);
        return receivedMessage.toBuilder().setMessage(wrappedMessage.build()).build();
    }

    private void postProcessMessageForConsuming(PubsubMessage.Builder messageBuilder, String subscriptionName, Span[] batchSpan) {
        long timestamp = 0L;
        PubSubConsumerRequest request = new PubSubConsumerRequest(messageBuilder, subscriptionName);
        TraceContextOrSamplingFlags extracted = this.extractAndClearTraceIdHeaders(this.consumerExtractor, request, messageBuilder);
        if (extracted.equals((Object)this.emptyExtraction) && this.singleRootSpanOnReceiveBatch) {
            Span span = batchSpan[0];
            if (span == null) {
                span = this.nextMessagingSpan(this.consumerSampler, (MessagingRequest)request, extracted);
                if (!span.isNoop()) {
                    this.setConsumerSpan(span, subscriptionName);
                    timestamp = this.tracing.clock(span.context()).currentTimeMicroseconds();
                    span.start(timestamp);
                }
                batchSpan[0] = span;
            }
            this.consumerInjector.inject(span.context(), (Object)request);
        } else {
            Span span = this.nextMessagingSpan(this.consumerSampler, (MessagingRequest)request, extracted);
            if (!span.isNoop()) {
                this.setConsumerSpan(span, subscriptionName);
                timestamp = this.tracing.clock(span.context()).currentTimeMicroseconds();
                span.start(timestamp);
                span.finish(timestamp);
            }
            this.consumerInjector.inject(span.context(), (Object)request);
        }
        if (this.singleRootSpanOnReceiveBatch && batchSpan[0] != null) {
            batchSpan[0].finish(timestamp);
        }
    }

    private void setConsumerSpan(Span span, String subscriptionName) {
        span.tag("pubsub.subscription", subscriptionName);
        span.name("pull").kind(Span.Kind.CONSUMER);
        if (this.remoteServiceName != null) {
            span.remoteServiceName(this.remoteServiceName);
        }
    }

    public static final class Builder {
        final MessagingTracing messagingTracing;
        String remoteServiceName = "pubsub";
        boolean singleRootSpanOnReceiveBatch = true;

        Builder(MessagingTracing messagingTracing) {
            if (messagingTracing == null) {
                throw new NullPointerException("messagingTracing == null");
            }
            this.messagingTracing = messagingTracing;
        }

        public Builder remoteServiceName(String remoteServiceName) {
            this.remoteServiceName = remoteServiceName;
            return this;
        }

        public Builder singleRootSpanOnReceiveBatch(boolean singleRootSpanOnReceiveBatch) {
            this.singleRootSpanOnReceiveBatch = singleRootSpanOnReceiveBatch;
            return this;
        }

        public PubSubTracing build() {
            return new PubSubTracing(this);
        }
    }
}

