/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.data.datastore.core.convert;

import com.google.cloud.datastore.BaseEntity;
import com.google.cloud.datastore.EntityValue;
import com.google.cloud.datastore.FullEntity;
import com.google.cloud.datastore.ListValue;
import com.google.cloud.datastore.StringValue;
import com.google.cloud.datastore.Value;
import com.google.cloud.spring.data.datastore.core.convert.DatastoreCustomConversions;
import com.google.cloud.spring.data.datastore.core.convert.DatastoreEntityConverter;
import com.google.cloud.spring.data.datastore.core.convert.EntityPropertyValueProvider;
import com.google.cloud.spring.data.datastore.core.convert.ObjectToKeyFactory;
import com.google.cloud.spring.data.datastore.core.convert.ReadWriteConversions;
import com.google.cloud.spring.data.datastore.core.convert.TwoStepsConversions;
import com.google.cloud.spring.data.datastore.core.mapping.DatastoreDataException;
import com.google.cloud.spring.data.datastore.core.mapping.DatastoreMappingContext;
import com.google.cloud.spring.data.datastore.core.mapping.DatastorePersistentEntity;
import com.google.cloud.spring.data.datastore.core.mapping.DatastorePersistentProperty;
import com.google.cloud.spring.data.datastore.core.mapping.EmbeddedType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.model.EntityInstantiator;
import org.springframework.data.mapping.model.EntityInstantiators;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.mapping.model.PersistentEntityParameterValueProvider;
import org.springframework.data.mapping.model.PropertyValueProvider;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public class DefaultDatastoreEntityConverter
implements DatastoreEntityConverter {
    private final DatastoreMappingContext mappingContext;
    private final EntityInstantiators instantiators = new EntityInstantiators();
    private final ReadWriteConversions conversions;

    public DefaultDatastoreEntityConverter(DatastoreMappingContext mappingContext, ObjectToKeyFactory objectToKeyFactory) {
        this(mappingContext, new TwoStepsConversions(new DatastoreCustomConversions(), objectToKeyFactory, mappingContext));
    }

    public DefaultDatastoreEntityConverter(DatastoreMappingContext mappingContext, ReadWriteConversions conversions) {
        this.mappingContext = mappingContext;
        this.conversions = conversions;
        conversions.registerEntityConverter(this);
    }

    @Override
    public ReadWriteConversions getConversions() {
        return this.conversions;
    }

    @Override
    public <T, R> Map<T, R> readAsMap(BaseEntity entity, TypeInformation mapTypeInformation) {
        Map result;
        Assert.notNull((Object)mapTypeInformation, (String)"mapTypeInformation can't be null");
        if (entity == null) {
            return null;
        }
        if (!mapTypeInformation.getType().isInterface()) {
            try {
                result = (Map)mapTypeInformation.getType().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new DatastoreDataException("Unable to create an instance of a custom map type: " + mapTypeInformation.getType() + " (make sure the class is public and has a public no-args constructor)", e);
            }
        } else {
            result = new HashMap();
        }
        EntityPropertyValueProvider propertyValueProvider = new EntityPropertyValueProvider(entity, this.conversions);
        Set fieldNames = entity.getNames();
        for (String field : fieldNames) {
            result.put(this.conversions.convertOnRead((Object)field, EmbeddedType.NOT_EMBEDDED, mapTypeInformation.getComponentType()), propertyValueProvider.getPropertyValue(field, EmbeddedType.of(mapTypeInformation.getMapValueType()), mapTypeInformation.getMapValueType()));
        }
        return result;
    }

    @Override
    public <T, R> Map<T, R> readAsMap(Class<T> keyType, TypeInformation<R> componentType, BaseEntity entity) {
        if (entity == null) {
            return null;
        }
        return this.readAsMap(entity, TypeInformation.of(HashMap.class));
    }

    @Override
    public <T> DatastorePersistentEntity<T> getDiscriminationPersistentEntity(Class<T> entityClass, BaseEntity<?> entity) {
        DatastorePersistentEntity ostensiblePersistentEntity = (DatastorePersistentEntity)this.mappingContext.getPersistentEntity(entityClass);
        if (ostensiblePersistentEntity == null) {
            throw new DatastoreDataException("Unable to convert Datastore Entity to " + entityClass);
        }
        EntityPropertyValueProvider propertyValueProvider = new EntityPropertyValueProvider(entity, this.conversions);
        return this.getDiscriminationPersistentEntity(ostensiblePersistentEntity, propertyValueProvider);
    }

    public <R> R read(Class<R> clazz, BaseEntity entity) {
        Object instance;
        if (entity == null) {
            return null;
        }
        DatastorePersistentEntity ostensiblePersistentEntity = (DatastorePersistentEntity)this.mappingContext.getPersistentEntity(clazz);
        if (ostensiblePersistentEntity == null) {
            throw new DatastoreDataException("Unable to convert Datastore Entity to " + clazz);
        }
        EntityPropertyValueProvider propertyValueProvider = new EntityPropertyValueProvider(entity, this.conversions);
        DatastorePersistentEntity persistentEntity = this.getDiscriminationPersistentEntity(ostensiblePersistentEntity, propertyValueProvider);
        PersistentEntityParameterValueProvider parameterValueProvider = new PersistentEntityParameterValueProvider((PersistentEntity)persistentEntity, (PropertyValueProvider)propertyValueProvider, null);
        EntityInstantiator instantiator = this.instantiators.getInstantiatorFor((PersistentEntity)persistentEntity);
        try {
            instance = instantiator.createInstance((PersistentEntity)persistentEntity, (ParameterValueProvider)parameterValueProvider);
            PersistentPropertyAccessor accessor = persistentEntity.getPropertyAccessor(instance);
            persistentEntity.doWithColumnBackedProperties((PropertyHandler<DatastorePersistentProperty>)((PropertyHandler)datastorePersistentProperty -> {
                Object value;
                if (!persistentEntity.isCreatorArgument(datastorePersistentProperty) && (value = propertyValueProvider.getPropertyValue((DatastorePersistentProperty)datastorePersistentProperty)) != null) {
                    accessor.setProperty(datastorePersistentProperty, value);
                }
            }));
        }
        catch (DatastoreDataException ex) {
            throw new DatastoreDataException("Unable to read " + persistentEntity.getName() + " entity", (Throwable)((Object)ex));
        }
        return (R)instance;
    }

    private DatastorePersistentEntity getDiscriminationPersistentEntity(DatastorePersistentEntity ostensibleEntity, EntityPropertyValueProvider propertyValueProvider) {
        if (ostensibleEntity.getDiscriminationFieldName() == null) {
            return ostensibleEntity;
        }
        Set<Class> members = DatastoreMappingContext.getDiscriminationFamily(ostensibleEntity.getType());
        Optional<DatastorePersistentEntity> persistentEntity = members == null ? Optional.empty() : members.stream().map(x -> (DatastorePersistentEntity)this.mappingContext.getPersistentEntity((Class)x)).filter(x -> x != null && this.isDiscriminationFieldMatch((DatastorePersistentEntity)x, propertyValueProvider)).findFirst();
        return persistentEntity.orElse(ostensibleEntity);
    }

    private boolean isDiscriminationFieldMatch(DatastorePersistentEntity entity, EntityPropertyValueProvider propertyValueProvider) {
        return ((String[])propertyValueProvider.getPropertyValue(entity.getDiscriminationFieldName(), EmbeddedType.NOT_EMBEDDED, TypeInformation.of(String[].class)))[0].equals(entity.getDiscriminatorValue());
    }

    public void write(Object source, @NonNull BaseEntity.Builder sink) {
        DatastorePersistentEntity<?> persistentEntity = this.mappingContext.getDatastorePersistentEntity(source.getClass());
        String discriminationFieldName = persistentEntity.getDiscriminationFieldName();
        List<String> discriminationValues = persistentEntity.getCompatibleDiscriminationValues();
        if (!discriminationValues.isEmpty() || discriminationFieldName != null) {
            sink.set(discriminationFieldName, discriminationValues.stream().map(StringValue::of).toList());
        }
        PersistentPropertyAccessor accessor = persistentEntity.getPropertyAccessor(source);
        persistentEntity.doWithColumnBackedProperties((PropertyHandler<DatastorePersistentProperty>)((PropertyHandler)persistentProperty -> {
            if (persistentProperty.isIdProperty()) {
                return;
            }
            try {
                Object val = accessor.getProperty(persistentProperty);
                Value convertedVal = this.conversions.convertOnWrite(val, (DatastorePersistentProperty)persistentProperty);
                if (persistentProperty.isUnindexed()) {
                    convertedVal = this.setExcludeFromIndexes(convertedVal);
                }
                sink.set(persistentProperty.getFieldName(), convertedVal);
            }
            catch (DatastoreDataException ex) {
                throw new DatastoreDataException("Unable to write " + persistentEntity.kindName() + "." + persistentProperty.getFieldName(), (Throwable)((Object)ex));
            }
        }));
    }

    private Value setExcludeFromIndexes(Value convertedVal) {
        if (convertedVal.getClass().equals(EntityValue.class)) {
            FullEntity.Builder builder = FullEntity.newBuilder();
            ((FullEntity)((EntityValue)convertedVal).get()).getProperties().forEach((key, value) -> builder.set(key, this.setExcludeFromIndexes((Value)value)));
            return EntityValue.of((FullEntity)builder.build());
        }
        if (convertedVal.getClass().equals(ListValue.class)) {
            return ListValue.of(((List)((ListValue)convertedVal).get()).stream().map(this::setExcludeFromIndexes).toList());
        }
        return convertedVal.toBuilder().setExcludeFromIndexes(true).build();
    }
}

