/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.data.datastore.repository.query;

import com.google.cloud.spring.data.datastore.core.DatastoreOperations;
import com.google.cloud.spring.data.datastore.core.mapping.DatastoreMappingContext;
import com.google.cloud.spring.data.datastore.repository.query.DatastoreQueryMethod;
import java.lang.reflect.Array;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;

public abstract class AbstractDatastoreQuery<T>
implements RepositoryQuery {
    final DatastoreMappingContext datastoreMappingContext;
    final DatastoreQueryMethod queryMethod;
    final DatastoreOperations datastoreOperations;
    final Class<T> entityType;

    protected AbstractDatastoreQuery(DatastoreQueryMethod queryMethod, DatastoreOperations datastoreOperations, DatastoreMappingContext datastoreMappingContext, Class<T> entityType) {
        this.queryMethod = queryMethod;
        this.datastoreOperations = datastoreOperations;
        this.datastoreMappingContext = datastoreMappingContext;
        this.entityType = entityType;
    }

    public QueryMethod getQueryMethod() {
        return this.queryMethod;
    }

    protected Object[] convertCollectionParamToCompatibleArray(List<?> param) {
        List<Object> converted;
        return converted.toArray((Object[])Array.newInstance((converted = param.stream().map(x -> this.datastoreOperations.getDatastoreEntityConverter().getConversions().convertOnWriteSingle(x).get()).collect(Collectors.toList())).isEmpty() ? String.class : converted.get(0).getClass(), converted.size()));
    }

    Object processRawObjectForProjection(Object object) {
        return this.queryMethod.getResultProcessor().processResult(object);
    }

    public DatastoreOperations getDatastoreOperations() {
        return this.datastoreOperations;
    }

    boolean isPageQuery() {
        return this.getQueryMethod().isPageQuery();
    }

    boolean isSliceQuery() {
        return this.getQueryMethod().isSliceQuery();
    }
}

