/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.data.datastore.repository.support;

import com.google.cloud.datastore.Cursor;
import com.google.cloud.datastore.Key;
import com.google.cloud.spring.data.datastore.core.DatastoreOperations;
import com.google.cloud.spring.data.datastore.core.DatastoreQueryOptions;
import com.google.cloud.spring.data.datastore.core.DatastoreResultsCollection;
import com.google.cloud.spring.data.datastore.core.DatastoreResultsIterable;
import com.google.cloud.spring.data.datastore.repository.DatastoreRepository;
import com.google.cloud.spring.data.datastore.repository.query.DatastorePageable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.FluentQuery;
import org.springframework.data.util.Streamable;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SimpleDatastoreRepository<T, I>
implements DatastoreRepository<T, I> {
    private final DatastoreOperations datastoreTemplate;
    private final Class<T> entityType;
    private static final Log LOGGER = LogFactory.getLog(SimpleDatastoreRepository.class);

    public SimpleDatastoreRepository(DatastoreOperations datastoreTemplate, Class<T> entityType) {
        Assert.notNull((Object)datastoreTemplate, (String)"A non-null DatastoreOperations is required.");
        Assert.notNull(entityType, (String)"A non-null entity type is required.");
        this.datastoreTemplate = datastoreTemplate;
        this.entityType = entityType;
    }

    @Override
    public <A> A performTransaction(Function<DatastoreRepository<T, I>, A> operations) {
        return (A)this.datastoreTemplate.performTransaction((DatastoreOperations template) -> operations.apply(new SimpleDatastoreRepository<T, I>((DatastoreOperations)template, this.entityType)));
    }

    public Iterable<T> findAll(Sort sort) {
        Assert.notNull((Object)sort, (String)"A non-null Sort is required.");
        return this.datastoreTemplate.findAll(this.entityType, new DatastoreQueryOptions.Builder().setSort(sort).build());
    }

    public Page<T> findAll(Pageable pageable) {
        Assert.notNull((Object)pageable, (String)"A non-null Pageable is required.");
        Collection<T> entities = this.datastoreTemplate.findAll(this.entityType, new DatastoreQueryOptions.Builder().setLimit(pageable.getPageSize()).setOffset((int)pageable.getOffset()).setSort(pageable.getSort()).setCursor(SimpleDatastoreRepository.getCursor(pageable)).build());
        Long totalCount = SimpleDatastoreRepository.getOrComputeTotalCount(pageable, () -> this.datastoreTemplate.count(this.entityType));
        Pageable cursorPageable = DatastorePageable.from(pageable, entities instanceof DatastoreResultsCollection ? ((DatastoreResultsCollection)entities).getCursor() : null, totalCount);
        return new PageImpl(entities != null ? new ArrayList<T>(entities) : Collections.emptyList(), cursorPageable, totalCount.longValue());
    }

    public <S extends T> S save(S entity) {
        return this.datastoreTemplate.save(entity, new Key[0]);
    }

    public <S extends T> Iterable<S> saveAll(Iterable<S> entities) {
        return this.datastoreTemplate.saveAll(entities, new Key[0]);
    }

    public Optional<T> findById(I id) {
        return Optional.ofNullable(this.datastoreTemplate.findById(id, this.entityType));
    }

    public boolean existsById(I id) {
        return this.datastoreTemplate.existsById(id, this.entityType);
    }

    public Iterable<T> findAll() {
        return this.datastoreTemplate.findAll(this.entityType);
    }

    public Iterable<T> findAllById(Iterable<I> ids) {
        return this.datastoreTemplate.findAllById(ids, this.entityType);
    }

    public long count() {
        return this.datastoreTemplate.count(this.entityType);
    }

    public void deleteById(I id) {
        this.datastoreTemplate.deleteById(id, this.entityType);
    }

    public void delete(T entity) {
        this.datastoreTemplate.delete(entity);
    }

    public void deleteAll(Iterable<? extends T> entities) {
        this.datastoreTemplate.deleteAll(entities);
    }

    public void deleteAll() {
        this.datastoreTemplate.deleteAll(this.entityType);
    }

    public <S extends T> Optional<S> findOne(Example<S> example) {
        Iterable<S> entities = this.datastoreTemplate.queryByExample(example, new DatastoreQueryOptions.Builder().setLimit(1).build());
        Iterator<S> iterator = entities.iterator();
        return iterator.hasNext() ? Optional.of(iterator.next()) : Optional.empty();
    }

    <S extends T> S findFirstSorted(Example<S> example, Sort sort) {
        Iterable<S> entities = this.datastoreTemplate.queryByExample(example, new DatastoreQueryOptions.Builder().setSort(sort).setLimit(1).build());
        Iterator<S> iterator = entities.iterator();
        return iterator.hasNext() ? (S)iterator.next() : null;
    }

    public <S extends T> Iterable<S> findAll(Example<S> example) {
        return this.datastoreTemplate.queryByExample(example, null);
    }

    public <S extends T> Iterable<S> findAll(Example<S> example, Sort sort) {
        return this.datastoreTemplate.queryByExample(example, new DatastoreQueryOptions.Builder().setSort(sort).build());
    }

    public <S extends T> Page<S> findAll(Example<S> example, Pageable pageable) {
        Assert.notNull((Object)pageable, (String)"A non-null pageable is required.");
        Iterable<S> entities = this.datastoreTemplate.queryByExample(example, new DatastoreQueryOptions.Builder().setLimit(pageable.getPageSize()).setOffset((int)pageable.getOffset()).setSort(pageable.getSort()).setCursor(SimpleDatastoreRepository.getCursor(pageable)).build());
        List result = StreamSupport.stream(entities.spliterator(), false).collect(Collectors.toList());
        Long totalCount = SimpleDatastoreRepository.getOrComputeTotalCount(pageable, () -> this.count(example));
        Pageable cursorPageable = DatastorePageable.from(pageable, entities instanceof DatastoreResultsIterable ? ((DatastoreResultsIterable)entities).getCursor() : null, totalCount);
        return new PageImpl(result, cursorPageable, totalCount.longValue());
    }

    public <S extends T> long count(Example<S> example) {
        Iterable<Key> keys = this.datastoreTemplate.keyQueryByExample(example, null);
        return StreamSupport.stream(keys.spliterator(), false).count();
    }

    public <S extends T> boolean exists(Example<S> example) {
        Iterable<Key> keys = this.datastoreTemplate.keyQueryByExample(example, new DatastoreQueryOptions.Builder().setLimit(1).build());
        return StreamSupport.stream(keys.spliterator(), false).findAny().isPresent();
    }

    private static Cursor getCursor(Pageable pageable) {
        return pageable instanceof DatastorePageable ? ((DatastorePageable)pageable).toCursor() : null;
    }

    private static Long getOrComputeTotalCount(Pageable pageable, LongSupplier countCall) {
        return pageable instanceof DatastorePageable ? ((DatastorePageable)pageable).getTotalCount().longValue() : countCall.getAsLong();
    }

    public void deleteAllById(Iterable<? extends I> iterable) {
        this.datastoreTemplate.deleteAllById(iterable, this.entityType);
    }

    public <S extends T, R> R findBy(Example<S> example, Function<FluentQuery.FetchableFluentQuery<S>, R> queryFunction) {
        Assert.notNull(example, (String)"Example must not be null");
        Assert.notNull(queryFunction, (String)"Query function must not be null");
        return queryFunction.apply(new DatastoreFluentQueryByExample<S>(example));
    }

    class DatastoreFluentQueryByExample<S extends T>
    implements FluentQuery.FetchableFluentQuery<S> {
        private final Example<S> example;
        private final Sort sort;

        DatastoreFluentQueryByExample(Example<S> example) {
            this(example, Sort.unsorted());
        }

        DatastoreFluentQueryByExample(Example<S> example, Sort sort) {
            this.example = example;
            this.sort = sort;
        }

        @NonNull
        public FluentQuery.FetchableFluentQuery<S> sortBy(@NonNull Sort sort) {
            return new DatastoreFluentQueryByExample<S>(this.example, sort);
        }

        @NonNull
        public Optional<S> one() {
            return SimpleDatastoreRepository.this.findOne(this.example);
        }

        @Nullable
        public S oneValue() {
            Optional<S> one = this.one();
            return one.orElse(null);
        }

        public S firstValue() {
            if (this.sort.isUnsorted()) {
                LOGGER.warn((Object)"firstValue() used without sorting. Use oneValue() instead if order does not matter.");
            }
            return SimpleDatastoreRepository.this.findFirstSorted(this.example, this.sort);
        }

        @NonNull
        public List<S> all() {
            return this.stream().collect(Collectors.toList());
        }

        @NonNull
        public Page<S> page(@NonNull Pageable pageable) {
            return SimpleDatastoreRepository.this.findAll(this.example, pageable);
        }

        @NonNull
        public Stream<S> stream() {
            return Streamable.of(SimpleDatastoreRepository.this.findAll(this.example, this.sort)).stream();
        }

        public long count() {
            return SimpleDatastoreRepository.this.count(this.example);
        }

        public boolean exists() {
            return SimpleDatastoreRepository.this.exists(this.example);
        }

        public FluentQuery.FetchableFluentQuery<S> project(Collection properties) {
            throw new UnsupportedOperationException();
        }

        public <V> FluentQuery.FetchableFluentQuery<V> as(Class<V> resultType) {
            throw new UnsupportedOperationException();
        }
    }
}

