/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.logging.extractors;

import com.google.cloud.spring.logging.extractors.TraceIdExtractor;
import jakarta.servlet.http.HttpServletRequest;

public class CloudTraceIdExtractor
implements TraceIdExtractor {
    public static final String X_CLOUD_TRACE_HEADER = "x-cloud-trace-context";

    @Override
    public String extractTraceIdFromRequest(HttpServletRequest req) {
        int slash;
        String traceId = req.getHeader(X_CLOUD_TRACE_HEADER);
        if (traceId != null && (slash = traceId.indexOf(47)) >= 0) {
            traceId = traceId.substring(0, slash);
        }
        return traceId;
    }
}

