/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sqlcommenter.threadlocalstorage;

import com.google.cloud.sqlcommenter.threadlocalstorage.SpanContextMetadata;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class State {
    private static final Logger logger = Logger.getLogger(State.class.getName());
    private final String UTF8 = StandardCharsets.UTF_8.toString();
    public static final String W3C_CONTEXT_VERSION = "00";
    @Nullable
    private String controllerName;
    @Nullable
    private String actionName;
    @Nullable
    private String framework;
    @Nullable
    private SpanContextMetadata spanContextMetadata;

    private State() {
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(State copy) {
        if (copy == null) {
            return new Builder();
        }
        return new Builder().withActionName(copy.actionName).withControllerName(copy.controllerName).withSpanContextMetadata(copy.spanContextMetadata).withFramework(copy.framework);
    }

    private Boolean hasSQLComment(String stmt) {
        if (stmt == null || stmt.isEmpty()) {
            return false;
        }
        return stmt.contains("--") || stmt.contains("/*");
    }

    public String formatAndAppendToSQL(String sql) {
        if (sql == null || sql.isEmpty()) {
            return sql;
        }
        if (this.hasSQLComment(sql).booleanValue()) {
            return sql;
        }
        String commentStr = this.toString();
        if (commentStr.isEmpty()) {
            return sql;
        }
        return String.format("%s /*%s*/", sql, commentStr);
    }

    private String urlEncode(String s) throws Exception {
        return URLEncoder.encode(s, this.UTF8);
    }

    private SortedMap<String, Object> sortedKeyValuePairs() {
        TreeMap<String, Object> sortedMap = new TreeMap<String, Object>();
        sortedMap.put("action", this.actionName);
        sortedMap.put("traceparent", this.traceParent());
        sortedMap.put("tracestate", this.traceState());
        sortedMap.put("controller", this.controllerName);
        sortedMap.put("framework", this.framework);
        return sortedMap;
    }

    @Nullable
    private String traceParent() {
        return this.spanContextMetadata == null ? null : String.format("%s-%s-%s-%02X", W3C_CONTEXT_VERSION, this.spanContextMetadata.getTraceId(), this.spanContextMetadata.getSpanId(), this.spanContextMetadata.getTraceOptions());
    }

    @Nullable
    private String traceState() {
        return this.spanContextMetadata == null ? null : this.spanContextMetadata.getTraceState();
    }

    public String toString() {
        SortedMap<String, Object> skvp = this.sortedKeyValuePairs();
        ArrayList<String> keyValuePairsList = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : skvp.entrySet()) {
            Object value = entry.getValue();
            if (this.isBlank(value).booleanValue()) continue;
            try {
                String valueStr = String.format("%s", value);
                String keyValuePairString = String.format("%s='%s'", this.urlEncode(entry.getKey()), this.urlEncode(valueStr));
                keyValuePairsList.add(keyValuePairString);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Exception when encoding State", e);
            }
        }
        return String.join((CharSequence)",", keyValuePairsList);
    }

    private Boolean isBlank(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof String) {
            return obj == "";
        }
        if (obj instanceof Number) {
            Number number = (Number)obj;
            return number.doubleValue() == 0.0;
        }
        return false;
    }

    public static class Holder {
        private static final ThreadLocal<State> threadState = new ThreadLocal();

        public static void set(State state) {
            threadState.set(state);
        }

        public static State get() {
            return threadState.get();
        }

        public static void remove() {
            threadState.remove();
        }
    }

    public static class Builder {
        @Nullable
        private String actionName;
        @Nullable
        private String controllerName;
        @Nullable
        private String framework;
        @Nullable
        private SpanContextMetadata spanContextMetadata;

        private Builder() {
        }

        public Builder withActionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public Builder withControllerName(String controllerName) {
            this.controllerName = controllerName;
            return this;
        }

        public Builder withSpanContextMetadata(SpanContextMetadata spanContextMetadata) {
            this.spanContextMetadata = spanContextMetadata;
            return this;
        }

        public Builder withFramework(String framework) {
            this.framework = framework;
            return this;
        }

        public State build() {
            State state = new State();
            state.actionName = this.actionName;
            state.controllerName = this.controllerName;
            state.spanContextMetadata = this.spanContextMetadata;
            state.framework = this.framework;
            return state;
        }
    }
}

