/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.maven;

import com.google.cloud.tools.appengine.api.debug.GenRepoInfoFile;
import com.google.cloud.tools.appengine.api.deploy.AppEngineDeployment;
import com.google.cloud.tools.appengine.api.deploy.AppEngineFlexibleStaging;
import com.google.cloud.tools.appengine.api.deploy.AppEngineStandardStaging;
import com.google.cloud.tools.appengine.api.devserver.AppEngineDevServer;
import com.google.cloud.tools.appengine.cloudsdk.CloudSdk;
import com.google.cloud.tools.appengine.cloudsdk.CloudSdkAppEngineDeployment;
import com.google.cloud.tools.appengine.cloudsdk.CloudSdkAppEngineDevServer1;
import com.google.cloud.tools.appengine.cloudsdk.CloudSdkAppEngineDevServer2;
import com.google.cloud.tools.appengine.cloudsdk.CloudSdkAppEngineFlexibleStaging;
import com.google.cloud.tools.appengine.cloudsdk.CloudSdkAppEngineStandardStaging;
import com.google.cloud.tools.appengine.cloudsdk.CloudSdkGenRepoInfoFile;
import com.google.cloud.tools.appengine.cloudsdk.process.NonZeroExceptionExitListener;
import com.google.cloud.tools.appengine.cloudsdk.process.ProcessExitListener;
import com.google.cloud.tools.appengine.cloudsdk.process.ProcessOutputLineListener;
import com.google.cloud.tools.maven.AppEngineFactory;
import com.google.cloud.tools.maven.CloudSdkMojo;
import org.apache.maven.plugin.logging.Log;

public class CloudSdkAppEngineFactory
implements AppEngineFactory {
    protected CloudSdkFactory cloudSdkFactory;
    private CloudSdkMojo mojo;

    public CloudSdkAppEngineFactory(CloudSdkMojo mojo) {
        this(mojo, new CloudSdkFactory());
    }

    public CloudSdkAppEngineFactory(CloudSdkMojo mojo, CloudSdkFactory cloudSdkFactory) {
        this.mojo = mojo;
        this.cloudSdkFactory = cloudSdkFactory;
    }

    @Override
    public AppEngineStandardStaging standardStaging() {
        return this.cloudSdkFactory.standardStaging(this.defaultCloudSdkBuilder().build());
    }

    @Override
    public AppEngineFlexibleStaging flexibleStaging() {
        return this.cloudSdkFactory.flexibleStaging();
    }

    @Override
    public AppEngineDeployment deployment() {
        return this.cloudSdkFactory.deployment(this.defaultCloudSdkBuilder().build());
    }

    @Override
    public AppEngineDevServer devServerRunSync(AppEngineFactory.SupportedDevServerVersion version) {
        return this.createDevServerForVersion(version);
    }

    private AppEngineDevServer createDevServerForVersion(AppEngineFactory.SupportedDevServerVersion version) {
        return this.createDevServerForVersion(version, this.defaultCloudSdkBuilder().build());
    }

    private AppEngineDevServer createDevServerForVersion(AppEngineFactory.SupportedDevServerVersion version, CloudSdk cloudSdk) {
        switch (version) {
            case V1: {
                return this.cloudSdkFactory.devServer1(cloudSdk);
            }
            case V2ALPHA: {
                return this.cloudSdkFactory.devServer(cloudSdk);
            }
        }
        throw new IllegalArgumentException("Unsupported dev server version: " + (Object)((Object)version));
    }

    @Override
    public AppEngineDevServer devServerRunAsync(int startSuccessTimeout, AppEngineFactory.SupportedDevServerVersion version) {
        CloudSdk.Builder builder = this.defaultCloudSdkBuilder().async(true).runDevAppServerWait(startSuccessTimeout);
        return this.createDevServerForVersion(version, builder.build());
    }

    @Override
    public AppEngineDevServer devServerStop(AppEngineFactory.SupportedDevServerVersion version) {
        return this.createDevServerForVersion(version);
    }

    @Override
    public GenRepoInfoFile genRepoInfoFile() {
        return this.cloudSdkFactory.genRepoInfoFile(this.defaultCloudSdkBuilder().build());
    }

    protected CloudSdk.Builder defaultCloudSdkBuilder() {
        DefaultProcessOutputLineListener lineListener = new DefaultProcessOutputLineListener(this.mojo.getLog());
        return this.cloudSdkFactory.cloudSdkBuilder().sdkPath(this.mojo.getCloudSdkPath()).addStdOutLineListener((ProcessOutputLineListener)lineListener).addStdErrLineListener((ProcessOutputLineListener)lineListener).exitListener((ProcessExitListener)new NonZeroExceptionExitListener()).appCommandMetricsEnvironment(this.mojo.getArtifactId()).appCommandMetricsEnvironmentVersion(this.mojo.getArtifactVersion());
    }

    protected static class CloudSdkFactory {
        protected CloudSdkFactory() {
        }

        public CloudSdk.Builder cloudSdkBuilder() {
            return new CloudSdk.Builder();
        }

        public AppEngineStandardStaging standardStaging(CloudSdk cloudSdk) {
            return new CloudSdkAppEngineStandardStaging(cloudSdk);
        }

        public AppEngineFlexibleStaging flexibleStaging() {
            return new CloudSdkAppEngineFlexibleStaging();
        }

        public AppEngineDeployment deployment(CloudSdk cloudSdk) {
            return new CloudSdkAppEngineDeployment(cloudSdk);
        }

        public AppEngineDevServer devServer(CloudSdk cloudSdk) {
            return new CloudSdkAppEngineDevServer2(cloudSdk);
        }

        public AppEngineDevServer devServer1(CloudSdk cloudSdk) {
            return new CloudSdkAppEngineDevServer1(cloudSdk);
        }

        public GenRepoInfoFile genRepoInfoFile(CloudSdk cloudSdk) {
            return new CloudSdkGenRepoInfoFile(cloudSdk);
        }
    }

    protected static class DefaultProcessOutputLineListener
    implements ProcessOutputLineListener {
        private Log log;

        public DefaultProcessOutputLineListener(Log log) {
            this.log = log;
        }

        public void onOutputLine(String line) {
            this.log.info((CharSequence)("GCLOUD: " + line));
        }
    }
}

