/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.maven;

import com.google.cloud.tools.maven.AppEngineFactory;
import com.google.cloud.tools.maven.CloudSdkAppEngineFactory;
import java.io.File;
import java.nio.file.Path;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public abstract class CloudSdkMojo
extends AbstractMojo {
    @Parameter(property="cloudSdkPath", required=false)
    private File cloudSdkPath;
    @Parameter(defaultValue="${plugin}", readonly=true)
    private PluginDescriptor pluginDescriptor;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject mavenProject;
    private AppEngineFactory factory = new CloudSdkAppEngineFactory(this);

    public String getArtifactId() {
        return this.pluginDescriptor.getArtifactId();
    }

    public String getArtifactVersion() {
        return this.pluginDescriptor.getVersion();
    }

    public Path getCloudSdkPath() {
        return this.cloudSdkPath != null ? this.cloudSdkPath.toPath() : null;
    }

    public AppEngineFactory getAppEngineFactory() {
        return this.factory;
    }

    public String getCompileTargetVersion() {
        String javaVersion = "1.5";
        if (this.mavenProject != null) {
            String mavenCompilerTargetProperty = this.mavenProject.getProperties().getProperty("maven.compiler.target");
            if (mavenCompilerTargetProperty != null) {
                javaVersion = mavenCompilerTargetProperty;
            } else {
                Xpp3Dom domVersion;
                Xpp3Dom config;
                Plugin compilerPlugin = this.mavenProject.getPlugin("org.apache.maven.plugins:maven-compiler-plugin");
                if (compilerPlugin != null && (config = (Xpp3Dom)compilerPlugin.getConfiguration()) != null && (domVersion = config.getChild("target")) != null) {
                    javaVersion = domVersion.getValue();
                }
            }
        }
        return javaVersion;
    }

    protected String getPackaging() {
        return this.mavenProject.getPackaging();
    }
}

