/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.maven;

import com.google.cloud.tools.appengine.api.deploy.DeployConfiguration;
import com.google.cloud.tools.maven.StageMojo;
import java.io.File;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="deploy")
@Execute(phase=LifecyclePhase.PACKAGE)
public class DeployMojo
extends StageMojo
implements DeployConfiguration {
    @Parameter(alias="deploy.deployables", property="app.deploy.deployables")
    protected List<File> deployables;
    @Parameter(alias="deploy.bucket", property="app.deploy.bucket")
    protected String bucket;
    @Parameter(alias="deploy.imageUrl", property="app.deploy.imageUrl")
    protected String imageUrl;
    @Parameter(alias="deploy.promote", property="app.deploy.promote")
    protected Boolean promote;
    @Parameter(alias="deploy.server", property="app.deploy.server")
    protected String server;
    @Parameter(alias="deploy.stopPreviousVersion", property="app.deploy.stopPreviousVersion")
    protected Boolean stopPreviousVersion;
    @Parameter(alias="deploy.version", property="app.deploy.version")
    protected String version;
    @Parameter(alias="deploy.project", property="app.deploy.project")
    protected String project;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!"war".equals(this.getPackaging()) && !"jar".equals(this.getPackaging())) {
            this.getLog().info((CharSequence)"Deploy is only executed for war and jar modules.");
            return;
        }
        super.execute();
        if (this.deployables.isEmpty()) {
            this.deployables.add(this.stagingDirectory);
        }
        this.getAppEngineFactory().deployment().deploy((DeployConfiguration)this);
    }

    public List<File> getDeployables() {
        return this.deployables;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public Boolean getPromote() {
        return this.promote;
    }

    public String getServer() {
        return this.server;
    }

    public Boolean getStopPreviousVersion() {
        return this.stopPreviousVersion;
    }

    public String getVersion() {
        return this.version;
    }

    public String getProject() {
        return this.project;
    }
}

