/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.maven;

import com.google.cloud.tools.appengine.api.AppEngineException;
import com.google.cloud.tools.appengine.api.debug.GenRepoInfoFileConfiguration;
import com.google.cloud.tools.maven.CloudSdkMojo;
import java.io.File;
import java.nio.file.Paths;
import java.util.logging.Logger;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="genRepoInfoFile")
@Execute(phase=LifecyclePhase.PREPARE_PACKAGE)
public class GenRepoInfoFileMojo
extends CloudSdkMojo
implements GenRepoInfoFileConfiguration {
    private static Logger logger = Logger.getLogger(GenRepoInfoFileMojo.class.getName());
    private static final String HOW_TO_FIX_MSG = "An error occurred while generating source context files. Make sure your project is in a Git repository. To ignore source context generation errors, use the -Dapp.genRepoInfoFile.ignoreErrors=true flag.";
    @Parameter(alias="genRepoInfoFile.sourceDirectory", defaultValue="${project.basedir}", property="app.genRepoInfoFile.sourceDirectory")
    protected File sourceDirectory;
    @Parameter(alias="genRepoInfoFile.outputDirectory", defaultValue="${project.build.outputDirectory}", property="app.genRepoInfoFile.outputDirectory")
    protected String outputDirectory;
    @Parameter(alias="genRepoInfoFile.ignoreErrors", defaultValue="false", property="app.genRepoInfoFile.ignoreErrors")
    protected boolean ignoreErrors;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.getAppEngineFactory().genRepoInfoFile().generate((GenRepoInfoFileConfiguration)this);
        }
        catch (AppEngineException aee) {
            if (!this.ignoreErrors) {
                throw new MojoExecutionException(HOW_TO_FIX_MSG, (Exception)((Object)aee));
            }
            logger.warning(HOW_TO_FIX_MSG);
        }
    }

    public File getSourceDirectory() {
        return this.sourceDirectory;
    }

    public File getOutputDirectory() {
        return Paths.get(this.outputDirectory, new String[0]).toFile();
    }
}

