/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.maven;

import com.google.cloud.tools.appengine.api.devserver.RunConfiguration;
import com.google.cloud.tools.maven.AppEngineFactory;
import com.google.cloud.tools.maven.CloudSdkMojo;
import com.google.cloud.tools.maven.util.CollectionUtil;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Build;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="run")
@Execute(phase=LifecyclePhase.PACKAGE)
public class RunMojo
extends CloudSdkMojo
implements RunConfiguration {
    @Deprecated
    @Parameter(alias="devserver.appYamls", property="app.devserver.appYamls")
    protected List<File> appYamls;
    @Parameter(alias="devserver.services", property="app.devserver.services", required=true)
    protected List<File> services;
    @Parameter(alias="devserver.version", property="app.devserver.version", required=true, defaultValue="1")
    protected String devserverVersion;
    @Parameter(alias="devserver.host", property="app.devserver.host")
    protected String host;
    @Parameter(alias="devserver.port", property="app.devserver.port")
    protected Integer port;
    @Parameter(alias="devserver.adminHost", property="app.devserver.adminHost")
    protected String adminHost;
    @Parameter(alias="devserver.adminPort", property="app.devserver.adminPort")
    protected Integer adminPort;
    @Parameter(alias="devserver.authDomain", property="app.devserver.authDomain")
    protected String authDomain;
    @Parameter(alias="devserver.storagePath", property="app.devserver.storagePath")
    protected File storagePath;
    @Parameter(alias="devserver.datastorePath", property="app.devserver.datastorePath")
    protected File datastorePath;
    @Parameter(alias="devserver.logLevel", property="app.devserver.logLevel")
    protected String logLevel;
    @Parameter(alias="devserver.maxModuleInstances", property="app.devserver.maxModuleInstances")
    protected Integer maxModuleInstances;
    @Parameter(alias="devserver.useMtimeFileWatcher", property="app.devserver.useMtimeFileWatcher")
    protected Boolean useMtimeFileWatcher;
    @Parameter(alias="devserver.threadsafeOverride", property="app.devserver.threadsafeOverride")
    protected String threadsafeOverride;
    @Parameter(alias="devserver.pythonStartupScript", property="app.devserver.pythonStartupScript")
    protected String pythonStartupScript;
    @Parameter(alias="devserver.pythonStartupArgs", property="app.devserver.pythonStartupArgs")
    protected String pythonStartupArgs;
    @Parameter(alias="devserver.jvmFlags", property="app.devserver.jvmFlags")
    protected List<String> jvmFlags;
    @Parameter(alias="devserver.customEntrypoint", property="app.devserver.customEntrypoint")
    protected String customEntrypoint;
    @Parameter(alias="devserver.runtime", property="app.devserver.runtime")
    protected String runtime;
    @Parameter(alias="devserver.allowSkippedFiles", property="app.devserver.allowSkippedFiles")
    protected Boolean allowSkippedFiles;
    @Parameter(alias="devserver.apiPort", property="app.devserver.apiPort")
    protected Integer apiPort;
    @Parameter(alias="devserver.automaticRestart", property="app.devserver.automaticRestart")
    protected Boolean automaticRestart;
    @Parameter(alias="devserver.devAppserverLogLevel", property="app.devserver.devAppserverLogLevel")
    protected String devAppserverLogLevel;
    @Parameter(alias="devserver.skipSdkUpdateCheck", property="app.devserver.skipSdkUpdateCheck")
    protected Boolean skipSdkUpdateCheck;
    @Parameter(alias="devserver.defaultGcsBucketName", property="app.devserver.defaultGcsBucketName")
    protected String defaultGcsBucketName;
    @Parameter(alias="devserver.clearDatastore", property="app.devserver.clearDatastore")
    protected Boolean clearDatastore;
    @Parameter(alias="devserver.environment", property="app.devserver.environment")
    protected Map<String, String> environment;

    public void execute() throws MojoExecutionException, MojoFailureException {
        AppEngineFactory.SupportedDevServerVersion convertedVersion = this.convertDevserverVersionString();
        this.handleAppYamlsDeprecation();
        this.verifyAppEngineStandardApp();
        this.runServer(convertedVersion);
    }

    protected void runServer(AppEngineFactory.SupportedDevServerVersion convertedVersion) {
        this.getAppEngineFactory().devServerRunSync(convertedVersion).run((RunConfiguration)this);
    }

    protected AppEngineFactory.SupportedDevServerVersion convertDevserverVersionString() throws MojoExecutionException {
        try {
            return AppEngineFactory.SupportedDevServerVersion.parse(this.devserverVersion);
        }
        catch (IllegalArgumentException ex) {
            throw new MojoExecutionException("Invalid version", (Exception)ex);
        }
    }

    protected void handleAppYamlsDeprecation() throws MojoExecutionException {
        if (CollectionUtil.isNullOrEmpty(this.appYamls)) {
            if (CollectionUtil.isNullOrEmpty(this.services)) {
                Build build = this.mavenProject.getBuild();
                this.services = Collections.singletonList(new File(build.getDirectory()).toPath().resolve(build.getFinalName()).toFile());
            }
        } else {
            this.getLog().warn((CharSequence)"<appYamls> is deprecated, use <services> instead.");
            if (CollectionUtil.isNullOrEmpty(this.services)) {
                this.services = this.appYamls;
            } else {
                throw new MojoExecutionException("Both <appYamls> and <services> are defined. <appYamls> is deprecated, use <services> only.");
            }
        }
    }

    protected boolean isStandardEnvironmentApp() {
        return this.mavenProject != null && this.mavenProject.getBuild() != null && new File(this.mavenProject.getBuild().getDirectory() + "/" + this.mavenProject.getBuild().getFinalName() + "/WEB-INF/appengine-web.xml").exists();
    }

    protected void verifyAppEngineStandardApp() throws MojoExecutionException {
        if (!this.isStandardEnvironmentApp()) {
            throw new MojoExecutionException("Dev App Server does not support App Engine Flexible Environment applications.");
        }
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getAdminHost() {
        return this.adminHost;
    }

    public Integer getAdminPort() {
        return this.adminPort;
    }

    public String getAuthDomain() {
        return this.authDomain;
    }

    public File getStoragePath() {
        return this.storagePath;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public Integer getMaxModuleInstances() {
        return this.maxModuleInstances;
    }

    public Boolean getUseMtimeFileWatcher() {
        return this.useMtimeFileWatcher;
    }

    public String getThreadsafeOverride() {
        return this.threadsafeOverride;
    }

    public String getPythonStartupScript() {
        return this.pythonStartupScript;
    }

    public String getPythonStartupArgs() {
        return this.pythonStartupArgs;
    }

    public List<String> getJvmFlags() {
        return this.jvmFlags;
    }

    public String getCustomEntrypoint() {
        return this.customEntrypoint;
    }

    public String getRuntime() {
        return this.runtime;
    }

    public Boolean getAllowSkippedFiles() {
        return this.allowSkippedFiles;
    }

    public Integer getApiPort() {
        return this.apiPort;
    }

    public Boolean getAutomaticRestart() {
        return this.automaticRestart;
    }

    public String getDevAppserverLogLevel() {
        return this.devAppserverLogLevel;
    }

    public Boolean getSkipSdkUpdateCheck() {
        return this.skipSdkUpdateCheck;
    }

    public String getDefaultGcsBucketName() {
        return this.defaultGcsBucketName;
    }

    public Boolean getClearDatastore() {
        return this.clearDatastore;
    }

    public List<File> getServices() {
        return this.services;
    }

    public File getDatastorePath() {
        return this.datastorePath;
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }
}

