/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.maven;

import com.google.cloud.tools.appengine.api.deploy.StageFlexibleConfiguration;
import com.google.cloud.tools.appengine.api.deploy.StageStandardConfiguration;
import com.google.cloud.tools.maven.CloudSdkMojo;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@Mojo(name="stage")
@Execute(phase=LifecyclePhase.PACKAGE)
public class StageMojo
extends CloudSdkMojo
implements StageStandardConfiguration,
StageFlexibleConfiguration {
    @Parameter(required=true, defaultValue="${project.build.directory}/appengine-staging", alias="stage.stagingDirectory", property="app.stage.stagingDirectory")
    protected File stagingDirectory;
    @Parameter(alias="stage.dockerfile", property="app.stage.dockerfile")
    protected File dockerfile;
    @Parameter(required=true, defaultValue="${project.build.directory}/${project.build.finalName}", alias="stage.sourceDirectory", property="app.stage.sourceDirectory")
    protected File sourceDirectory;
    @Parameter(alias="stage.enableQuickstart", property="app.stage.enableQuickstart")
    protected boolean enableQuickstart;
    @Parameter(alias="stage.enableJarSplitting", property="app.stage.enableJarSplitting")
    protected boolean enableJarSplitting;
    @Parameter(alias="stage.jarSplittingExcludes", property="app.stage.jarSplittingExcludes")
    protected String jarSplittingExcludes;
    @Parameter(alias="stage.compileEncoding", property="app.stage.compileEncoding")
    protected String compileEncoding;
    @Parameter(alias="stage.deleteJsps", property="app.stage.deleteJsps")
    protected boolean deleteJsps;
    @Parameter(alias="stage.disableJarJsps", property="app.stage.disableJarJsps")
    protected boolean disableJarJsps;
    @Parameter(alias="stage.enableJarClasses", property="app.stage.enableJarClasses")
    protected boolean enableJarClasses;
    private boolean disableUpdateCheck = true;
    private String runtime;
    @Parameter(defaultValue="${basedir}/src/main/docker/Dockerfile", readonly=true)
    private File dockerfilePrimaryDefaultLocation;
    @Parameter(defaultValue="${basedir}/src/main/appengine/Dockerfile", readonly=true)
    private File dockerfileSecondaryDefaultLocation;
    @Parameter(alias="stage.appEngineDirectory", property="app.stage.appEngineDirectory")
    protected File appEngineDirectory;
    @Parameter(defaultValue="${basedir}/src/main/docker/", alias="stage.dockerDirectory", property="app.stage.dockerDirectory")
    protected File dockerDirectory;
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}.${project.packaging}", alias="stage.artifact", property="app.stage.artifact")
    protected File artifact;
    private AppEngineWebXml appengineWebXml;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!"war".equals(this.getPackaging()) && !"jar".equals(this.getPackaging())) {
            this.getLog().info((CharSequence)"Staging is only executed for war and jar modules.");
            return;
        }
        if (this.stagingDirectory.exists()) {
            this.getLog().info((CharSequence)("Deleting the staging directory: " + this.stagingDirectory));
            try {
                FileUtils.deleteDirectory((File)this.stagingDirectory);
            }
            catch (IOException e) {
                throw new MojoFailureException("Unable to delete staging directory.", (Throwable)e);
            }
        }
        if (!this.stagingDirectory.mkdir()) {
            throw new MojoExecutionException("Unable to create staging directory");
        }
        this.getLog().info((CharSequence)("Staging the application to: " + this.stagingDirectory));
        this.appengineWebXml = new AppEngineWebXml(new File(this.sourceDirectory.toString() + "/WEB-INF/appengine-web.xml"));
        this.configureAppEngineDirectory();
        if (this.isStandardStaging()) {
            this.getLog().info((CharSequence)"Detected App Engine standard environment application.");
            if (Float.parseFloat(this.getCompileTargetVersion()) > 1.7f && this.appengineWebXml.isVm()) {
                this.runtime = "java";
            }
            this.configureDockerfileDefaultLocation();
            this.getAppEngineFactory().standardStaging().stageStandard((StageStandardConfiguration)this);
        } else {
            this.getLog().info((CharSequence)"Detected App Engine flexible environment application.");
            this.getAppEngineFactory().flexibleStaging().stageFlexible((StageFlexibleConfiguration)this);
        }
    }

    protected boolean isStandardStaging() {
        return this.appengineWebXml.exists();
    }

    protected void configureDockerfileDefaultLocation() {
        if (this.dockerfile == null) {
            if (this.dockerfilePrimaryDefaultLocation != null && this.dockerfilePrimaryDefaultLocation.exists()) {
                this.dockerfile = this.dockerfilePrimaryDefaultLocation;
            } else if (this.dockerfileSecondaryDefaultLocation != null && this.dockerfileSecondaryDefaultLocation.exists()) {
                this.dockerfile = this.dockerfileSecondaryDefaultLocation;
            }
        }
    }

    protected void configureAppEngineDirectory() {
        if (this.appEngineDirectory == null) {
            this.appEngineDirectory = this.mavenProject.getBasedir().toPath().resolve("src/main/appengine").toFile();
        }
    }

    public File getSourceDirectory() {
        return this.sourceDirectory;
    }

    public File getStagingDirectory() {
        return this.stagingDirectory;
    }

    public File getDockerfile() {
        return this.dockerfile;
    }

    public Boolean getEnableQuickstart() {
        return this.enableQuickstart;
    }

    public Boolean getDisableUpdateCheck() {
        return this.disableUpdateCheck;
    }

    public Boolean getEnableJarSplitting() {
        return this.enableJarSplitting;
    }

    public String getJarSplittingExcludes() {
        return this.jarSplittingExcludes;
    }

    public String getCompileEncoding() {
        return this.compileEncoding;
    }

    public Boolean getDeleteJsps() {
        return this.deleteJsps;
    }

    public Boolean getEnableJarClasses() {
        return this.enableJarClasses;
    }

    public File getAppEngineDirectory() {
        return this.appEngineDirectory;
    }

    public File getArtifact() {
        return this.artifact;
    }

    public Boolean getDisableJarJsps() {
        return this.disableJarJsps;
    }

    public File getDockerDirectory() {
        return this.dockerDirectory;
    }

    public String getRuntime() {
        return this.runtime;
    }

    @VisibleForTesting
    public void setStagingDirectory(File stagingDirectory) {
        this.stagingDirectory = stagingDirectory;
    }

    @VisibleForTesting
    public void setSourceDirectory(File sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
    }

    private static class AppEngineWebXml {
        private final Document document;

        private AppEngineWebXml(File appengineWebXml) throws MojoExecutionException {
            try {
                this.document = appengineWebXml.exists() ? DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(appengineWebXml) : null;
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                throw new MojoExecutionException("Failed to parse appengine-web.xml", e);
            }
        }

        public static AppEngineWebXml parse(File appengineWebXml) throws MojoExecutionException {
            return new AppEngineWebXml(appengineWebXml);
        }

        public boolean exists() {
            return this.document != null;
        }

        public boolean isVm() throws MojoExecutionException {
            try {
                XPath xpath = XPathFactory.newInstance().newXPath();
                String expression = "/appengine-web-app/vm/text()='true'";
                return (Boolean)xpath.evaluate(expression, this.document, XPathConstants.BOOLEAN);
            }
            catch (XPathExpressionException e) {
                throw new MojoExecutionException("XPath evaluation failed on appengine-web.xml", (Exception)e);
            }
        }
    }
}

