/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.maven;

import com.google.cloud.tools.appengine.api.devserver.StopConfiguration;
import com.google.cloud.tools.maven.AppEngineFactory;
import com.google.cloud.tools.maven.CloudSdkMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="stop")
public class StopMojo
extends CloudSdkMojo
implements StopConfiguration {
    @Parameter(alias="devserver.version", property="app.devserver.version", required=true, defaultValue="1")
    protected String devserverVersion;
    @Parameter(alias="devserver.host", property="app.devserver.host")
    protected String host;
    @Parameter(alias="devserver.port", property="app.devserver.port")
    protected Integer port;
    @Parameter(alias="devserver.adminHost", property="app.devserver.adminHost")
    protected String adminHost;
    @Parameter(alias="devserver.adminPort", property="app.devserver.adminPort")
    protected Integer adminPort;

    public void execute() throws MojoExecutionException, MojoFailureException {
        AppEngineFactory.SupportedDevServerVersion convertedVersion = null;
        try {
            convertedVersion = AppEngineFactory.SupportedDevServerVersion.parse(this.devserverVersion);
        }
        catch (IllegalArgumentException ex) {
            throw new MojoExecutionException("Invalid version", (Exception)ex);
        }
        this.getAppEngineFactory().devServerStop(convertedVersion).stop((StopConfiguration)this);
    }

    public String getAdminHost() {
        if (AppEngineFactory.SupportedDevServerVersion.parse(this.devserverVersion) == AppEngineFactory.SupportedDevServerVersion.V2ALPHA) {
            return this.adminHost;
        }
        return this.host;
    }

    public Integer getAdminPort() {
        if (AppEngineFactory.SupportedDevServerVersion.parse(this.devserverVersion) == AppEngineFactory.SupportedDevServerVersion.V2ALPHA) {
            return this.adminPort;
        }
        return this.port;
    }
}

