/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.blob;

import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.hash.Digests;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class InputStreamBlob
implements Blob {
    private final InputStream inputStream;
    private boolean isWritten = false;

    InputStreamBlob(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    @Override
    public BlobDescriptor writeTo(OutputStream outStream) throws IOException {
        if (this.isWritten) {
            throw new IllegalStateException("Cannot rewrite Blob backed by an InputStream");
        }
        try {
            BlobDescriptor blobDescriptor;
            block10: {
                InputStream inStream = this.inputStream;
                try {
                    blobDescriptor = Digests.computeDigest(inStream, outStream);
                    if (inStream == null) break block10;
                }
                catch (Throwable throwable) {
                    if (inStream != null) {
                        try {
                            inStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                inStream.close();
            }
            return blobDescriptor;
        }
        finally {
            this.isWritten = true;
        }
    }

    @Override
    public boolean isRetryable() {
        return false;
    }
}

