/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.cache;

import com.google.cloud.tools.jib.api.DescriptorDigest;
import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.blob.Blobs;
import com.google.cloud.tools.jib.cache.CacheCorruptedException;
import com.google.cloud.tools.jib.cache.CacheStorageFiles;
import com.google.cloud.tools.jib.cache.CachedLayer;
import com.google.cloud.tools.jib.filesystem.LockFile;
import com.google.cloud.tools.jib.image.json.BuildableManifestTemplate;
import com.google.cloud.tools.jib.image.json.ContainerConfigurationTemplate;
import com.google.cloud.tools.jib.image.json.ImageMetadataTemplate;
import com.google.cloud.tools.jib.image.json.ManifestAndConfigTemplate;
import com.google.cloud.tools.jib.image.json.ManifestTemplate;
import com.google.cloud.tools.jib.image.json.V21ManifestTemplate;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.DigestException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class CacheStorageReader {
    private final CacheStorageFiles cacheStorageFiles;

    @VisibleForTesting
    static void verifyImageMetadata(ImageMetadataTemplate metadata, Path metadataCacheDirectory) throws CacheCorruptedException {
        List<ManifestAndConfigTemplate> manifestsAndConfigs = metadata.getManifestsAndConfigs();
        if (manifestsAndConfigs.isEmpty()) {
            throw new CacheCorruptedException(metadataCacheDirectory, "Manifest cache empty");
        }
        if (manifestsAndConfigs.stream().anyMatch(entry -> entry.getManifest() == null)) {
            throw new CacheCorruptedException(metadataCacheDirectory, "Manifest(s) missing");
        }
        if (metadata.getManifestList() == null && manifestsAndConfigs.size() != 1) {
            throw new CacheCorruptedException(metadataCacheDirectory, "Manifest list missing");
        }
        ManifestTemplate firstManifest = manifestsAndConfigs.get(0).getManifest();
        if (firstManifest instanceof V21ManifestTemplate) {
            if (metadata.getManifestList() != null || manifestsAndConfigs.stream().anyMatch(entry -> entry.getConfig() != null)) {
                throw new CacheCorruptedException(metadataCacheDirectory, "Schema 1 manifests corrupted");
            }
        } else if (firstManifest instanceof BuildableManifestTemplate) {
            if (manifestsAndConfigs.stream().anyMatch(entry -> entry.getConfig() == null)) {
                throw new CacheCorruptedException(metadataCacheDirectory, "Schema 2 manifests corrupted");
            }
            if (metadata.getManifestList() != null && manifestsAndConfigs.stream().anyMatch(entry -> entry.getManifestDigest() == null)) {
                throw new CacheCorruptedException(metadataCacheDirectory, "Schema 2 manifests corrupted");
            }
        } else {
            throw new CacheCorruptedException(metadataCacheDirectory, "Unknown manifest type: " + firstManifest);
        }
    }

    CacheStorageReader(CacheStorageFiles cacheStorageFiles) {
        this.cacheStorageFiles = cacheStorageFiles;
    }

    boolean areAllLayersCached(ManifestTemplate manifest) {
        List<DescriptorDigest> layerDigests;
        if (manifest instanceof V21ManifestTemplate) {
            layerDigests = ((V21ManifestTemplate)manifest).getLayerDigests();
        } else if (manifest instanceof BuildableManifestTemplate) {
            layerDigests = ((BuildableManifestTemplate)manifest).getLayers().stream().map(BuildableManifestTemplate.ContentDescriptorTemplate::getDigest).collect(Collectors.toList());
        } else {
            throw new IllegalArgumentException("Unknown manifest type: " + manifest);
        }
        for (DescriptorDigest layerDigest : layerDigests) {
            Path layerDirectory = this.cacheStorageFiles.getLayerDirectory(layerDigest);
            if (Files.exists(layerDirectory, new LinkOption[0])) continue;
            return false;
        }
        return true;
    }

    Optional<ImageMetadataTemplate> retrieveMetadata(ImageReference imageReference) throws IOException, CacheCorruptedException {
        ImageMetadataTemplate metadata;
        Path imageDirectory = this.cacheStorageFiles.getImageDirectory(imageReference);
        Path metadataPath = imageDirectory.resolve("manifests_configs.json");
        if (!Files.exists(metadataPath, new LinkOption[0])) {
            return Optional.empty();
        }
        try (LockFile ignored = LockFile.lock(imageDirectory.resolve("lock"));){
            metadata = JsonTemplateMapper.readJsonFromFile(metadataPath, ImageMetadataTemplate.class);
        }
        CacheStorageReader.verifyImageMetadata(metadata, imageDirectory);
        return Optional.of(metadata);
    }

    Optional<CachedLayer> retrieve(DescriptorDigest layerDigest) throws IOException, CacheCorruptedException {
        Path layerDirectory = this.cacheStorageFiles.getLayerDirectory(layerDigest);
        if (!Files.exists(layerDirectory, new LinkOption[0])) {
            return Optional.empty();
        }
        try (Stream<Path> files = Files.list(layerDirectory);){
            List layerFiles = files.filter(CacheStorageFiles::isLayerFile).collect(Collectors.toList());
            if (layerFiles.size() != 1) {
                throw new CacheCorruptedException(this.cacheStorageFiles.getCacheDirectory(), "No or multiple layer files found for layer hash " + layerDigest.getHash() + " in directory: " + layerDirectory);
            }
            Path layerFile = (Path)layerFiles.get(0);
            Optional<CachedLayer> optional = Optional.of(CachedLayer.builder().setLayerDigest(layerDigest).setLayerSize(Files.size(layerFile)).setLayerBlob(Blobs.from(layerFile)).setLayerDiffId(this.cacheStorageFiles.getDigestFromFilename(layerFile)).build());
            return optional;
        }
    }

    Optional<CachedLayer> retrieveTarLayer(DescriptorDigest diffId) throws IOException, CacheCorruptedException {
        Path layerDirectory = this.cacheStorageFiles.getLocalDirectory().resolve(diffId.getHash());
        if (!Files.exists(layerDirectory, new LinkOption[0])) {
            return Optional.empty();
        }
        try (Stream<Path> files = Files.list(layerDirectory);){
            List layerFiles = files.filter(CacheStorageFiles::isLayerFile).collect(Collectors.toList());
            if (layerFiles.size() != 1) {
                throw new CacheCorruptedException(this.cacheStorageFiles.getCacheDirectory(), "No or multiple layer files found for layer hash " + diffId.getHash() + " in directory: " + layerDirectory);
            }
            Path layerFile = (Path)layerFiles.get(0);
            Optional<CachedLayer> optional = Optional.of(CachedLayer.builder().setLayerDigest(this.cacheStorageFiles.getDigestFromFilename(layerFile)).setLayerSize(Files.size(layerFile)).setLayerBlob(Blobs.from(layerFile)).setLayerDiffId(diffId).build());
            return optional;
        }
    }

    Optional<ContainerConfigurationTemplate> retrieveLocalConfig(DescriptorDigest imageId) throws IOException {
        Path configPath = this.cacheStorageFiles.getLocalDirectory().resolve("config").resolve(imageId.getHash());
        if (!Files.exists(configPath, new LinkOption[0])) {
            return Optional.empty();
        }
        ContainerConfigurationTemplate config = JsonTemplateMapper.readJsonFromFile(configPath, ContainerConfigurationTemplate.class);
        return Optional.of(config);
    }

    Optional<DescriptorDigest> select(DescriptorDigest selector) throws CacheCorruptedException, IOException {
        Path selectorFile = this.cacheStorageFiles.getSelectorFile(selector);
        if (!Files.exists(selectorFile, new LinkOption[0])) {
            return Optional.empty();
        }
        String selectorFileContents = new String(Files.readAllBytes(selectorFile), StandardCharsets.UTF_8);
        try {
            return Optional.of(DescriptorDigest.fromHash(selectorFileContents));
        }
        catch (DigestException ex) {
            throw new CacheCorruptedException(this.cacheStorageFiles.getCacheDirectory(), "Expected valid layer digest as contents of selector file `" + selectorFile + "` for selector `" + selector.getHash() + "`, but got: " + selectorFileContents);
        }
    }
}

