/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.docker;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.cloud.tools.jib.api.DescriptorDigest;
import com.google.cloud.tools.jib.api.DockerClient;
import com.google.cloud.tools.jib.api.DockerInfoDetails;
import com.google.cloud.tools.jib.api.ImageDetails;
import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.http.NotifyingOutputStream;
import com.google.cloud.tools.jib.image.ImageTarball;
import com.google.cloud.tools.jib.json.JsonTemplate;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.DigestException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

public class CliDockerClient
implements DockerClient {
    public static final Path DEFAULT_DOCKER_CLIENT = Paths.get("docker", new String[0]);
    private final Function<List<String>, ProcessBuilder> processBuilderFactory;

    public static boolean isDefaultDockerInstalled() {
        try {
            new ProcessBuilder(DEFAULT_DOCKER_CLIENT.toString()).start();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static boolean isDockerInstalled(Path dockerExecutable) {
        return Files.exists(dockerExecutable, new LinkOption[0]);
    }

    @VisibleForTesting
    static Function<List<String>, ProcessBuilder> defaultProcessBuilderFactory(String dockerExecutable, ImmutableMap<String, String> dockerEnvironment) {
        return dockerSubCommand -> {
            ArrayList<String> dockerCommand = new ArrayList<String>(1 + dockerSubCommand.size());
            dockerCommand.add(dockerExecutable);
            dockerCommand.addAll((Collection<String>)dockerSubCommand);
            ProcessBuilder processBuilder = new ProcessBuilder(dockerCommand);
            Map<String, String> environment = processBuilder.environment();
            environment.putAll((Map<String, String>)dockerEnvironment);
            return processBuilder;
        };
    }

    private static String getStderrOutput(Process process) {
        String string;
        InputStreamReader stderr = new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8);
        try {
            string = CharStreams.toString((Readable)stderr);
        }
        catch (Throwable throwable) {
            try {
                try {
                    stderr.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                return "unknown (failed to read error message from stderr due to " + ex.getMessage() + ")";
            }
        }
        stderr.close();
        return string;
    }

    public CliDockerClient(Path dockerExecutable, Map<String, String> dockerEnvironment) {
        this(CliDockerClient.defaultProcessBuilderFactory(dockerExecutable.toString(), (ImmutableMap<String, String>)ImmutableMap.copyOf(dockerEnvironment)));
    }

    @VisibleForTesting
    CliDockerClient(Function<List<String>, ProcessBuilder> processBuilderFactory) {
        this.processBuilderFactory = processBuilderFactory;
    }

    @Override
    public boolean supported(Map<String, String> parameters) {
        return true;
    }

    @Override
    public DockerInfoDetails info() throws IOException, InterruptedException {
        Process infoProcess = this.docker("info", "-f", "{{json .}}");
        InputStream inputStream = infoProcess.getInputStream();
        if (infoProcess.waitFor() != 0) {
            throw new IOException("'docker info' command failed with error: " + CliDockerClient.getStderrOutput(infoProcess));
        }
        return JsonTemplateMapper.readJson(inputStream, DockerInfoDetails.class);
    }

    @Override
    public String load(ImageTarball imageTarball, Consumer<Long> writtenByteCountListener) throws InterruptedException, IOException {
        Process dockerProcess = this.docker("load");
        try (NotifyingOutputStream stdin = new NotifyingOutputStream(dockerProcess.getOutputStream(), writtenByteCountListener);){
            imageTarball.writeTo(stdin);
        }
        catch (IOException ex) {
            String error;
            try (InputStreamReader stderr = new InputStreamReader(dockerProcess.getErrorStream(), StandardCharsets.UTF_8);){
                error = CharStreams.toString((Readable)stderr);
            }
            catch (IOException ignored) {
                error = ex.getMessage();
            }
            throw new IOException("'docker load' command failed with error: " + error, ex);
        }
        try (InputStreamReader stdout = new InputStreamReader(dockerProcess.getInputStream(), StandardCharsets.UTF_8);){
            String output = CharStreams.toString((Readable)stdout);
            if (dockerProcess.waitFor() != 0) {
                throw new IOException("'docker load' command failed with error: " + CliDockerClient.getStderrOutput(dockerProcess));
            }
            String string = output;
            return string;
        }
    }

    @Override
    public void save(ImageReference imageReference, Path outputPath, Consumer<Long> writtenByteCountListener) throws InterruptedException, IOException {
        Process dockerProcess = this.docker("save", imageReference.toString());
        try (BufferedInputStream stdout = new BufferedInputStream(dockerProcess.getInputStream());
             BufferedOutputStream fileStream = new BufferedOutputStream(Files.newOutputStream(outputPath, new OpenOption[0]));
             NotifyingOutputStream notifyingFileStream = new NotifyingOutputStream(fileStream, writtenByteCountListener);){
            ByteStreams.copy((InputStream)stdout, (OutputStream)notifyingFileStream);
        }
        if (dockerProcess.waitFor() != 0) {
            throw new IOException("'docker save' command failed with error: " + CliDockerClient.getStderrOutput(dockerProcess));
        }
    }

    @Override
    public DockerImageDetails inspect(ImageReference imageReference) throws IOException, InterruptedException {
        Process inspectProcess = this.docker("inspect", "-f", "{{json .}}", "--type", "image", imageReference.toString());
        if (inspectProcess.waitFor() != 0) {
            throw new IOException("'docker inspect' command failed with error: " + CliDockerClient.getStderrOutput(inspectProcess));
        }
        return JsonTemplateMapper.readJson(inspectProcess.getInputStream(), DockerImageDetails.class);
    }

    private Process docker(String ... subCommand) throws IOException {
        return this.processBuilderFactory.apply(Arrays.asList(subCommand)).start();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DockerImageDetails
    implements JsonTemplate,
    ImageDetails {
        @JsonProperty(value="Size")
        private long size;
        @JsonProperty(value="Id")
        private String imageId = "";
        @JsonProperty(value="RootFS")
        private final RootFsTemplate rootFs = new RootFsTemplate();

        @Override
        public long getSize() {
            return this.size;
        }

        @Override
        public DescriptorDigest getImageId() throws DigestException {
            return DescriptorDigest.fromDigest(this.imageId);
        }

        @Override
        public List<DescriptorDigest> getDiffIds() throws DigestException {
            ArrayList<DescriptorDigest> processedDiffIds = new ArrayList<DescriptorDigest>(this.rootFs.layers.size());
            for (String diffId : this.rootFs.layers) {
                processedDiffIds.add(DescriptorDigest.fromDigest(diffId.trim()));
            }
            return processedDiffIds;
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        private static class RootFsTemplate
        implements JsonTemplate {
            @JsonProperty(value="Layers")
            private final List<String> layers = Collections.emptyList();

            private RootFsTemplate() {
            }
        }
    }
}

