/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven.extension.nativeimage;

import com.google.cloud.tools.jib.api.JavaContainerBuilder;
import com.google.cloud.tools.jib.api.buildplan.AbsoluteUnixPath;
import com.google.cloud.tools.jib.api.buildplan.ContainerBuildPlan;
import com.google.cloud.tools.jib.api.buildplan.FileEntriesLayer;
import com.google.cloud.tools.jib.api.buildplan.FilePermissions;
import com.google.cloud.tools.jib.maven.extension.JibMavenPluginExtension;
import com.google.cloud.tools.jib.maven.extension.MavenData;
import com.google.cloud.tools.jib.maven.extension.nativeimage.ConfigValueLocation;
import com.google.cloud.tools.jib.plugins.extension.ExtensionLogger;
import com.google.cloud.tools.jib.plugins.extension.JibPluginExtensionException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class JibNativeImageExtension
implements JibMavenPluginExtension<Void> {
    private static final ConfigValueLocation JIB_APP_ROOT = new ConfigValueLocation("com.google.cloud.tools:jib-maven-plugin", ConfigValueLocation.ValueContainer.CONFIGURATION, new String[]{"container", "appRoot"});
    private static final ConfigValueLocation JIB_ENTRYPOINT = new ConfigValueLocation("com.google.cloud.tools:jib-maven-plugin", ConfigValueLocation.ValueContainer.CONFIGURATION, new String[]{"container", "entrypoint"});
    private static final ConfigValueLocation NATIVE_IMAGE_PLUGIN_IMAGE_NAME = new ConfigValueLocation("org.graalvm.nativeimage:native-image-maven-plugin", ConfigValueLocation.ValueContainer.CONFIGURATION, new String[]{"imageName"});
    private static final ImmutableList<ConfigValueLocation> MAIN_CLASS_LOCATIONS = ImmutableList.of((Object)new ConfigValueLocation("org.graalvm.nativeimage:native-image-maven-plugin", ConfigValueLocation.ValueContainer.CONFIGURATION, new String[]{"mainClass"}), (Object)new ConfigValueLocation("org.apache.maven.plugins:maven-shade-plugin", ConfigValueLocation.ValueContainer.EXECUTIONS, new String[]{"transformers", "transformer", "mainClass"}), (Object)new ConfigValueLocation("org.apache.maven.plugins:maven-assembly-plugin", ConfigValueLocation.ValueContainer.CONFIGURATION, new String[]{"archive", "manifest", "mainClass"}), (Object)new ConfigValueLocation("org.apache.maven.plugins:maven-jar-plugin", ConfigValueLocation.ValueContainer.CONFIGURATION, new String[]{"archive", "manifest", "mainClass"}));

    public Optional<Class<Void>> getExtraConfigType() {
        return Optional.empty();
    }

    public ContainerBuildPlan extendContainerBuildPlan(ContainerBuildPlan buildPlan, Map<String, String> properties, Optional<Void> config, MavenData mavenData, ExtensionLogger logger) throws JibPluginExtensionException {
        logger.log(ExtensionLogger.LogLevel.LIFECYCLE, "Running Jib Native Image extension");
        MavenProject project = mavenData.getMavenProject();
        Optional<String> executableName = JibNativeImageExtension.getExecutableName(project, properties);
        if (!executableName.isPresent()) {
            throw new JibPluginExtensionException(this.getClass(), "cannot auto-detect native-image executable name; consider setting 'imageName' property");
        }
        String outputDirectory = project.getBuild().getDirectory();
        Path localExecutable = Paths.get(outputDirectory, executableName.get());
        if (!Files.isRegularFile(localExecutable, new LinkOption[0])) {
            throw new JibPluginExtensionException(this.getClass(), "Native-image executable does not exist or not a file: " + localExecutable + "\nDid you run the 'native-image:native-image' goal?");
        }
        String appRoot = JibNativeImageExtension.getPluginConfigValue(project, JIB_APP_ROOT).orElse("/app");
        AbsoluteUnixPath targetExecutable = AbsoluteUnixPath.get((String)appRoot).resolve(executableName.get());
        ContainerBuildPlan.Builder planBuilder = buildPlan.toBuilder();
        FileEntriesLayer nativeImageLayer = FileEntriesLayer.builder().setName("native image").addEntry(localExecutable, targetExecutable, FilePermissions.fromOctalString((String)"755")).build();
        planBuilder.setLayers(Collections.singletonList(nativeImageLayer));
        String extraFilesLayerName = JavaContainerBuilder.LayerType.EXTRA_FILES.getName();
        buildPlan.getLayers().stream().filter(layer -> layer.getName().startsWith(extraFilesLayerName)).forEach(arg_0 -> ((ContainerBuildPlan.Builder)planBuilder).addLayer(arg_0));
        if (!JibNativeImageExtension.getPluginConfigValue(project, JIB_ENTRYPOINT).isPresent()) {
            planBuilder.setEntrypoint(Collections.singletonList(targetExecutable.toString()));
        }
        return planBuilder.build();
    }

    @VisibleForTesting
    static Optional<String> getExecutableName(MavenProject project, Map<String, String> properties) {
        String customName = properties.get("imageName");
        if (!Strings.isNullOrEmpty((String)customName)) {
            return Optional.of(customName);
        }
        Optional<String> imageName = JibNativeImageExtension.getPluginConfigValue(project, NATIVE_IMAGE_PLUGIN_IMAGE_NAME);
        if (imageName.isPresent()) {
            return imageName;
        }
        return MAIN_CLASS_LOCATIONS.stream().map(location -> JibNativeImageExtension.getPluginConfigValue(project, location)).filter(Optional::isPresent).map(Optional::get).map(name -> name.toLowerCase(Locale.US)).findFirst();
    }

    private static Optional<String> getPluginConfigValue(MavenProject project, ConfigValueLocation location) {
        Plugin plugin = project.getPlugin(location.pluginId);
        if (plugin == null) {
            return Optional.empty();
        }
        switch (location.valueContainer) {
            case CONFIGURATION: {
                return JibNativeImageExtension.getDomValue((Xpp3Dom)plugin.getConfiguration(), location.domPath);
            }
            case EXECUTIONS: {
                return plugin.getExecutions().stream().map(execution -> JibNativeImageExtension.getDomValue((Xpp3Dom)execution.getConfiguration(), location.domPath)).filter(Optional::isPresent).map(Optional::get).findFirst();
            }
        }
        throw new RuntimeException("unknown enum value: " + (Object)((Object)location.valueContainer));
    }

    @VisibleForTesting
    static Optional<String> getDomValue(@Nullable Xpp3Dom dom, String ... nodePath) {
        if (dom == null) {
            return Optional.empty();
        }
        Xpp3Dom node = dom;
        for (String child : nodePath) {
            if ((node = node.getChild(child)) != null) continue;
            return Optional.empty();
        }
        return Optional.ofNullable(node.getValue());
    }
}

